/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.gai.core.domain.dto.TrustLayerContext;
import kd.ai.gai.core.domain.dto.TrustLayerResult;
import kd.ai.gai.core.domain.llm.LLMSearchInfo;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.TrustLayerData;
import kd.ai.gai.core.engine.handler.StopStreamHandler;
import kd.ai.gai.core.engine.message.llmcallback.LLMRawMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMSplitMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.service.LlmServiceFactory;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.service.trusty.TrustLayerService;
import kd.ai.gai.core.thread.SameTraceRunnable;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class MessageSplitHandler
implements IActionCallBack<LLMSplitMessage> {
    private static final Log logger = LogFactory.getLog(MessageSplitHandler.class);
    private boolean isNeedDeMasking = false;
    private boolean isNeedCheck = false;
    private boolean isAgentFuncCall = false;
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"FakeStreamReturn", (int)10, (int)100);
    private TrustLayerContext trustLayerContext;

    private String getTaskMessageQueueBufferKey(String taskId) {
        return String.format("%s-%s", "streamMessageQueueBuffer", taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(LLMSplitMessage result) {
        block31: {
            try {
                ModelResult modelResult;
                List<LLMSearchInfo> searchList;
                int aiccSeqNo;
                if (!Errors.OK.getCode().equals(result.getErrCode())) {
                    this.passErrorMessage(result, -1);
                    return;
                }
                String taskId = String.valueOf(result.getId());
                logger.info("\u56de\u8c03" + taskId + ":" + System.currentTimeMillis());
                LocalMemoryCache taskCache = EngineCache.getLocalCache(taskId);
                this.initHandlerProperties(result, taskCache);
                String llmNumber = (String)taskCache.get("MsgSplit.LLM" + taskId);
                LLM llm = LLM.parse(llmNumber);
                if (llm == null) {
                    logger.info(String.format("\u672a\u627e\u5230llmNumber=%s \u7684LLM\u679a\u4e3e\u3002llm is null", llmNumber));
                    this.pass(result, -1);
                    return;
                }
                if (!this.isNeedDeMasking && !this.isNeedCheck) {
                    this.pass(result, -1);
                    return;
                }
                if (this.isAgentFuncCall) {
                    this.pass(result, -1);
                    return;
                }
                boolean stream = result.isStream();
                LlmService helper = LlmServiceFactory.getExecutor(llm, stream);
                String msg = null;
                String think = null;
                StringBuilder msgBuild = new StringBuilder();
                StringBuilder thinkBuild = new StringBuilder();
                boolean isEnd = false;
                for (String line : result.getResult()) {
                    ModelResult modelResult2 = helper.getResult(new ModelResultParam(stream, line));
                    if (modelResult2.getContent() != null) {
                        msgBuild.append(modelResult2.getContent());
                        continue;
                    }
                    if (modelResult2.getThink() != null) {
                        thinkBuild.append(modelResult2.getThink());
                        continue;
                    }
                    isEnd = true;
                }
                if (!isEnd) {
                    think = thinkBuild.toString();
                    msg = msgBuild.toString();
                }
                if ((aiccSeqNo = result.getStreamSeqNO()) == 0 && (searchList = (modelResult = helper.getResult(new ModelResultParam(stream, result.getResult().get(0)))).getSearchInfoList()) != null) {
                    for (LLMSearchInfo searchInfo : searchList) {
                        String summary = searchInfo.getSummary();
                        TrustLayerResult thirdCheckResult = TrustLayerService.checkOutput(summary);
                        if (thirdCheckResult.getErrorCode() == null) continue;
                        LlmService.stopGpt(Long.parseLong(taskId));
                        this.sendToQueue(result, null, null, false, true);
                    }
                    taskCache.put("MsgSplit.searchInfo" + taskId, searchList);
                }
                if (stream) {
                    if ("".equals(msg) && "".equals(think)) {
                        return;
                    }
                    if (msg == null && think == null) {
                        String streamBuffer = (String)taskCache.get("MsgSplit.streamBuffer" + taskId);
                        if (!StringUtils.isEmpty((CharSequence)streamBuffer)) {
                            this.toTrusty(result, streamBuffer, null);
                        }
                        this.toTrusty(result, null, null);
                        this.setEnd(taskId);
                    } else {
                        ArrayList<String> splitThinkList = new ArrayList<String>();
                        if (think != null) {
                            this.splitMsg(taskId, taskCache, think, splitThinkList, "MsgSplit.streamThinkBuffer");
                        } else {
                            String streamThinkBuffer = (String)taskCache.get("MsgSplit.streamThinkBuffer" + taskId);
                            if (StringUtils.isNotEmpty((CharSequence)streamThinkBuffer)) {
                                splitThinkList.add(streamThinkBuffer);
                                taskCache.remove(new String[]{"MsgSplit.streamThinkBuffer" + taskId});
                            }
                        }
                        if (!splitThinkList.isEmpty()) {
                            for (String thinkLine : splitThinkList) {
                                this.toTrusty(result, null, thinkLine);
                            }
                        }
                        ArrayList<String> splitList = new ArrayList<String>();
                        if (msg != null) {
                            this.splitMsg(taskId, taskCache, msg, splitList, "MsgSplit.streamBuffer");
                        }
                        if (!splitList.isEmpty()) {
                            for (String line : splitList) {
                                this.toTrusty(result, line, null);
                            }
                        }
                    }
                    break block31;
                }
                this.toTrusty(result, msg, think);
                this.setEnd(taskId);
            }
            catch (Exception ex) {
                ErrorCode errorCode;
                logger.error((Throwable)ex);
                if (ex instanceof KDException) {
                    errorCode = ((KDException)((Object)ex)).getErrorCode();
                } else if (ex instanceof kd.ai.gai.exception.KDException) {
                    kd.ai.gai.exception.KDException gaiKDException = (kd.ai.gai.exception.KDException)((Object)ex);
                    errorCode = new ErrorCode(gaiKDException.getErrorCode().getCode(), gaiKDException.getMessage());
                } else {
                    errorCode = Errors.builErrorCode(Errors.TRUSTY_SPLIT_ERROR, ex.getMessage());
                }
                result.setErrCode(errorCode.getCode());
                result.setErrMsg(errorCode.getMessage());
                this.passErrorMessage(result, -1);
            }
        }
    }

    private void initHandlerProperties(LLMSplitMessage result, LocalMemoryCache taskCache) {
        String taskId = String.valueOf(result.getId());
        String enable = (String)taskCache.get("MsgSplit.Enable" + taskId);
        String maskingContextStr = (String)taskCache.get("TrustLayer.MaskingContext" + taskId);
        TrustLayerContext tlCtx = null;
        if (!StringUtils.isEmpty((CharSequence)maskingContextStr)) {
            try {
                tlCtx = (TrustLayerContext)JSON.parseObject((String)maskingContextStr, TrustLayerContext.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean noDeMasking = tlCtx == null || !tlCtx.isEnableMasking() || tlCtx.getMaskingInfoList() == null || tlCtx.getMaskingInfoList().isEmpty();
        this.isNeedDeMasking = "true".equals(enable) || !noDeMasking;
        this.trustLayerContext = tlCtx;
        String checkEnable = (String)taskCache.get("TrustLayer.SensitiveCheck.Enable");
        this.isNeedCheck = "true".equals(checkEnable);
        this.isAgentFuncCall = taskCache.get("function_call_mask") != null ? (Boolean)taskCache.get("function_call_mask") : false;
    }

    private String deMasking(String llmRespLine) {
        return TrustLayerService.deMasking(llmRespLine, this.trustLayerContext);
    }

    private void splitMsg(String taskId, LocalMemoryCache taskCache, String msg, List<String> splitList, String cacheKeyPre) {
        String streamBuffer = (String)taskCache.get(cacheKeyPre + taskId);
        streamBuffer = streamBuffer == null ? "" : streamBuffer;
        StringBuilder sb = new StringBuilder(streamBuffer);
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            char ch = msg.charAt(i);
            sb.append(ch);
            if (ch != '\uff0c' && ch != '\u3002' && ch != '\uff1f' && ch != '\uff01' && ch != '\uff1a' && ch != '\uff1b' && ch != '\n' && (ch != ',' && ch != '.' && ch != '?' && ch != '!' || i >= len - 1 || msg.charAt(i + 1) != ' ')) continue;
            splitList.add(sb.toString());
            sb = new StringBuilder();
        }
        if (!splitList.isEmpty()) {
            String one = String.join((CharSequence)"", splitList);
            splitList.clear();
            splitList.add(one);
        }
        taskCache.put(cacheKeyPre + taskId, (Object)sb.toString());
    }

    private void pass(LLMSplitMessage result, int streamSeqNO) {
        LLMRawMessage llmRawMessage = new LLMRawMessage();
        llmRawMessage.setId(result.getId());
        llmRawMessage.setStatus(result.getStatus());
        llmRawMessage.setResult(result.getResult());
        llmRawMessage.setErrCode(result.getErrCode());
        llmRawMessage.setErrMsg(result.getErrMsg());
        llmRawMessage.setStream(result.isStream());
        llmRawMessage.setSearchInfoList(result.getSearchInfoList());
        if (streamSeqNO == -1) {
            llmRawMessage.setStreamSeqNO(result.getStreamSeqNO());
        } else {
            llmRawMessage.setStreamSeqNO(streamSeqNO);
        }
        HandlerFactory.callback(llmRawMessage);
    }

    private void passAfterTrusty(LLMSplitMessage result, String llmValue, String llmThink, int streamSeqNO) {
        LocalMemoryCache taskCache;
        List searchInfoJson;
        LLMRawMessage llmRawMessage = new LLMRawMessage();
        llmRawMessage.setId(result.getId());
        llmRawMessage.setStatus(result.getStatus());
        llmRawMessage.setErrCode(result.getErrCode());
        llmRawMessage.setErrMsg(result.getErrMsg());
        llmRawMessage.setStream(result.isStream());
        llmRawMessage.setParsedResult(true);
        llmRawMessage.setStreamSeqNO(streamSeqNO);
        llmRawMessage.setResult(result.getResult());
        llmRawMessage.setParsedResult(true);
        llmRawMessage.setLlmValue(llmValue);
        llmRawMessage.setLlmThinkValue(llmThink);
        if (streamSeqNO == 0 && (searchInfoJson = (List)(taskCache = EngineCache.getLocalCache(String.valueOf(result.getId()))).get("MsgSplit.searchInfo" + result.getId())) != null) {
            llmRawMessage.setSearchInfoList(searchInfoJson);
        }
        HandlerFactory.callback(llmRawMessage);
    }

    private void passErrorMessage(LLMSplitMessage result, int streamSeqNO) {
        if (this.isExistsTaskMessageQueue(String.valueOf(result.getId()))) {
            this.sendToQueue(result, null, null, false, true);
        } else {
            this.pass(result, streamSeqNO);
        }
    }

    private String getTaskTrustyBufferCacheKey(long taskId, int type) {
        if (type == 1) {
            return String.format("%s-%s", "streamTrustyBuffer", taskId);
        }
        return String.format("%s-%s", "streamTrustyThinkBuffer", taskId);
    }

    private String getToCheckContent(LLMSplitMessage result, TrustLayerData trustLayerData) {
        long taskId = result.getId();
        if (!result.isStream()) {
            return trustLayerData.getContent();
        }
        String sToCheckText = trustLayerData.getContent();
        IAppCache taskCache = EngineCache.getAppCache(String.valueOf(taskId));
        String cacheKey = this.getTaskTrustyBufferCacheKey(taskId, trustLayerData.getType());
        if (sToCheckText == null) {
            taskCache.remove(cacheKey);
        } else {
            String sTrustyCache = (String)taskCache.get(cacheKey, String.class);
            String string = sToCheckText = StringUtils.isEmpty((CharSequence)sTrustyCache) ? sToCheckText : sTrustyCache + sToCheckText;
            if (StringUtils.isNotEmpty((CharSequence)sToCheckText)) {
                taskCache.put(cacheKey, (Object)sToCheckText);
            }
        }
        return sToCheckText;
    }

    private void sendToQueue(LLMSplitMessage result, String msg, String think, boolean isNeedSplitMessage) {
        this.sendToQueue(result, msg, think, isNeedSplitMessage, false);
    }

    private void sendToQueue(LLMSplitMessage result, String msg, String think, boolean isNeedSplitMessage, boolean isOnlyPass) {
        String taskId = String.valueOf(result.getId());
        this.createTaskMessageQueue(taskId);
        IAppCache taskCache = EngineCache.getAppCache(taskId);
        String seqNoStr = (String)taskCache.get("MsgSplit.seqNo/queue/" + taskId, String.class);
        AtomicInteger seqNo = new AtomicInteger(0);
        if (!StringUtils.isEmpty((CharSequence)seqNoStr)) {
            seqNo.set(Integer.parseInt(seqNoStr));
        }
        JSONObject item = new JSONObject();
        item.put("isNeedSplitMessage", (Object)isNeedSplitMessage);
        item.put("isOnlyPass", (Object)isOnlyPass);
        item.put("msg", (Object)msg);
        item.put("think", (Object)think);
        item.put("result", (Object)result);
        taskCache.put(this.getTaskMessageQueueBufferKey(taskId) + "-" + seqNo.getAndIncrement(), (Object)JSON.toJSONString((Object)item), 3600);
        taskCache.put("MsgSplit.seqNo/queue/" + taskId, (Object)String.valueOf(seqNo.get()));
        logger.info("cacheMessage:" + JSON.toJSONString((Object)item));
        logger.info("taskId:" + taskId);
        logger.info("cacheMessage-SEQ_NO:" + seqNo.get());
    }

    private void toTrusty(LLMSplitMessage result, String msg, String think) {
        if (result.getErrCode().equals(Errors.MESSAGE_REPLACE_OK.getCode())) {
            return;
        }
        if (msg == null && think == null) {
            this.sendToQueue(result, null, null, false);
            return;
        }
        long taskId = result.getId();
        String errCode = result.getErrCode();
        String errMsg = result.getErrMsg();
        boolean isNeedToStop = false;
        if (this.isNeedCheck) {
            TrustLayerResult thirdCheckResult;
            TrustLayerData trustLayerData;
            if (think != null) {
                trustLayerData = new TrustLayerData();
                trustLayerData.setContent(think);
                trustLayerData.setType(2);
                String sToCheckThinkText = this.getToCheckContent(result, trustLayerData);
                thirdCheckResult = TrustLayerService.checkOutput(sToCheckThinkText);
                if (thirdCheckResult.getErrorCode() != null) {
                    errCode = Errors.MESSAGE_REPLACE_OK.getCode();
                    errMsg = thirdCheckResult.getErrorMsg();
                    isNeedToStop = true;
                    LlmService.stopGpt(taskId);
                }
            }
            if (msg != null) {
                trustLayerData = new TrustLayerData();
                trustLayerData.setContent(think);
                trustLayerData.setType(1);
                String sToCheckText = this.getToCheckContent(result, trustLayerData);
                thirdCheckResult = TrustLayerService.checkOutput(sToCheckText);
                if (thirdCheckResult.getErrorCode() != null) {
                    errCode = Errors.MESSAGE_REPLACE_OK.getCode();
                    errMsg = thirdCheckResult.getErrorMsg();
                    isNeedToStop = true;
                    LlmService.stopGpt(taskId);
                }
            }
        }
        result.setErrCode(errCode);
        result.setErrMsg(errMsg);
        if (!isNeedToStop && this.isNeedDeMasking) {
            if (msg != null) {
                msg = this.deMasking(msg);
            }
            if (think != null) {
                think = this.deMasking(think);
            }
        }
        if (isNeedToStop || !result.isStream()) {
            this.sendToQueue(result, msg, think, false);
        } else {
            this.sendToQueue(result, msg, think, true);
        }
    }

    private boolean isExistsTaskMessageQueue(String taskId) {
        IAppCache taskCache1 = EngineCache.getAppCache(taskId);
        String threadId = (String)taskCache1.get(String.format("threadId-taskId-%s", taskId), String.class);
        return StringUtils.isNotEmpty((CharSequence)threadId);
    }

    private synchronized void createTaskMessageQueue(String taskId) {
        if (this.isExistsTaskMessageQueue(taskId)) {
            return;
        }
        RequestContext taskContext = RequestContext.get();
        SameTraceRunnable sameTraceRunnable = new SameTraceRunnable(() -> {
            IAppCache taskCache = EngineCache.getAppCache(taskId);
            AtomicInteger queueSeqNo = new AtomicInteger();
            AtomicInteger sendSeqNo = new AtomicInteger();
            LLMSplitMessage result = null;
            try {
                logger.info("TaskMessageQueue-Thread\uff1athreadId=%s,taskid=%s", (Object)Thread.currentThread().getId(), (Object)taskId);
                int checkCount = 0;
                while (checkCount < 300) {
                    String isEnd = (String)taskCache.get("MsgSplit.seqNo/queue_end/" + taskId, String.class);
                    String itemjson = (String)taskCache.get(this.getTaskMessageQueueBufferKey(taskId) + "-" + queueSeqNo.get(), String.class);
                    JSONObject item = JSON.parseObject((String)itemjson);
                    if (item == null) {
                        if (StringUtils.isNotEmpty((CharSequence)isEnd)) break;
                        ++checkCount;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    checkCount = 0;
                    boolean isNeedSplitMessage = item.getBooleanValue("isNeedSplitMessage");
                    boolean isOnlyPass = item.getBooleanValue("isOnlyPass");
                    String msg = item.getString("msg");
                    String think = item.getString("think");
                    result = (LLMSplitMessage)item.getObject("result", LLMSplitMessage.class);
                    if (StopStreamHandler.isTaskStopped(taskId)) {
                        logger.info("messageQueue stop\u3002task : {} is stopped.", (Object)taskId);
                        result.setErrCode(Errors.STOP_STREAM.getCode());
                        result.setErrMsg(Errors.STOP_STREAM.getMessage());
                        this.pass(result, sendSeqNo.getAndIncrement());
                        break;
                    }
                    do {
                        String splitThinkLeft = think;
                        if (StringUtils.isNotEmpty((CharSequence)think)) {
                            String[] splitThinkResult = this.splitMessage(think, isNeedSplitMessage);
                            splitThinkLeft = splitThinkResult[0];
                            think = splitThinkResult[1];
                        }
                        String splitMsgLeft = msg;
                        if (StringUtils.isNotEmpty((CharSequence)msg)) {
                            String[] splitResult = this.splitMessage(msg, isNeedSplitMessage);
                            splitMsgLeft = splitResult[0];
                            msg = splitResult[1];
                        }
                        if (isOnlyPass) {
                            this.pass(result, sendSeqNo.getAndIncrement());
                        } else {
                            this.passAfterTrusty(result, splitMsgLeft, splitThinkLeft, sendSeqNo.getAndIncrement());
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (StringUtils.isNotEmpty((CharSequence)msg) || StringUtils.isNotEmpty((CharSequence)think));
                    queueSeqNo.getAndIncrement();
                }
            }
            catch (Exception ex) {
                try {
                    logger.error("\u6d88\u606f\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)ex);
                    if (result == null) {
                        result = new LLMSplitMessage();
                        result.setId(Long.parseLong(taskId));
                    }
                    ErrorCode errorCode = ex instanceof KDException ? ((KDException)((Object)((Object)ex))).getErrorCode() : Errors.builErrorCode(Errors.TRUSTY_SPLIT_ERROR, ex.getMessage());
                    result.setErrCode(errorCode.getCode());
                    result.setErrMsg(errorCode.getMessage());
                    this.pass(result, sendSeqNo.getAndIncrement());
                }
                catch (Throwable throwable) {
                    taskCache.remove(String.format("threadId-taskId-%s", taskId));
                    int maxSeqNo = -1;
                    String seqNo = (String)taskCache.get("MsgSplit.seqNo/queue/" + taskId, String.class);
                    if (StringUtils.isNotEmpty((CharSequence)seqNo)) {
                        maxSeqNo = Integer.parseInt(seqNo);
                    }
                    for (int i = 0; i < maxSeqNo; ++i) {
                        taskCache.remove(this.getTaskMessageQueueBufferKey(taskId) + "-" + i);
                    }
                    throw throwable;
                }
                taskCache.remove(String.format("threadId-taskId-%s", taskId));
                int maxSeqNo = -1;
                String seqNo = (String)taskCache.get("MsgSplit.seqNo/queue/" + taskId, String.class);
                if (StringUtils.isNotEmpty((CharSequence)seqNo)) {
                    maxSeqNo = Integer.parseInt(seqNo);
                }
                for (int i = 0; i < maxSeqNo; ++i) {
                    taskCache.remove(this.getTaskMessageQueueBufferKey(taskId) + "-" + i);
                }
            }
            taskCache.remove(String.format("threadId-taskId-%s", taskId));
            int maxSeqNo = -1;
            String seqNo = (String)taskCache.get("MsgSplit.seqNo/queue/" + taskId, String.class);
            if (StringUtils.isNotEmpty((CharSequence)seqNo)) {
                maxSeqNo = Integer.parseInt(seqNo);
            }
            for (int i = 0; i < maxSeqNo; ++i) {
                taskCache.remove(this.getTaskMessageQueueBufferKey(taskId) + "-" + i);
            }
        }, taskContext);
        threadPool.execute((Runnable)sameTraceRunnable, taskContext);
        IAppCache taskCache = EngineCache.getAppCache(taskId);
        taskCache.put(String.format("threadId-taskId-%s", taskId), (Object)"true");
    }

    private String[] splitMessage(String msg, boolean isNeedSplitMessage) {
        String[] result = new String[2];
        if (!isNeedSplitMessage) {
            result[0] = msg;
            result[1] = "";
            return result;
        }
        StringBuilder splitMsgLeft = new StringBuilder();
        while (StringUtils.isBlank((CharSequence)splitMsgLeft.toString()) && StringUtils.isNotEmpty((CharSequence)msg)) {
            int code = msg.codePointAt(0);
            String firstCodeString = new String(Character.toChars(code));
            int startIndex = 0;
            int splitMessageLen = firstCodeString.length();
            int iRepoStartIndex = msg.indexOf("########");
            if (iRepoStartIndex == 0) {
                splitMessageLen = "########".length();
            }
            splitMsgLeft.append(msg, startIndex, splitMessageLen);
            msg = msg.substring(startIndex + splitMessageLen);
        }
        if (StringUtils.isBlank((CharSequence)msg)) {
            splitMsgLeft.append(msg);
            msg = "";
        }
        result[0] = splitMsgLeft.toString();
        result[1] = msg;
        return result;
    }

    private void setEnd(String taskId) {
        IAppCache taskCache = EngineCache.getAppCache(taskId);
        taskCache.put("MsgSplit.seqNo/queue_end/" + taskId, (Object)"true");
    }
}

