/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.handler.LLMActionHandler;
import kd.ai.gai.core.engine.message.llmcallback.PromptTestCallbackMessage;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.dataentity.utils.StringUtils;

public class PromptTestHandler
implements IActionCallBack<PromptTestCallbackMessage> {
    @Override
    public void callback(PromptTestCallbackMessage callbackMessage) {
        String chatSessionId = callbackMessage.getChatSessionId();
        Context context = FlowCacheData.getContext(callbackMessage.getChatSessionId());
        String assistantPageId = context.getAssistantPageId();
        String rootPageId = context.getRootPageId();
        String globalSessionId = context.getGlobalSessionId();
        String taskId = callbackMessage.getTaskId();
        String flowId = "0";
        if (!Errors.OK.getCode().equals(callbackMessage.getErrCode())) {
            PushMsgService.pushErrMsg(context, callbackMessage.getErrCode(), callbackMessage.getErrMsg());
            TraceUtil.saveAsyncLLMLog(context, callbackMessage);
            return;
        }
        String llmValue = callbackMessage.getLlmValue();
        String llmThink = callbackMessage.getLlmThink();
        if (callbackMessage.isStream()) {
            if (callbackMessage.isEnd()) {
                if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                    PushMsgService.pushStreamChat(context, taskId, flowId, callbackMessage.getSeqNo(), llmValue, false, callbackMessage.getSearchInfos());
                }
                PushMsgService.pushStreamDown(context, taskId, flowId, callbackMessage.getLlmValue(), "", "0");
                TraceUtil.savePromptTestStreamAsyncLLMLog(context, callbackMessage);
            } else if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                PushMsgService.pushStreamThinkChat(context, taskId, flowId, callbackMessage.getSeqNo(), llmThink, false, callbackMessage.getSearchInfos());
                TraceUtil.savePromptTestStreamAsyncLLMLog(context, callbackMessage);
            } else if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                PushMsgService.pushStreamChat(context, taskId, flowId, callbackMessage.getSeqNo(), llmValue, false, callbackMessage.getSearchInfos());
                TraceUtil.savePromptTestStreamAsyncLLMLog(context, callbackMessage);
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                PushMsgService.pushThinkChat(context, taskId, llmThink, callbackMessage.getSearchInfos());
            }
            if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                PushMsgService.pushChat(context, taskId, llmValue, callbackMessage.getSearchInfos());
            }
            TraceUtil.savePromptTestStreamAsyncLLMLog(context, callbackMessage);
        }
        LLMActionHandler.sendChatBottomMsg(context, "gai_gpt_playground", assistantPageId, rootPageId, globalSessionId, chatSessionId, taskId, callbackMessage.getFlowId() + "", "\u53c2\u8003\u6587\u4ef6", callbackMessage.getCitationInfos());
    }
}

