/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.message.RepoCallbackMessage;
import kd.ai.gai.core.engine.message.RepoMessage;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class RepoHandler
implements IMessageHandler<RepoMessage>,
IActionCallBack<RepoCallbackMessage> {
    private static final Log log = LogFactory.getLog(RepoHandler.class);

    @Override
    public Result process(Context context, RepoMessage message) {
        log.info("RepoHandler process");
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("repoIds", message.getRepoIdList());
        paramsJson.put("input", (Object)message.getQuery());
        paramsJson.put("topK", (Object)message.getTopK());
        paramsJson.put("similarity", (Object)Float.valueOf(message.getSimilarity()));
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRagService", (String)"search", (Object[])new Object[]{paramsJson.toJSONString()});
        log.info("\u77e5\u8bc6\u5e93\u8282\u70b9\u68c0\u7d22,\u8f93\u5165\uff1a{}\uff0c\u8f93\u51fa{}", (Object)paramsJson.toJSONString(), (Object)JSON.toJSONString((Object)resultMap));
        Object o = resultMap.get("data");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("outputList", JSON.toJSONString(o));
        FlowCacheData.setFlowNodeData(context.getChatSessionId(), message.getFlowId(), message.getNodeId(), dataMap);
        return new Result(Errors.OK);
    }

    @Override
    public void callback(RepoCallbackMessage callbackMessage) {
        log.info("RepoHandler callback");
    }
}

