/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunks4LLMItem;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.RepoReplyConfig;
import kd.ai.gai.core.engine.handler.LLMActionHandler;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.RepoReplyCallbackMessage;
import kd.ai.gai.core.engine.message.RepoReplyMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.AiccService;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class RepoReplyHandler
implements IMessageHandler<RepoReplyMessage>,
IActionCallBack<RepoReplyCallbackMessage> {
    private static final Log log = LogFactory.getLog(RepoReplyHandler.class);

    @Override
    public Result process(Context context, RepoReplyMessage message) {
        LLM llm;
        log.info("RepoReplyHandler process");
        RepoReplyConfig repoReplyConfig = message.getRepoReplyConfig();
        String serviceNumber = repoReplyConfig.getLlm();
        RepoReplyCallbackMessage repoReplyCallbackMessage = new RepoReplyCallbackMessage();
        repoReplyCallbackMessage.setParseOutput(false);
        repoReplyCallbackMessage.setFlowId(message.getFlowId());
        repoReplyCallbackMessage.setNodeId(message.getNodeId());
        repoReplyCallbackMessage.setPageId(context.getAssistantPageId());
        repoReplyCallbackMessage.setChatSessionId(context.getChatSessionId());
        repoReplyCallbackMessage.setGlobalSessionId(context.getGlobalSessionId());
        repoReplyCallbackMessage.setShowMessage(repoReplyConfig.isShowMessage());
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(repoReplyCallbackMessage);
        Map<String, String> varMap = repoReplyConfig.getVarMap();
        Prompt prompt = new Prompt();
        prompt.setId(-1L);
        prompt.setServiceNumber(serviceNumber);
        Map<String, Object> service = AiccService.queryLlmAiccService(serviceNumber);
        if (service == null || service.isEmpty()) {
            return new Result(Errors.NO_AICC_SERVICE);
        }
        String llmNumber = (String)service.get("llm");
        if (kd.bos.util.StringUtils.isEmpty((String)llmNumber)) {
            llmNumber = serviceNumber;
        }
        if ((llm = LLM.parse(llmNumber)) == null) {
            return new Result(Errors.NO_LLM_4_AICC_SERVICE(llmNumber));
        }
        prompt.setLlm(llm);
        prompt.setRemembercount(0);
        prompt.setLlmStyle(LlmStyle.PRECISION);
        prompt.setPrompt(repoReplyConfig.getSysPrompt());
        prompt.setReference(repoReplyConfig.isReference());
        prompt.setChunkIdList(this.chunkList2IdList(varMap));
        String userPrompt = repoReplyConfig.getUserPrompt();
        String filledUserPrompt = this.fillVariable(userPrompt, varMap);
        llmMessage.setUserInput(filledUserPrompt);
        llmMessage.setPrompt(prompt);
        llmMessage.setStream(message.isStream());
        llmMessage.setParamMap(this.chunkList2LLMList(varMap));
        Result result = HandlerFactory.runHandler(context, llmMessage);
        result.setCallback(true);
        return result;
    }

    public Map<String, String> chunkList2LLMList(Map<String, String> chunkMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (chunkMap == null || chunkMap.isEmpty()) {
            return resultMap;
        }
        chunkMap.forEach((key, value) -> {
            if (!key.contains("question") && !kd.bos.util.StringUtils.isEmpty((String)value)) {
                try {
                    JSONArray chunkJson = JSON.parseArray((String)value);
                    ArrayList<Chunks4LLMItem> varItem = new ArrayList<Chunks4LLMItem>();
                    if (chunkJson != null && !chunkJson.isEmpty()) {
                        for (int i = 0; i < chunkJson.size(); ++i) {
                            JSONObject item = chunkJson.getJSONObject(i);
                            Chunks4LLMItem chunks4LLMItem = new Chunks4LLMItem(item.getLong("chunkId"), item.getString("chunk"));
                            varItem.add(chunks4LLMItem);
                        }
                    }
                    resultMap.put((String)key, JSON.toJSONString(varItem));
                }
                catch (Exception e) {
                    log.error("\u77e5\u8bc6\u5e93\u53ec\u56de\u5185\u5bb9\u8fdb\u884cjson\u89e3\u6790\u5f02\u5e38\uff0c{}", value);
                    throw new KDBizException(Errors.repoJsonDataError(value), new Object[0]);
                }
            }
        });
        return resultMap;
    }

    public List<Long> chunkList2IdList(Map<String, String> chunkMap) {
        ArrayList<Long> resultArr = new ArrayList<Long>();
        if (chunkMap == null || chunkMap.isEmpty()) {
            return resultArr;
        }
        chunkMap.forEach((key, value) -> {
            if (!key.contains("question") && !kd.bos.util.StringUtils.isEmpty((String)value)) {
                try {
                    JSONArray chunkJson = JSON.parseArray((String)value);
                    if (chunkJson != null && !chunkJson.isEmpty()) {
                        for (int i = 0; i < chunkJson.size(); ++i) {
                            JSONObject item = chunkJson.getJSONObject(i);
                            resultArr.add(item.getLong("chunkId"));
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u77e5\u8bc6\u5e93\u53ec\u56de\u5185\u5bb9\u8fdb\u884cjson\u89e3\u6790\u5f02\u5e38\uff0c{}", value);
                    throw new KDBizException(Errors.repoJsonDataError(value), new Object[0]);
                }
            }
        });
        return resultArr;
    }

    @Override
    public void callback(RepoReplyCallbackMessage callbackMessage) {
        log.info("RepoReplyHandler callback");
        LLMActionHandler.doCallback(callbackMessage);
    }

    public String fillVariable(String template, Map<String, String> variableMap) {
        if (StringUtils.isBlank((CharSequence)template) || variableMap == null || variableMap.isEmpty()) {
            return template;
        }
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            template = StringUtils.replace((String)template, (String)("{{" + key + "}}"), (String)value);
        }
        return template;
    }
}

