/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class StartFlowHandler
implements IMessageHandler<StartFlowMessage> {
    private static final Log log = LogFactory.getLog(StartFlowHandler.class);

    @Override
    public Result process(Context context, StartFlowMessage message) {
        long flowId = 0L;
        if (Context.needCheckLicense(context)) {
            GPTLicenseHelper.checkLic("gai_process", message.getProcessId());
        }
        Flow flow = FlowCacheData.createFlow(message.getChatSessionId(), message.getProcessId());
        Start start = flow.getStart();
        HashMap<String, String> initData = new HashMap<String, String>();
        if (start.getInputVars() != null && !start.getInputVars().isEmpty() && message.getInParams() != null) {
            for (Var var : start.getInputVars()) {
                String val = message.getInParams().get(var.getName());
                if (val == null) continue;
                initData.put(var.getName(), val);
            }
        }
        String plainUserInput = AnnotationService.clearTags(message.getUserInput());
        List<String> fileIdList = AnnotationService.parseCosmicFile(message.getUserInput());
        List<Long> userAttachmentIdList = FileService.queryAttPkIdList(fileIdList);
        String userGaiAttachmentIds = StringUtils.join(fileIdList, (String)",");
        String userAttachmentIds = StringUtils.join(userAttachmentIdList, (String)",");
        initData.put("system.user_attachments", userAttachmentIds);
        initData.put("system.user_gai_attachments_id", userGaiAttachmentIds);
        message.setUserInput(plainUserInput);
        if (message.getUserInput() == null) {
            initData.put("system.user_input", "");
        } else {
            initData.put("system.user_input", message.getUserInput());
        }
        FlowCacheData.setFlowNodeData(context.getChatSessionId(), flow.getId(), start.getId(), initData);
        PushMsgService.pushWaiting(context, flow.getId(), null);
        TraceUtil.startFlow(context, flow, message.getProcessId());
        IAppCache appCache = EngineCache.getAppCache(context.getChatSessionId());
        String traceId = (String)appCache.get(TraceUtil.flowTraceKey(flow.getId()), String.class);
        Result result = FlowNextHandler.next(context, flow.getId(), start.getId());
        result.setTraceId(traceId);
        return result;
    }
}

