/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.message.StopStreamMessage;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.bos.context.RequestContext;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.bos.util.StringUtils;

public class StopStreamHandler
implements IMessageHandler<StopStreamMessage> {
    private static final Log logger = LogFactory.getLog(StopStreamHandler.class);

    @Override
    public Result process(Context context, StopStreamMessage message) {
        FlowCacheData.putCache(context.getChatSessionId(), "flowCancelled", "true");
        this.stopSSEIterator(context.getChatSessionId(), message.getSseRequestTraceId());
        MessageService.updateUserMessage2Cancelled(context.getChatSessionId());
        PushMsgService.pushStopStream(context);
        FlowCacheData.clearCache(context.getChatSessionId(), context.getChatSessionId() + "_ASK_USER");
        if (StringUtils.isNotEmpty((String)message.getTaskId())) {
            StopStreamHandler.stopTask(message.getTaskId());
        }
        IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(context.getSlideenv(), context.getChatTraceId(), context.getTraceId(), UserFeedbackTypeEnum.STOP.getId(), KDDateUtils.now().getTime()));
        if (message.getFlowId() != 0L) {
            IAppCache sessionCache = EngineCache.getAppCache(context.getChatSessionId());
            sessionCache.put(StopStreamHandler.getFlowStopFlagKey(message.getFlowId()), (Object)"TRUE");
            return FlowNextHandler.endFlow(context, message.getFlowId(), false, null);
        }
        return FlowNextHandler.endFlow(context, message.getFlowId(), false, null);
    }

    private void stopSSEIterator(String chatSessionId, String sseRequestTraceId) {
        IAppCache sessionCache = EngineCache.getAppCache(chatSessionId);
        sessionCache.put(StopStreamHandler.getSSEIteratorStopFlagKey(chatSessionId, sseRequestTraceId), (Object)"TRUE");
    }

    private static String getSSEIteratorStopFlagKey(String chatSessionId, String sseRequestTraceId) {
        return String.format(String.format("SSE_STOP_%s_%s", chatSessionId, sseRequestTraceId), new Object[0]);
    }

    private static String getFlowStopFlagKey(long flowId) {
        return "F_STOP_" + flowId;
    }

    public static void stopTask(String taskId) {
        IAppCache taskCache = EngineCache.getAppCache(taskId);
        taskCache.put("stop_stream" + taskId, (Object)"TRUE");
        if (taskId.matches("\\d+")) {
            LlmService.stopGpt(Long.parseLong(taskId));
        }
    }

    public static boolean isTaskStopped(String taskId) {
        IAppCache taskCache = EngineCache.getAppCache(taskId);
        return "TRUE".equals(taskCache.get("stop_stream" + taskId, String.class));
    }

    public static boolean isSSEStopped(String chatSessionId, String sseRequestTraceId) {
        IAppCache sessionCache = EngineCache.getAppCache(chatSessionId);
        return "TRUE".equals(sessionCache.get(StopStreamHandler.getSSEIteratorStopFlagKey(chatSessionId, sseRequestTraceId), String.class));
    }

    public static boolean isStopped(String chatSessionId, long flowId) {
        IAppCache sessionCache = EngineCache.getAppCache(chatSessionId);
        return "TRUE".equals(sessionCache.get(StopStreamHandler.getFlowStopFlagKey(flowId), String.class)) || StopStreamHandler.isSSEStopped(chatSessionId, RequestContext.get().getTraceId());
    }

    public static void removeStopFlag(String chatSessionId, long flowId) {
        IAppCache sessionCache = EngineCache.getAppCache(chatSessionId);
        sessionCache.remove(StopStreamHandler.getFlowStopFlagKey(flowId));
    }
}

