/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.Result4Embedding;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.enuz.EmbeddingModel;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.search.IKnowledgeRepoService;
import kd.ai.gai.core.search.IKnowledgeStatusService;
import kd.ai.gai.core.search.dto.EmbContent;
import kd.ai.gai.core.search.dto.EmbDataCacheDTO;
import kd.ai.gai.core.search.dto.EmbTaskDTO;
import kd.ai.gai.core.search.dto.RepoSchemaDTO;
import kd.ai.gai.core.search.enums.KnoDataStatus;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;
import kd.ai.gai.core.search.helper.StructuredRepoServiceHelper;
import kd.ai.gai.core.search.index.param.vector.VectorData;
import kd.ai.gai.core.search.index.param.vector.VectorDataAddParam;
import kd.ai.gai.core.search.index.schema.VectorCollectionSchema;
import kd.ai.gai.core.search.index.service.VectorService;
import kd.ai.gai.core.search.param.knoData.KnoDataStatusParam;
import kd.ai.gai.core.service.embedding.EmbeddingService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuredEmbeddingHandler {
    private static final Logger log = LoggerFactory.getLogger(StructuredEmbeddingHandler.class);
    private static final Object DATA_LOCK = new Object();
    private static final Object TASK_LOCK = new Object();
    private static final Object REPO_DATA_EMB_LOCK = new Object();
    private static final Object REPO_EMB_LOCK = new Object();
    public static final String DATA_CACHE = "DATA_";
    public static final String TASK_CACHE = "TASK_";
    public static final String REPO_DATA_EMB_CACHE = "REPO_DATA_EMB_";
    public static final String REPO_EMB_CACHE = "REPO_EMB_";

    public static void process(EmbTaskDTO embTaskDTO) {
        LLM llm = embTaskDTO.getLlm();
        EmbeddingModel embeddingModel = EmbeddingModel.parse(llm);
        if (embeddingModel == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u672a\u627e\u5230\u5bf9\u5e94\u7684EmbeddingModel,llm:[{}]", (Object)llm);
            throw new KDBizException("\u672a\u627e\u5230\u5bf9\u5e94\u7684EmbeddingModel");
        }
        int batchSize = embeddingModel.getBatchSize();
        Long repoId = embTaskDTO.getRepoId();
        List<EmbContent> embContentList = embTaskDTO.getContentList();
        int totalContentCount = embContentList.size();
        ArrayList batchEmbContentList = Lists.newArrayListWithExpectedSize((int)batchSize);
        for (int i = 1; i <= totalContentCount; ++i) {
            batchEmbContentList.add(embContentList.get(i - 1));
            if (i % batchSize != 0 && i != totalContentCount) continue;
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f00\u59cb\u63d0\u4ea4Embedding\u5f02\u6b65\u4efb\u52a1,repoId:[{}],\u6279\u6b21\u5904\u7406:[{}/{}],batchSize:[{}]", new Object[]{repoId, i, totalContentCount, batchSize});
            Map<String, Set<String>> dataIdFieldKeySetMap = StructuredEmbeddingHandler.getDataFieldMap(batchEmbContentList);
            List<String> batchContentTextList = batchEmbContentList.stream().map(EmbContent::getContent).collect(Collectors.toList());
            String taskId = null;
            try {
                EmbeddingService embeddingService = EmbeddingServiceFactory.getExecutor(llm, VectorMetricType.COSINE);
                Result2User result2User = embeddingService.embeddingStructuredAsync(llm, batchContentTextList);
                taskId = result2User.getTaskId();
                if (i == totalContentCount) {
                    log.info(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u672b\u6279Embedding\u5f02\u6b65\u4efb\u52a1\u63d0\u4ea4\u5b8c\u6210,repoId:[{}],taskId:[{}]", (Object)repoId, (Object)taskId);
                }
            }
            catch (Exception e) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u63d0\u4ea4Embedding\u5f02\u6b65\u4efb\u52a1\u5f02\u5e38,repoId:[{}],contents:[{}]", new Object[]{repoId, JSON.toJSONString((Object)batchEmbContentList), e});
                Set<String> dataIdSet = dataIdFieldKeySetMap.keySet();
                StructuredEmbeddingHandler.afterSubmitTaskFailed(String.valueOf(repoId), dataIdFieldKeySetMap);
                StructuredEmbeddingHandler.failedDataStatusCallBack(repoId, dataIdSet, "Embedding\u5f02\u6b65\u8c03\u7528\u5f02\u5e38", e.getMessage());
            }
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                EmbTaskDTO batchEmbTaskDTO = new EmbTaskDTO.EmbTaskDTOBuilder().taskId(taskId).repoId(repoId).repoName(embTaskDTO.getRepoName()).llm(llm).contentList(batchEmbContentList).build();
                StructuredEmbeddingHandler.afterSubmitTaskSuccess(batchEmbTaskDTO, dataIdFieldKeySetMap);
            }
            batchEmbContentList.clear();
        }
    }

    private static Map<String, Set<String>> getDataFieldMap(List<EmbContent> contentList) {
        HashMap dataIdFieldKeySetMap = Maps.newHashMapWithExpectedSize((int)contentList.size());
        for (EmbContent content : contentList) {
            String dataId = content.getDataId();
            String fieldKey = content.getFieldKey();
            Set fieldKeyList = dataIdFieldKeySetMap.getOrDefault(dataId, Sets.newHashSetWithExpectedSize((int)20));
            fieldKeyList.add(fieldKey);
            dataIdFieldKeySetMap.put(dataId, fieldKeyList);
        }
        return dataIdFieldKeySetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void afterSubmitTaskSuccess(EmbTaskDTO embTaskDTO, Map<String, Set<String>> dataIdFieldKeySetMap) {
        StructuredEmbeddingHandler.writeTaskCache(embTaskDTO);
        Long repoId = embTaskDTO.getRepoId();
        String repoIdStr = String.valueOf(repoId);
        String taskId = embTaskDTO.getTaskId();
        Object object = DATA_LOCK;
        synchronized (object) {
            EmbDataCacheDTO dataCacheDTO = StructuredEmbeddingHandler.readRepoDataCache(repoIdStr, true);
            Set<String> dataIdSet = dataIdFieldKeySetMap.keySet();
            if (dataCacheDTO == null) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u9996\u6279Embedding\u5f02\u6b65\u4efb\u52a1\u63d0\u4ea4\u5b8c\u6210,repoId:[{}],taskId:[{}]", (Object)repoIdStr, (Object)taskId);
                dataCacheDTO = EmbDataCacheDTO.buildByRepoIdWithDataIdSet(repoIdStr, dataIdSet);
            } else {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93Embedding\u5f02\u6b65\u4efb\u52a1\u63d0\u4ea4\u5b8c\u6210,repoId:[{}],taskId:[{}]", (Object)repoIdStr, (Object)taskId);
            }
            Map<String, Set<String>> embeddingDataFieldMap = dataCacheDTO.getEmbeddingDataFieldMap();
            dataIdFieldKeySetMap.forEach((dataId, fieldKeySet) -> {
                Set embeddingFieldKeySet = embeddingDataFieldMap.computeIfAbsent((String)dataId, k -> Sets.newHashSetWithExpectedSize((int)20));
                embeddingFieldKeySet.addAll(fieldKeySet);
            });
            Map<String, Set<String>> embeddingTaskDataMap = dataCacheDTO.getEmbeddingTaskDataMap();
            embeddingTaskDataMap.put(taskId, dataIdSet);
            StructuredEmbeddingHandler.writeRepoDataCache(repoIdStr, dataCacheDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void afterSubmitTaskFailed(String repoIdStr, Map<String, Set<String>> dataIdFieldKeySetMap) {
        Object object = DATA_LOCK;
        synchronized (object) {
            EmbDataCacheDTO dataCacheDTO = StructuredEmbeddingHandler.readRepoDataCache(repoIdStr, true);
            if (dataCacheDTO == null) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u9996\u6279\u5f02\u6b65\u8c03\u7528\u5931\u8d25,repoId:[{}]", (Object)repoIdStr);
                dataCacheDTO = EmbDataCacheDTO.buildByRepoIdWithDataIdSet(repoIdStr, dataIdFieldKeySetMap.keySet());
            }
            Map<String, Set<String>> failedDataFieldMap = dataCacheDTO.getFailedDataFieldMap();
            failedDataFieldMap.putAll(dataIdFieldKeySetMap);
            StructuredEmbeddingHandler.writeRepoDataCache(repoIdStr, dataCacheDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callback(Result2User result) {
        String taskId = result.getTaskId();
        log.info(Constant.RepoSchema.LOG_PREFIX + "Embedding\u56de\u8c03\u5f00\u59cb,taskId:[{}]", (Object)taskId);
        EmbTaskDTO cachedTaskInfo = StructuredEmbeddingHandler.readTaskCache(taskId);
        if (cachedTaskInfo == null) {
            return;
        }
        Long repoId = cachedTaskInfo.getRepoId();
        String repoIdStr = String.valueOf(repoId);
        EmbDataCacheDTO cachedDataInfo = StructuredEmbeddingHandler.readRepoDataCache(repoIdStr);
        Map<String, Set<String>> dataIdFieldKeySetMap = StructuredEmbeddingHandler.getDataFieldMap(cachedTaskInfo.getContentList());
        try {
            JSONObject resContentJsonObj;
            String errorCode;
            String resContent = result.getContent();
            if (StringUtils.isNotBlank((CharSequence)resContent) && StringUtils.isNotBlank((CharSequence)(errorCode = (resContentJsonObj = JSON.parseObject((String)resContent)).getString("error_code")))) {
                String errorMsg = resContentJsonObj.getString("error_msg");
                result.setCode(errorCode);
                result.setErrMsg(errorMsg);
            }
            if (Errors.OK.getCode().equals(result.getCode())) {
                StructuredEmbeddingHandler.handleOkResult(result, cachedTaskInfo, cachedDataInfo, dataIdFieldKeySetMap);
            } else {
                StructuredEmbeddingHandler.handleNotOkResult(result, cachedTaskInfo, dataIdFieldKeySetMap);
            }
        }
        catch (Exception e) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "Embedding\u56de\u8c03\u5904\u7406\u5f02\u5e38,repoId:[{}],taskId[{}],result:[{}],taskInfo:[{}],dataInfo:[{}]", new Object[]{repoIdStr, taskId, JSON.toJSONString((Object)result), JSON.toJSONString((Object)cachedTaskInfo), JSON.toJSONString((Object)cachedDataInfo), e});
            String briefForFailure = "Embedding\u56de\u8c03\u5904\u7406\u5f02\u5e38";
            String detailedForFailure = e.getMessage();
            StructuredEmbeddingHandler.failedDataStatusCallBack(repoId, dataIdFieldKeySetMap.keySet(), briefForFailure, detailedForFailure);
        }
        finally {
            StructuredEmbeddingHandler.removeTaskAndDataCache(repoIdStr, taskId);
        }
    }

    public static void handleOkResult(Result2User result, EmbTaskDTO embTaskDTO, EmbDataCacheDTO embDataCacheDTO, Map<String, Set<String>> dataIdFieldKeySetMap) {
        Long repoId = embTaskDTO.getRepoId();
        String repoIdStr = String.valueOf(repoId);
        String taskId = result.getTaskId();
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u56de\u8c03\u7ed3\u679c\u6210\u529f\u7684\u6570\u636e\u5f00\u59cb\u5904\u7406,repoId:[{}],taskId:[{}]", (Object)repoIdStr, (Object)taskId);
        EmbeddingService embeddingService = EmbeddingServiceFactory.getExecutor(embTaskDTO.getLlm(), VectorMetricType.COSINE);
        Result4Embedding result4Embedding = embeddingService.resultParse(result);
        Map<String, Set<String>> failedDataFieldMap = embDataCacheDTO.getFailedDataFieldMap();
        List<List<Float>> vectorList = result4Embedding.getVectorList();
        List<EmbContent> contentList = embTaskDTO.getContentList();
        Map<String, List<EmbContent>> dataIdContentListMap = StructuredEmbeddingHandler.getDataIdContentListMapExcludeFailed(repoIdStr, taskId, failedDataFieldMap, contentList, vectorList);
        dataIdContentListMap.forEach((dataId, dataContentList) -> {
            block12: {
                Set fieldKeySet = (Set)dataIdFieldKeySetMap.get(dataId);
                try {
                    EmbDataCacheDTO afterUpdateDataCacheDTO = StructuredEmbeddingHandler.updateCachedFieldKeys(repoIdStr, dataId, fieldKeySet, 1);
                    Map<String, Set<String>> embeddingDataFieldMap = afterUpdateDataCacheDTO.getEmbeddingDataFieldMap();
                    Set<String> embeddingFieldKeySet = embeddingDataFieldMap.get(dataId);
                    if (CollectionUtils.isEmpty(embeddingFieldKeySet)) {
                        Set<String> vectorFieldKeys = afterUpdateDataCacheDTO.getVectorFieldKeys();
                        Map<String, Set<String>> toVectorDataFieldMap = afterUpdateDataCacheDTO.getToVectorDataFieldMap();
                        Set<String> toVectorFieldKeySet = toVectorDataFieldMap.get(dataId);
                        if (!CollectionUtils.containsAll(toVectorFieldKeySet, vectorFieldKeys)) {
                            log.warn(Constant.RepoSchema.LOG_PREFIX + "dataId\u5bf9\u5e94\u7684\u5b57\u6bb5\u5168\u90e8embedding\u5b8c\u4e86,\u4f46\u6570\u636e\u4e0d\u5168,\u53ef\u80fd\u6709\u7a7a\u5b57\u6bb5,repoId:[{}],dataId:[{}],toVector:[{}],vector:[{}]", new Object[]{repoIdStr, dataId, toVectorFieldKeySet, vectorFieldKeys});
                        }
                        Object object = REPO_DATA_EMB_LOCK;
                        synchronized (object) {
                            List<EmbContent> cachedSuccessContents = StructuredEmbeddingHandler.readEmbDataCache(repoIdStr, dataId);
                            if (CollectionUtils.isNotEmpty(cachedSuccessContents)) {
                                for (EmbContent contentObj : cachedSuccessContents) {
                                    EmbContent content = (EmbContent)JSON.parseObject((String)JSON.toJSONString((Object)contentObj), EmbContent.class);
                                    dataContentList.add(content);
                                    fieldKeySet.add(content.getFieldKey());
                                }
                            }
                            StructuredEmbeddingHandler.batchVector(repoId, dataContentList);
                            StructuredEmbeddingHandler.removeEmbDataCache(repoIdStr, dataId);
                            break block12;
                        }
                    }
                    Object object = REPO_DATA_EMB_LOCK;
                    synchronized (object) {
                        ArrayList cachedSuccessContents = StructuredEmbeddingHandler.readEmbDataCache(repoIdStr, dataId);
                        cachedSuccessContents = cachedSuccessContents == null ? Lists.newArrayListWithExpectedSize((int)fieldKeySet.size()) : cachedSuccessContents;
                        log.info(Constant.RepoSchema.LOG_PREFIX + "\u6dfb\u52a0\u7f13\u5b58,dataId\u5bf9\u5e94\u7684\u5b57\u6bb5\u8fd8\u6ca1\u6709\u5168\u90e8\u5904\u7406\u5b8c,repoId:[{}],taskId:[{}],dataId:[{}],dataContents:[{}],cachedSuccessContents:[{}]", new Object[]{repoIdStr, taskId, dataId, dataContentList, cachedSuccessContents});
                        cachedSuccessContents.addAll(dataContentList);
                        StructuredEmbeddingHandler.writeEmbDataCache(repoIdStr, dataId, cachedSuccessContents);
                    }
                }
                catch (Exception e) {
                    String briefForFailure = "Embedding\u6210\u529f\u7684\u6570\u636e\u5904\u7406\u5f02\u5e38";
                    String detailedForFailure = e.getMessage();
                    log.error(Constant.RepoSchema.LOG_PREFIX + "Embedding\u6210\u529f\u7684\u6570\u636e\u5904\u7406\u5f02\u5e38,taskId:[{}],dataId:[{}]", new Object[]{taskId, dataId, e});
                    StructuredEmbeddingHandler.updateCachedFieldKeys(repoIdStr, dataId, fieldKeySet, -1);
                    StructuredEmbeddingHandler.failedDataStatusCallBack(repoId, Sets.newHashSet((Object[])new String[]{dataId}), briefForFailure, detailedForFailure);
                }
            }
        });
    }

    private static Map<String, List<EmbContent>> getDataIdContentListMapExcludeFailed(String repoIdStr, String taskId, Map<String, Set<String>> failedDataFieldMap, List<EmbContent> contentList, List<List<Float>> vectorList) {
        int contentSize = contentList.size();
        HashMap dataContentMap = Maps.newHashMapWithExpectedSize((int)contentSize);
        for (int i = 0; i < contentSize; ++i) {
            EmbContent content = contentList.get(i);
            String dataId = content.getDataId();
            Set<String> failedFieldKeySet = failedDataFieldMap.get(dataId);
            if (CollectionUtils.isNotEmpty(failedFieldKeySet)) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "dataId\u6709\u5904\u7406\u5931\u8d25\u7684\u5b57\u6bb5,repoId:[{}],taskId:[{}],dataId:[{}],failed:[{}]", new Object[]{repoIdStr, taskId, dataId, failedFieldKeySet});
                continue;
            }
            content.setVectors(vectorList.get(i));
            List dataContentList = dataContentMap.getOrDefault(dataId, new ArrayList());
            dataContentList.add(content);
            dataContentMap.put(dataId, dataContentList);
        }
        return dataContentMap;
    }

    public static void handleNotOkResult(Result2User result, EmbTaskDTO embTaskDTO, Map<String, Set<String>> dataIdFieldKeySetMap) {
        Long repoId = embTaskDTO.getRepoId();
        String repoIdStr = String.valueOf(repoId);
        String taskId = embTaskDTO.getTaskId();
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u56de\u8c03\u7ed3\u679c\u5931\u8d25\u7684\u6570\u636e\u5f00\u59cb\u5904\u7406,repoId:[{}],taskId:[{}]", (Object)repoIdStr, (Object)taskId);
        String briefForFailure = "Embedding\u56de\u8c03\u7ed3\u679c:" + result.getCode();
        String detailedForFailure = result.getErrMsg();
        dataIdFieldKeySetMap.forEach((dataId, fieldKeySet) -> StructuredEmbeddingHandler.updateCachedFieldKeys(repoIdStr, dataId, fieldKeySet, -1));
        StructuredEmbeddingHandler.failedDataStatusCallBack(repoId, dataIdFieldKeySetMap.keySet(), briefForFailure, detailedForFailure);
    }

    private static void failedDataStatusCallBack(Long repoId, Set<String> dataIdSet, String briefForFailure, String detailedForFailure) {
        KnoDataStatusParam dataStatusParam = new KnoDataStatusParam.KnoDataStatusParamBuilder().repoId(repoId).repoNumber(StructuredEmbeddingHandler.getRepoNumberByRepoId(repoId)).knoDataIds(Lists.newArrayList(dataIdSet)).status(KnoDataStatus.FAILED.getValue()).briefForFailure(briefForFailure).detailedForFailure(detailedForFailure).build();
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u6570\u636e\u72b6\u6001\u56de\u8c03,\u5931\u8d25\u56de\u8c03 repoId:[{}],dataIdSize:[{}],param:[{}]", new Object[]{repoId, dataIdSet.size(), JSON.toJSONString((Object)dataStatusParam)});
        IKnowledgeStatusService statusService = KnowledgeRepoServiceHelper.getStatusService();
        statusService.dataStatusCallBack(dataStatusParam);
    }

    private static void successDataStatusCallBack(Long repoId, Set<Long> dataIdSet) {
        KnoDataStatusParam dataStatusParam = new KnoDataStatusParam.KnoDataStatusParamBuilder().repoId(repoId).repoNumber(StructuredEmbeddingHandler.getRepoNumberByRepoId(repoId)).knoDataIds(Lists.newArrayList(dataIdSet)).status(KnoDataStatus.SUCCESS.getValue()).build();
        log.info(Constant.RepoSchema.LOG_PREFIX + "\u6570\u636e\u72b6\u6001\u56de\u8c03,\u6210\u529f\u56de\u8c03 repoId:[{}],dataIdSize:[{}],param:[{}]", new Object[]{repoId, dataIdSet.size(), JSON.toJSONString((Object)dataStatusParam)});
        IKnowledgeStatusService statusService = KnowledgeRepoServiceHelper.getStatusService();
        statusService.dataStatusCallBack(dataStatusParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchVector(Long repoId, List<EmbContent> embContentList) {
        String repoIdStr = String.valueOf(repoId);
        int newDataSize = embContentList.size();
        Object object = REPO_EMB_LOCK;
        synchronized (object) {
            EmbDataCacheDTO embDataCacheDTO = StructuredEmbeddingHandler.readRepoDataCache(String.valueOf(repoId));
            long repoEmbeddingCount = StructuredEmbeddingHandler.getRepoEmbeddingCount(embDataCacheDTO);
            ArrayList cachedRepoEmbContentList = StructuredEmbeddingHandler.readRepoEmbContentCache(repoIdStr);
            cachedRepoEmbContentList = cachedRepoEmbContentList == null ? Lists.newArrayListWithExpectedSize((int)220) : cachedRepoEmbContentList;
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u6dfb\u52a0\u7f13\u5b58,\u51c6\u5907\u6279\u91cf\u5b58\u5165\u5411\u91cf\u5e93\u7684\u6570\u636e,repoId:[{}],repoEmbeddingCount:[{}],cachedRepoEmbContentListSize:[{}],newDataSize:[{}]", new Object[]{repoId, repoEmbeddingCount, cachedRepoEmbContentList.size(), newDataSize});
            cachedRepoEmbContentList.addAll(embContentList);
            StructuredEmbeddingHandler.writeRepoEmbContentCache(repoIdStr, cachedRepoEmbContentList);
            if (cachedRepoEmbContentList.size() >= 200 || repoEmbeddingCount == 0L) {
                StructuredEmbeddingHandler.removeRepoEmbContentCache(repoIdStr);
                List<VectorData> vectorDataList = StructuredEmbeddingHandler.convertToVectorData(cachedRepoEmbContentList);
                VectorDataAddParam vectorDataAddParam = VectorDataAddParam.newBuilder().withCollectonName(new VectorCollectionSchema(repoId)).withVectorDataList(vectorDataList).build();
                VectorService vectorService = StructuredRepoServiceHelper.getVectorService();
                Set<Long> dataIdSet = vectorDataList.stream().map(VectorData::getDataId).collect(Collectors.toSet());
                boolean addSuccess = false;
                String briefForFailure = "\u5199\u5165\u5411\u91cf\u5e93\u5f02\u5e38";
                String detailedForFailure = "\u5199\u5165\u5411\u91cf\u5e93\u5f02\u5e38";
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                try {
                    log.info(Constant.RepoSchema.LOG_PREFIX + "\u5f00\u59cb\u5c06\u6570\u636e\u6279\u91cf\u5b58\u5165\u5411\u91cf\u5e93,repoId:[{}],dataIdSize:[{}],dataSize:[{}]", new Object[]{repoId, dataIdSet.size(), cachedRepoEmbContentList.size()});
                    addSuccess = vectorService.batchAddData(vectorDataAddParam);
                }
                catch (Exception e) {
                    stopWatch.stop();
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u5c06\u6570\u636e\u6279\u91cf\u5b58\u5165\u5411\u91cf\u5e93\u5f02\u5e38,\u8017\u65f6:[{}ms],repoId:[{}],dataIdSize:[{}],dataSize:[{}],param:[{}]", new Object[]{stopWatch.getTime(), repoId, dataIdSet.size(), cachedRepoEmbContentList.size(), JSON.toJSONString((Object)vectorDataAddParam), e});
                    detailedForFailure = e.getMessage();
                }
                stopWatch.stop();
                HashMap dataIdFieldKeySetMap = Maps.newHashMapWithExpectedSize((int)newDataSize);
                for (EmbContent embContent : cachedRepoEmbContentList) {
                    String dataId2 = embContent.getDataId();
                    String fieldKey = embContent.getFieldKey();
                    Set fieldKeySet2 = dataIdFieldKeySetMap.getOrDefault(dataId2, Sets.newHashSetWithExpectedSize((int)20));
                    fieldKeySet2.add(fieldKey);
                    dataIdFieldKeySetMap.put(dataId2, fieldKeySet2);
                }
                if (addSuccess) {
                    dataIdFieldKeySetMap.forEach((dataId, fieldKeySet) -> StructuredEmbeddingHandler.updateCachedFieldKeys(repoIdStr, dataId, fieldKeySet, 0));
                    log.info(Constant.RepoSchema.LOG_PREFIX + "\u5c06\u6570\u636e\u6279\u91cf\u5b58\u5165\u5411\u91cf\u5e93\u5b8c\u6210,\u8017\u65f6:[{}ms],repoId:[{}],dataIdSize:[{}],dataSize:[{}],", new Object[]{stopWatch.getTime(), repoId, dataIdSet.size(), cachedRepoEmbContentList.size()});
                    StructuredEmbeddingHandler.successDataStatusCallBack(repoId, dataIdSet);
                } else {
                    dataIdFieldKeySetMap.forEach((dataId, fieldKeySet) -> StructuredEmbeddingHandler.updateCachedFieldKeys(repoIdStr, dataId, fieldKeySet, -1));
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u5c06\u6570\u636e\u6279\u91cf\u5b58\u5165\u5411\u91cf\u5e93\u5931\u8d25,\u8017\u65f6:[{}ms],repoId:[{}],dataIdSize:[{}],dataSize:[{}],param:[{}]", new Object[]{stopWatch.getTime(), repoId, dataIdSet.size(), cachedRepoEmbContentList.size(), JSON.toJSONString((Object)vectorDataAddParam)});
                    Set<String> fieldKeySet3 = cachedRepoEmbContentList.stream().map(EmbContent::getFieldKey).collect(Collectors.toSet());
                    StructuredEmbeddingHandler.failedDataStatusCallBack(repoId, fieldKeySet3, briefForFailure, detailedForFailure);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmbDataCacheDTO updateCachedFieldKeys(String repoIdStr, String dataId, Set<String> finishedFieldKeySet, int updateType) {
        Object object = DATA_LOCK;
        synchronized (object) {
            String updateTag;
            EmbDataCacheDTO cachedDataInfo = StructuredEmbeddingHandler.readRepoDataCache(repoIdStr);
            Set<String> successDataIdSet = cachedDataInfo.getSuccessDataIdSet();
            Map<String, Set<String>> embeddingDataFieldMap = cachedDataInfo.getEmbeddingDataFieldMap();
            Map<String, Set<String>> toVectorDataFieldMap = cachedDataInfo.getToVectorDataFieldMap();
            Map<String, Set<String>> failedDataFieldMap = cachedDataInfo.getFailedDataFieldMap();
            Set embeddingFieldKeySet = embeddingDataFieldMap.computeIfAbsent(dataId, k -> Sets.newHashSetWithExpectedSize((int)16));
            Set toVectorFieldKeySet = toVectorDataFieldMap.computeIfAbsent(dataId, k -> Sets.newHashSetWithExpectedSize((int)16));
            Set failedFieldKeySet = failedDataFieldMap.computeIfAbsent(dataId, k -> Sets.newHashSetWithExpectedSize((int)16));
            Set toRemoveFieldKeySet = Sets.newHashSet();
            Set<String> toAddFieldKeySet = Sets.newHashSet();
            switch (updateType) {
                case -1: {
                    updateTag = "\u5904\u7406\u5931\u8d25";
                    toAddFieldKeySet = failedFieldKeySet;
                    embeddingDataFieldMap.remove(dataId);
                    toVectorDataFieldMap.remove(dataId);
                    break;
                }
                case 0: {
                    updateTag = "\u5904\u7406\u6210\u529f";
                    toRemoveFieldKeySet = toVectorFieldKeySet;
                    break;
                }
                case 1: {
                    updateTag = "Embedding\u5b8c\u6210,\u7b49\u5f85\u5b58\u5165\u5411\u91cf\u5e93";
                    toRemoveFieldKeySet = embeddingFieldKeySet;
                    toAddFieldKeySet = toVectorFieldKeySet;
                    break;
                }
                default: {
                    log.error(Constant.RepoSchema.LOG_PREFIX + "\u7c7b\u578b\u9519\u8bef,updateType:[{}],repoId:[{}],dataId:[{}],finished:[{}]", new Object[]{updateType, repoIdStr, dataId, finishedFieldKeySet});
                    throw new RuntimeException();
                }
            }
            log.info(Constant.RepoSchema.LOG_PREFIX + updateTag + ",\u66f4\u65b0\u524d\u7f13\u5b58\u4e2d\u7684FieldKeys,repoId:[{}],dataId:[{}],finished:[{}],embedding:[{}],toVector:[{}],successDataId:[{}],failed:[{}]", new Object[]{repoIdStr, dataId, finishedFieldKeySet, embeddingFieldKeySet, toVectorFieldKeySet, successDataIdSet, failedFieldKeySet});
            if (updateType >= 0) {
                if (CollectionUtils.isEmpty((Collection)toRemoveFieldKeySet) || !CollectionUtils.containsAll((Collection)toRemoveFieldKeySet, finishedFieldKeySet)) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + updateTag + ",toRemove\u4e0d\u5168\u5305\u542bfinished,repoId:[{}],dataId:[{}],toRemove:[{}],finished:[{}]", new Object[]{repoIdStr, dataId, toRemoveFieldKeySet, finishedFieldKeySet});
                }
                toRemoveFieldKeySet.removeAll(finishedFieldKeySet);
                if (CollectionUtils.isEmpty(toRemoveFieldKeySet)) {
                    log.info(Constant.RepoSchema.LOG_PREFIX + updateTag + ",\u4e00\u884c\u6570\u636e\u5df2\u5168\u90e8\u5b8c\u6210,repoId:[{}],dataId:[{}]", (Object)repoIdStr, (Object)dataId);
                }
            }
            if (updateType == 0) {
                successDataIdSet.add(dataId);
                embeddingDataFieldMap.remove(dataId);
                toVectorDataFieldMap.remove(dataId);
                failedDataFieldMap.remove(dataId);
            } else {
                if (CollectionUtils.containsAny((Collection)toAddFieldKeySet, finishedFieldKeySet)) {
                    log.error(Constant.RepoSchema.LOG_PREFIX + updateTag + ",toAdd\u5df2\u5305\u542bfinished,repoId:[{}],dataId:[{}],toAdd:[{}],finished:[{}]", new Object[]{repoIdStr, dataId, toAddFieldKeySet, finishedFieldKeySet});
                }
                toAddFieldKeySet.addAll(finishedFieldKeySet);
            }
            StructuredEmbeddingHandler.writeRepoDataCache(repoIdStr, cachedDataInfo);
            return cachedDataInfo;
        }
    }

    public static long getRepoEmbeddingCount(EmbDataCacheDTO dataCacheDTO) {
        AtomicLong processingCount = new AtomicLong(0L);
        Map<String, Set<String>> embeddingDataFieldMap = dataCacheDTO.getEmbeddingDataFieldMap();
        embeddingDataFieldMap.forEach((dataId, fieldSet) -> processingCount.set(processingCount.get() + (long)fieldSet.size()));
        return processingCount.get();
    }

    private static String getRepoNumberByRepoId(Long repoId) {
        IKnowledgeRepoService repoService = KnowledgeRepoServiceHelper.getRepoService();
        RepoSchemaDTO schema = repoService.getSchemaByRepoId(repoId);
        return schema.getRepoNumber();
    }

    public static List<VectorData> convertToVectorData(List<EmbContent> embContentList) {
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)embContentList.size());
        for (EmbContent content : embContentList) {
            VectorData vectorData = new VectorData(Long.valueOf(content.getDataId()), content.getFieldKey(), content.getFieldName(), content.getVectors());
            dataList.add(vectorData);
        }
        return dataList;
    }

    public static EmbTaskDTO readTaskCache(String taskId) {
        EmbTaskDTO cachedTaskInfo = StructuredEmbeddingHandler.readCache(taskId, TASK_CACHE + taskId, EmbTaskDTO.class);
        if (cachedTaskInfo == null) {
            log.error(Constant.RepoSchema.LOG_PREFIX + "\u8bfb\u7f13\u5b58,\u672a\u8bfb\u53d6\u5230\u4efb\u52a1\u4fe1\u606f,taskId:[{}]", (Object)taskId);
        } else {
            log.debug(Constant.RepoSchema.LOG_PREFIX + "\u8bfb\u7f13\u5b58,\u8bfb\u53d6\u5230\u4efb\u52a1\u4fe1\u606f,taskId:[{}],taskInfo:[{}]", (Object)taskId, (Object)cachedTaskInfo);
        }
        return cachedTaskInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTaskCache(EmbTaskDTO embTaskDTO) {
        Object object = TASK_LOCK;
        synchronized (object) {
            String taskId = embTaskDTO.getTaskId();
            for (EmbContent content : embTaskDTO.getContentList()) {
                content.setContent(null);
            }
            StructuredEmbeddingHandler.writeCache(taskId, TASK_CACHE + taskId, (Object)embTaskDTO);
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5199\u7f13\u5b58,\u4efb\u52a1\u4fe1\u606f,repoId:[{}],taskInfo:[{}]", (Object)embTaskDTO.getRepoId(), (Object)embTaskDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTaskAndDataCache(String repoIdStr, String taskId) {
        Object object = DATA_LOCK;
        synchronized (object) {
            EmbDataCacheDTO dataCacheDTO = StructuredEmbeddingHandler.readRepoDataCache(repoIdStr);
            Map<String, Set<String>> embeddingTaskDataMap = dataCacheDTO.getEmbeddingTaskDataMap();
            embeddingTaskDataMap.remove(taskId);
            if (embeddingTaskDataMap.isEmpty()) {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93Embedding\u5f02\u6b65\u4efb\u52a1\u5168\u90e8\u5904\u7406\u5b8c\u6210,repoId:[{}]", (Object)repoIdStr);
                Map<String, Set<String>> embeddingDataFieldMap = dataCacheDTO.getEmbeddingDataFieldMap();
                Map<String, Set<String>> toVectorDataFieldMap = dataCacheDTO.getToVectorDataFieldMap();
                Set<String> allDataIdSet = dataCacheDTO.getAllDataIdSet();
                Set<String> successDataIdSet = dataCacheDTO.getSuccessDataIdSet();
                Map<String, Set<String>> failedDataFieldMap = dataCacheDTO.getFailedDataFieldMap();
                if (embeddingDataFieldMap.isEmpty() && toVectorDataFieldMap.isEmpty()) {
                    log.info(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u6ca1\u6709\u8fd8\u672a\u5904\u7406\u5b8c\u6210\u7684\u6570\u636e,repoId:[{}],allDataSize:[{}],successDataSize:[{}],failedSize:[{}]", new Object[]{repoIdStr, allDataIdSet.size(), successDataIdSet.size(), failedDataFieldMap.size()});
                    StructuredEmbeddingHandler.removeRepoDataCache(repoIdStr);
                } else {
                    log.warn(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93\u8fd8\u6709\u672a\u5904\u7406\u5b8c\u6210\u7684\u6570\u636e,repoId:[{}],embeddingDataFieldMap:[{}],toVectorDataFieldMap:[{}],allDataSize:[{}],successDataSize:[{}],failedSize:[{}]", new Object[]{repoIdStr, embeddingDataFieldMap, toVectorDataFieldMap, allDataIdSet.size(), successDataIdSet.size(), failedDataFieldMap.size()});
                    StructuredEmbeddingHandler.writeRepoDataCache(repoIdStr, dataCacheDTO);
                }
            } else {
                log.info(Constant.RepoSchema.LOG_PREFIX + "\u77e5\u8bc6\u5e93Embedding\u5f02\u6b65\u4efb\u52a1\u8fd8\u672a\u5168\u90e8\u5904\u7406\u5b8c\u6210,repoId:[{}],embeddingTask:[{}]", (Object)repoIdStr, embeddingTaskDataMap);
                StructuredEmbeddingHandler.writeRepoDataCache(repoIdStr, dataCacheDTO);
            }
        }
        StructuredEmbeddingHandler.removeTaskCache(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTaskCache(String taskId) {
        Object object = TASK_LOCK;
        synchronized (object) {
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u7f13\u5b58,\u4efb\u52a1\u4fe1\u606f,taskId:[{}]", (Object)taskId);
            StructuredEmbeddingHandler.removeCache(taskId, TASK_CACHE + taskId);
        }
    }

    public static EmbDataCacheDTO readRepoDataCache(String repoIdStr) {
        return StructuredEmbeddingHandler.readRepoDataCache(repoIdStr, false);
    }

    public static EmbDataCacheDTO readRepoDataCache(String repoIdStr, boolean maybeFirst) {
        EmbDataCacheDTO dataCacheDTO = StructuredEmbeddingHandler.readCache(repoIdStr, DATA_CACHE + repoIdStr, EmbDataCacheDTO.class);
        if (dataCacheDTO == null) {
            if (!maybeFirst) {
                log.error(Constant.RepoSchema.LOG_PREFIX + "\u8bfb\u7f13\u5b58,\u672a\u8bfb\u53d6\u5230\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684\u6570\u636e,repoId:[{}]", (Object)repoIdStr);
                throw new KDBizException("\u7f13\u5b58\u4e2d\u672a\u8bfb\u53d6\u5230\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684\u6570\u636e");
            }
        } else {
            log.debug(Constant.RepoSchema.LOG_PREFIX + "\u8bfb\u7f13\u5b58,\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684\u6570\u636e,repoId:[{}],dataInfo:[{}]", (Object)repoIdStr, (Object)dataCacheDTO);
        }
        return dataCacheDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRepoDataCache(String repoIdStr, EmbDataCacheDTO dataCacheDTO) {
        Object object = DATA_LOCK;
        synchronized (object) {
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5199\u7f13\u5b58,\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684\u6570\u636e,repoId:[{}],dataInfo:[{}]", (Object)repoIdStr, (Object)dataCacheDTO);
            StructuredEmbeddingHandler.writeCache(repoIdStr, DATA_CACHE + repoIdStr, (Object)dataCacheDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRepoDataCache(String repoIdStr) {
        Object object = DATA_LOCK;
        synchronized (object) {
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u7f13\u5b58,\u77e5\u8bc6\u5e93\u5bf9\u5e94\u7684\u6570\u636e,repoId:[{}]", (Object)repoIdStr);
            StructuredEmbeddingHandler.removeCache(repoIdStr, DATA_CACHE + repoIdStr);
        }
    }

    public static List<EmbContent> readRepoEmbContentCache(String repoIdStr) {
        JSONArray cachedJsonArr = StructuredEmbeddingHandler.readCache(repoIdStr, REPO_EMB_CACHE + repoIdStr, JSONArray.class);
        if (cachedJsonArr == null) {
            return Lists.newArrayList();
        }
        return cachedJsonArr.toJavaList(EmbContent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRepoEmbContentCache(String repoIdStr, List<EmbContent> embContentList) {
        Object object = REPO_EMB_LOCK;
        synchronized (object) {
            Set dataIdSet = embContentList.stream().map(EmbContent::getDataId).collect(Collectors.toSet());
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5199\u7f13\u5b58,\u51c6\u5907\u6279\u91cf\u5b58\u5411\u91cf\u5e93\u7684\u6570\u636e,repoId:[{}],dataIdSet:[{}]", (Object)repoIdStr, dataIdSet);
            StructuredEmbeddingHandler.writeCache(repoIdStr, REPO_EMB_CACHE + repoIdStr, embContentList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRepoEmbContentCache(String repoIdStr) {
        Object object = REPO_EMB_LOCK;
        synchronized (object) {
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u7f13\u5b58,\u51c6\u5907\u6279\u91cf\u5b58\u5411\u91cf\u5e93\u7684\u6570\u636e,repoId:[{}]", (Object)repoIdStr);
            StructuredEmbeddingHandler.removeCache(repoIdStr, REPO_EMB_CACHE + repoIdStr);
        }
    }

    public static List<EmbContent> readEmbDataCache(String repoIdStr, String dataId) {
        JSONArray cachedJsonArr = StructuredEmbeddingHandler.readCache(repoIdStr, REPO_DATA_EMB_CACHE + dataId, JSONArray.class);
        if (cachedJsonArr == null) {
            return Lists.newArrayList();
        }
        return cachedJsonArr.toJavaList(EmbContent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeEmbDataCache(String repoIdStr, String dataId, List<EmbContent> embContentList) {
        Object object = REPO_DATA_EMB_LOCK;
        synchronized (object) {
            Set dataIdSet = embContentList.stream().map(EmbContent::getDataId).collect(Collectors.toSet());
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5199\u7f13\u5b58,emb\u5b8c\u6210\u51c6\u5907\u5b8c\u6574\u5b58\u5411\u91cf\u5e93\u7684\u6570\u636e,repoId:[{}],dataIdSet:[{}]", (Object)repoIdStr, dataIdSet);
            StructuredEmbeddingHandler.writeCache(repoIdStr, REPO_DATA_EMB_CACHE + dataId, embContentList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEmbDataCache(String repoIdStr, String dataId) {
        Object object = REPO_DATA_EMB_LOCK;
        synchronized (object) {
            log.info(Constant.RepoSchema.LOG_PREFIX + "\u5220\u7f13\u5b58,emb\u5b8c\u6210\u51c6\u5907\u5b8c\u6574\u5b58\u5411\u91cf\u5e93\u7684\u6570\u636e,repoId:[{}]", (Object)repoIdStr);
            StructuredEmbeddingHandler.removeCache(repoIdStr, REPO_DATA_EMB_CACHE + dataId);
        }
    }

    public static <T> T readCache(String cacheId, String key, Class<T> clazz) {
        IAppCache cache = EngineCache.getAppCache(cacheId);
        return StructuredEmbeddingHandler.readCache(cache, key, clazz);
    }

    public static <T> T readCache(IAppCache cache, String key, Class<T> clazz) {
        return (T)cache.get(key, clazz);
    }

    public static void writeCache(String cacheId, String key, Object value) {
        IAppCache cache = EngineCache.getAppCache(cacheId);
        cache.put(key, value);
    }

    public static void writeCache(IAppCache cache, String key, Object value) {
        cache.put(key, value);
    }

    public static void removeCache(String cacheId, String key) {
        IAppCache cache = EngineCache.getAppCache(cacheId);
        cache.remove(key);
    }

    public static void removeCache(IAppCache cache, String key) {
        cache.remove(key);
    }
}

