/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Action;
import kd.bos.exception.KDBizException;

public class ActionTypeAdapter
implements JsonDeserializer<Action>,
JsonSerializer<Action> {
    private static final String ACTION_TYPE = "type";
    private static final String PROPERTIES = "properties";

    public Action deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement actionTypeJson = jsonObject.get(ACTION_TYPE);
        if (actionTypeJson == null) {
            throw new KDBizException(Errors.actionJsonDataError("ActionType\u8282\u70b9\u4e0d\u5b58\u5728"), new Object[0]);
        }
        String type = actionTypeJson.getAsString();
        JsonElement element = jsonObject.get(PROPERTIES);
        try {
            return (Action)context.deserialize(element, Class.forName(type));
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonParseException("Unknown element type: " + type, (Throwable)cnfe);
        }
    }

    public JsonElement serialize(Action action, Type typeOfT, JsonSerializationContext context) {
        if (action == null) {
            return null;
        }
        JsonObject result = new JsonObject();
        result.add(ACTION_TYPE, (JsonElement)new JsonPrimitive(action.getClass().getName()));
        result.add(PROPERTIES, context.serialize((Object)action, action.getClass()));
        return result;
    }
}

