/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.gptas.webapi.ConversionResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class BillSaveCustomAction
implements IGPTAction {
    private Log logger = LogFactory.getLog(BillSaveCustomAction.class);

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        String data = map.get("param");
        this.logger.warn("param:{}", (Object)data);
        Map<String, String> resultMap = new HashMap<String, String>(1);
        JSONObject apiData = JSONObject.parseObject((String)data);
        boolean success = (Boolean)apiData.get("status");
        if (success) {
            Map dataMap = (Map)apiData.get("data");
            Map bizOutPutMap = (Map)dataMap.get("bizOutput");
            for (Map.Entry formData : bizOutPutMap.entrySet()) {
                OperationResult operateResult;
                ConversionResult result;
                Map billData = (Map)bizOutPutMap.get(formData.getKey());
                String bizFormId = (String)billData.get("bizFormId");
                String bizAppId = (String)billData.get("bizAppId");
                Map billDataMap = (Map)billData.get("data");
                String pkId = (String)billDataMap.get("id");
                if (StringUtils.isEmpty((String)pkId)) {
                    result = (ConversionResult)DispatchServiceHelper.invokeBOSService((String)bizAppId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{"kd.bos.gptas.webapi.WebApiDataConvertService", "convertData", new Object[]{bizFormId, bizAppId, billDataMap}});
                    operateResult = SaveServiceHelper.saveOperate((String)"save", (String)bizFormId, (DynamicObject[])new DynamicObject[]{result.getData()});
                    resultMap = this.formatResult(operateResult, bizFormId, bizAppId);
                    continue;
                }
                result = (ConversionResult)DispatchServiceHelper.invokeBOSService((String)bizAppId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{"kd.bos.gptas.webapi.WebApiDataConvertService", "convertData", new Object[]{bizFormId, bizAppId, pkId, billDataMap}});
                operateResult = SaveServiceHelper.saveOperate((String)"save", (String)bizFormId, (DynamicObject[])new DynamicObject[]{result.getData()});
                resultMap = this.formatResult(operateResult, bizFormId, bizAppId);
            }
        }
        return resultMap;
    }

    public Map<String, String> formatResult(OperationResult operateResult, String entityName, String appId) {
        HashMap<String, String> resultMap = new HashMap<String, String>(1);
        boolean saveOperate = operateResult.isSuccess();
        List succcessPkIds = operateResult.getSuccessPkIds();
        int billCounts = operateResult.getBillCount();
        int successCount = succcessPkIds.size();
        int failedCount = billCounts - successCount;
        if (!saveOperate) {
            ValidateResultCollection resultCollection = operateResult.getValidateResult();
            List errors = resultCollection.getValidateErrors();
            JSONObject messageJson = new JSONObject();
            for (ValidateResult error : errors) {
                List errorInfos = error.getAllErrorInfo();
                ArrayList<String> infoMessage = new ArrayList<String>(errorInfos.size());
                for (OperateErrorInfo errorInfo : errorInfos) {
                    String errorMessage = errorInfo.getMessage();
                    infoMessage.add(errorMessage);
                }
                messageJson.put("info", infoMessage);
            }
            messageJson.put("error", (Object)operateResult.getMessage());
            resultMap.put("message", messageJson.toJSONString());
        }
        JSONArray dataArray = new JSONArray();
        this.logger.info("bill save successIds:{}", (Object)succcessPkIds);
        for (Object id : succcessPkIds) {
            DynamicObject successDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(String.valueOf(id)), (String)entityName);
            JSONObject dataJson = new JSONObject();
            String billNo = "";
            IDataEntityType dataEntityType = successDynamicObject.getDataEntityType();
            if (dataEntityType instanceof BasedataEntityType) {
                billNo = successDynamicObject.getString("number");
            } else if (dataEntityType instanceof EntryType) {
                billNo = successDynamicObject.getString("billno");
            } else if (dataEntityType instanceof BillEntityType) {
                billNo = successDynamicObject.getString("billno");
            }
            dataJson.put("id", id);
            dataJson.put("billNo", (Object)billNo);
            dataArray.add((Object)dataJson);
            String url = String.format("bizAction://currentPage?gaiShow=1&gaiAction=showBillForm&gaiParams={\"appId\":\"%s\",\"billFormId\":\"%s\",\"billPkId\":\"%s\"}&title=%s&iconType=web&method=bizAction", appId, entityName, id, billNo);
            String text = "\u56de\u586b\u6210\u529f\uff0c\u5df2\u4e3a\u60a8\u751f\u6210\u65b0\u7684\u5355\u636e\uff0c\u60a8\u53ef\u70b9\u51fb\u4e0b\u65b9\u5355\u636e\u7f16\u7801\u8df3\u8f6c\u81f3\u5355\u636e\u9875\u9762.";
            resultMap.put("url", url);
            resultMap.put("text", text);
        }
        resultMap.put("status", String.valueOf(saveOperate));
        resultMap.put("successCount", String.valueOf(successCount));
        resultMap.put("failCount", String.valueOf(failedCount));
        resultMap.put("data", dataArray.toJSONString());
        return resultMap;
    }
}

