/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.chat.ChatHistoryMessage;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.memory.ChatMemoryService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ChatHistoryMessageAction
implements IGPTAction {
    private static Log logger = LogFactory.getLog(ChatHistoryMessageAction.class);
    public static final String CHAT_SESSION_ID_KEY = "chatSessionId";
    public static final String CHAT_REMEMBER_COUNT_KEY = "top";
    public static final String CHAT_ENABLE_TOP_KEY = "enableTop";
    public static final String HISTORY_MESSAGE_KEY = "history";

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        if (params == null) {
            logger.warn("\u3010ChatHistoryMessageAction\u3011Input parameters are null");
            return new HashMap<String, String>();
        }
        String chatSessionId = params.get(CHAT_SESSION_ID_KEY);
        if (StringUtils.isEmpty((CharSequence)chatSessionId)) {
            logger.warn("\u3010ChatHistoryMessageAction\u3011Required parameters are empty:  sessionId={}", (Object)chatSessionId);
            return params;
        }
        String rememberCount = params.get(CHAT_REMEMBER_COUNT_KEY);
        String enableTopStr = params.get(CHAT_ENABLE_TOP_KEY);
        boolean enbaleTop = false;
        int top = 0;
        if (StringUtils.isNotEmpty((CharSequence)enableTopStr)) {
            enbaleTop = Boolean.parseBoolean(enableTopStr);
            if (enbaleTop && StringUtils.isEmpty((CharSequence)rememberCount)) {
                throw new RuntimeException("top is not null");
            }
            top = Integer.parseInt(rememberCount);
        }
        List<UserHistoryMessage> chatSessionHistory = ChatMemoryService.getChatSessionHistory(chatSessionId, enbaleTop, top);
        logger.info("\u3010ChatHistoryMessageAction\u3011chatSessionId:{},history :{}", (Object)chatSessionId, (Object)JsonUtil.toJson(chatSessionHistory));
        List<ChatHistoryMessage> chatHistoryMessages = ChatMemoryService.chatMsgCoversion(chatSessionHistory);
        params.put(HISTORY_MESSAGE_KEY, JsonUtil.toJson(chatHistoryMessages));
        logger.info("\u3010ChatHistoryMessageAction\u3011chatSessionId:{},params :{}", (Object)chatSessionId, (Object)JsonUtil.toJson(params));
        return params;
    }
}

