/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class Ocr
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(Ocr.class);
    private static final String ocrAction = "bill_ocr";
    private static final String business_object = "gai_operation";
    private static final String OCR_IMAGE_PER = "data:image/png;base64,";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> invokeAction(String action, Map<String, String> fileInfo) {
        logger.info(String.format("bill_ocr,\u5f53\u524d\u9884\u7f6e\u64cd\u4f5c\uff1a%s", action));
        if (!ocrAction.equalsIgnoreCase(action)) {
            logger.error(String.format("bill_ocr,\u8c03\u7528\u64cd\u4f5c\u6709\u8bef\uff1a%s", GaiErrorCode.OCR_OPREATE_ERROR.getMsg()));
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.OCR_OPREATE_ERROR), new Object[0]);
        }
        HashMap<String, String> orcResult = new HashMap<String, String>(1);
        String filePath = fileInfo.get("file_path");
        FileService imageFileService = FileServiceFactory.getImageFileService();
        try (InputStream in = imageFileService.getInputStream(filePath);){
            String templateNumber = "OPM-GeneralTablePreset";
            String imageData = this.getImageBase64ByIO(in);
            String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])new Object[]{business_object, templateNumber, imageData});
            OcrResult result = (OcrResult)SerializationUtils.fromJsonString((String)resultStr, OcrResult.class);
            int errCode = result.getErrorCode();
            if (0 != errCode) {
                throw new KDBizException(GaiExceptionUtil.buildCvpErr(errCode, result.getDescription()), new Object[0]);
            }
            orcResult.put("ocrData", SerializationUtils.toJsonString((Object)result.getData()));
            HashMap<String, String> hashMap = orcResult;
            return hashMap;
        }
        catch (IOException e) {
            logger.error(String.format("bill_ocr,\u8bc6\u522b\u5f02\u5e38\uff1a%s", e.getMessage()), (Throwable)e);
            throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.OCR_MSERVICE_ERROR), new Object[0]);
        }
    }

    private String getImageBase64ByIO(InputStream in) throws IOException {
        try (ByteArrayOutputStream ba = new ByteArrayOutputStream();){
            int len;
            byte[] bs = new byte[1024];
            while ((len = in.read(bs)) != -1) {
                ba.write(bs, 0, len);
            }
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] imgByte = encoder.encode(ba.toByteArray());
            String string = OCR_IMAGE_PER + new String(imgByte, "UTF-8");
            return string;
        }
    }

    static class OcrResult {
        private String requestId;
        private int errorCode;
        private String description;
        private Object data;

        OcrResult() {
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

