/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.process;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.ApiChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.SkillSrcEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AgentSyncCall
implements IGPTAction {
    private static Log logger = LogFactory.getLog(AgentSyncCall.class);

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        String agentId = map.get("agentId");
        String input = map.get("input");
        Context context = Context.create(SLIDEENV.API_MSERVICE, 0L, null, null, null, null);
        String chatSessionId = context.getChatSessionId();
        FlowCacheData.putContext(chatSessionId, context);
        Skill skill = new Skill();
        skill.setId(agentId);
        skill.setType(Skill.Type.AGENT);
        skill.setSkillSrc(SkillSrcEnum.USER);
        context.setCurrentSkill(skill);
        FlowCacheData.putContext(chatSessionId, context);
        JSONObject configJo = new JSONObject();
        Message userMessage = MessageService.insertMessage(context.getChatSessionId(), input, "", configJo.toJSONString(), skill, ChatMessageTypeEnum.USER, EnableEnum.NO);
        HashMap<String, String> inParaMap = new HashMap<String, String>();
        inParaMap.put("asTool", "true");
        ChatService.startJavaAgentChat(context, userMessage, inParaMap);
        Map<String, String> result = this.getAssistantMessage(userMessage.getRunId());
        return result;
    }

    Map<String, String> getAssistantMessage(Long runId) {
        Long end;
        Long start = System.currentTimeMillis();
        HashMap<String, String> result = new HashMap<String, String>();
        do {
            String message;
            if ((message = this.getRunMessage(runId)) != null) {
                result.put("data", message);
                break;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } while (((end = Long.valueOf(System.currentTimeMillis())) - start) / 1000L <= 600L);
        return result;
    }

    public String getRunMessage(long runId) {
        ApiChatMessageDTO apiChatMessageDTO = AgentSyncCall.getAssistantMessage(runId);
        if (apiChatMessageDTO == null) {
            return null;
        }
        String result = JSONObject.toJSONString((Object)new BaseResult(apiChatMessageDTO));
        logger.info("runMessage result:{}", (Object)result);
        return result;
    }

    public static ApiChatMessageDTO getAssistantMessage(long runId) {
        ApiChatMessageDTO apiChatMessageDTO = null;
        DynamicObject messageDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (QFilter[])new QFilter("runid", "=", (Object)runId).and("type", "=", (Object)ChatMessageTypeEnum.ASSISTANT.getId()).toArray());
        if (messageDo != null) {
            Long sessionId = messageDo.getLong("sessionid");
            ChatSessionDTO chatSessionDTO = ChatService.getChatSession(sessionId);
            apiChatMessageDTO = new ApiChatMessageDTO();
            apiChatMessageDTO.setChatSessionId(chatSessionDTO.getId());
            apiChatMessageDTO.setSessionId(StrUtils.longAsString(sessionId));
            apiChatMessageDTO.setRunId(StrUtils.longAsString(runId));
            apiChatMessageDTO.setMessageId(StrUtils.longAsString((Long)messageDo.getPkValue()));
            apiChatMessageDTO.setMessage(messageDo.getString("content_tag"));
            apiChatMessageDTO.setType(messageDo.getLong("type"));
            apiChatMessageDTO.setCreateTime(KDDateFormatUtils.getDateTimeFormat().format(messageDo.getDate("createtime")));
        }
        return apiChatMessageDTO;
    }
}

