/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.util.GaiCacheManager;
import kd.bos.entity.cache.IAppCache;
import kd.bos.util.StringUtils;

public class CacheUtil {
    private static ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocal();
    private static ThreadLocal<String> tlSessionId = new ThreadLocal();

    public static void setSessionId(String sessionId) {
        if (StringUtils.isEmpty((String)sessionId)) {
            tlSessionId.remove();
        } else {
            tlSessionId.set(sessionId);
        }
    }

    public static String getFromCache(String key) {
        String sessionId = tlSessionId.get();
        Map<String, Object> map = StringUtils.isNotEmpty((String)sessionId) ? CacheUtil.getFromAppCache(sessionId) : threadLocal.get();
        if (map == null) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    private static Map<String, Object> getFromAppCache(String sessionId) {
        IAppCache appCache;
        String cacheVal;
        JSONObject map = null;
        if (StringUtils.isNotEmpty((String)sessionId) && StringUtils.isNotEmpty((String)(cacheVal = (String)(appCache = GaiCacheManager.get().getAppCache()).get("NL2SQL." + sessionId + ".Cache", String.class)))) {
            map = JSON.parseObject((String)cacheVal);
        }
        return map;
    }

    private static void putToAppCache(String sessionId, Map<String, Object> map) {
        IAppCache appCache = GaiCacheManager.get().getAppCache();
        appCache.put("NL2SQL." + sessionId + ".Cache", (Object)JSON.toJSONString(map));
    }

    public static void putToCache(String key, Object val) {
        String sessionId = tlSessionId.get();
        Map<String, Object> map = StringUtils.isNotEmpty((String)sessionId) ? CacheUtil.getFromAppCache(sessionId) : threadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>(3);
        }
        map.put(key, val);
        threadLocal.set(map);
        if (StringUtils.isNotEmpty((String)sessionId)) {
            CacheUtil.putToAppCache(sessionId, map);
        }
    }

    public static void clearLocalCache() {
        threadLocal.remove();
        tlSessionId.remove();
    }
}

