/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.query;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.FTLikeHint;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.NotLikeHint;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.util.StringUtils;

public class ConvertQFilterToAlgo {
    private QFilter qFilter;

    public ConvertQFilterToAlgo(QFilter qFilter) {
        this.qFilter = qFilter;
    }

    public String tryConvertToAlgoExpression() throws IllegalArgumentException {
        StringBuilder s = new StringBuilder(128);
        this.tryConvertToAlgoExpression(s);
        List nests = this.qFilter.getNests(false);
        if (!nests.isEmpty()) {
            this.resolveNests(nests, s, nest -> {
                String subFilter = new ConvertQFilterToAlgo(nest.getFilter()).tryConvertToAlgoExpression();
                if (StringUtils.isNotEmpty((String)subFilter)) {
                    if (s.length() > 0) {
                        s.append(' ').append(nest.getOp()).append(' ');
                    }
                    s.append(subFilter);
                }
                return null;
            });
        }
        return s.toString();
    }

    private void resolveNests(List<QFilter.QFilterNest> nests, StringBuilder s, Function<QFilter.QFilterNest, Void> nestFun) {
        boolean withOr = false;
        boolean allOr = true;
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                allOr = false;
                continue;
            }
            withOr = true;
        }
        if (withOr) {
            s.insert(0, '(');
        }
        if (allOr) {
            for (QFilter.QFilterNest nest : nests) {
                nestFun.apply(nest);
            }
        } else {
            boolean preIsAnd = true;
            for (QFilter.QFilterNest nest : nests) {
                boolean and = nest.isAnd();
                if (!preIsAnd && and) {
                    s.insert(0, '(');
                    s.append(')');
                }
                nestFun.apply(nest);
                preIsAnd = and;
            }
        }
        if (withOr) {
            s.append(')');
        }
    }

    private void tryConvertToAlgoExpression(StringBuilder s) {
        String lcp = this.qFilter.getCP().toLowerCase(Locale.ENGLISH);
        if ("exists".equals(lcp) || "not exists".equals(lcp)) {
            throw new IllegalArgumentException("Cannot convert to Algo expression. QCP.EXISTS, QCP.NOT_EXISTS does not supported.");
        }
        if (this.qFilter.isJoinFilter()) {
            throw new IllegalArgumentException("Cannot convert to Algo expression. Join filter does not supported.");
        }
        if (this.qFilter.__getSelfDefinedQParameter() != null) {
            throw new IllegalArgumentException("Cannot convert to Algo expression. SelfDefinedQParameter does not supported.");
        }
        if (this.qFilter.isExpressValue()) {
            throw new IllegalArgumentException("Cannot convert to Algo expression. ExpressValue does not supported.");
        }
        boolean needAppendCp = true;
        boolean needAppendValue = true;
        if ("ftlike".equals(lcp) || "match".equals(lcp)) {
            QFilter qFilter = this.parseFtlike();
            s.append(new ConvertQFilterToAlgo(qFilter).tryConvertToAlgoExpression());
            return;
        }
        StringBuilder tmpStr = new StringBuilder();
        tmpStr.append(this.qFilter.getProperty()).append(' ');
        QFilterHint qFilterHint = this.qFilter.getQFilterHint();
        if (qFilterHint != null) {
            Object v = null;
            if (qFilterHint instanceof LikeHint) {
                LikeHint likeHint = (LikeHint)qFilterHint;
                v = this.getValue(likeHint.isAppendLeftPercent(), likeHint.isAppendRightPercent(), likeHint.isEscape());
            } else if (qFilterHint instanceof NotLikeHint) {
                NotLikeHint notLikeHint = (NotLikeHint)qFilterHint;
                v = this.getValue(notLikeHint.isAppendLeftPercent(), notLikeHint.isAppendRightPercent(), notLikeHint.isEscape());
            } else if (qFilterHint instanceof FTLikeHint) {
                FTLikeHint ftLikeHint = (FTLikeHint)qFilterHint;
                v = this.getValue(ftLikeHint.isAppendLeftPercent(), ftLikeHint.isAppendRightPercent(), ftLikeHint.isEscape());
            }
            tmpStr.append(lcp).append(' ').append('\'').append(v).append('\'');
            needAppendCp = false;
            needAppendValue = false;
        }
        if (this.qFilter.getValue() instanceof QEmptyValue) {
            if ("=".equals(lcp)) {
                tmpStr.append("is null");
                needAppendCp = false;
                needAppendValue = false;
            } else if ("!=".equals(lcp)) {
                tmpStr.append("is not null");
                needAppendCp = false;
                needAppendValue = false;
            }
        }
        if (needAppendCp) {
            tmpStr.append(lcp);
        }
        if (lcp.equals("is null") || lcp.equals("is not null")) {
            needAppendValue = false;
        }
        if (needAppendValue) {
            Object[] params = null;
            Object value = this.qFilter.getValue();
            if (value.getClass().isArray()) {
                int c = Array.getLength(value);
                Object[] set = new HashSet<Object>(c);
                for (int i = 0; i < c; ++i) {
                    set.add(Array.get(value, i));
                }
                params = set.toArray(new Object[0]);
            } else if (value instanceof Set) {
                params = ((Set)value).toArray(new Object[0]);
            } else if (value instanceof Collection) {
                HashSet set = new HashSet((Collection)value);
                params = set.toArray(new Object[0]);
            } else if (value instanceof Iterable) {
                HashSet set = new HashSet(16);
                for (Object item : (Iterable)value) {
                    set.add(item);
                }
                params = set.toArray(new Object[0]);
            } else {
                Object originValue;
                params = value instanceof MultiBaseDataFilterValue ? ((originValue = ((MultiBaseDataFilterValue)value).getValue()) instanceof Collection ? ((Collection)originValue).toArray() : new Object[]{originValue}) : new Object[]{value};
            }
            StringBuilder sb = new StringBuilder(params.length * 10);
            for (Object param : params) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (param == null) continue;
                Class<?> cls = param.getClass();
                if (QFilterUtil.isNumber(cls) || cls == Boolean.class) {
                    sb.append(param);
                    continue;
                }
                sb.append('\'').append(param).append('\'');
            }
            if (sb.length() == 0) {
                tmpStr = null;
            } else {
                String valueString = sb.toString();
                if (lcp.equals("in") || lcp.equals("not in")) {
                    tmpStr.append(" (").append(valueString).append(')');
                } else {
                    tmpStr.append(' ').append(valueString);
                }
            }
        }
        if (tmpStr != null && tmpStr.length() > 0) {
            s.append((CharSequence)tmpStr);
        }
    }

    private Object getValue(boolean addLeftPercent, boolean addRightPercent, boolean escape) {
        Object value = this.qFilter.getValue();
        if (!(value instanceof String)) {
            return value;
        }
        String newValue = (String)value;
        if (escape) {
            newValue = ORMUtil.escapeChars((String)newValue, null);
        }
        if (addLeftPercent) {
            newValue = "%" + newValue;
        }
        if (addRightPercent) {
            newValue = newValue + "%";
        }
        return newValue;
    }

    private QFilter parseFtlike() {
        boolean isMatchSolt = QMatches._isMatchSolt((String)this.qFilter.getProperty());
        QMatches.Match m = isMatchSolt ? QMatches.__decode((String)String.valueOf(this.qFilter.getOriginValue())) : new QMatches.Match(new String[]{String.valueOf(this.qFilter.getOriginValue())}, new String[]{this.qFilter.getProperty()});
        boolean isMultiValue = QMatches.__isMultiValueMatchSolt((String)this.qFilter.getProperty());
        QFilter ret = null;
        String lcp = "like";
        for (String property : m.getProperties()) {
            for (String value : m.getValues()) {
                QFilter f;
                if (isMultiValue) {
                    String[] andVS = QMatches.splitMultiValue((String)value);
                    QFilter f2 = null;
                    for (String v : andVS) {
                        QFilter ff;
                        if (ORMUtil.isFtlikeStartWith((QFilterHint)this.qFilter.getQFilterHint())) {
                            ff = new QFilter(property, lcp, (Object)v, (QFilterHint)QFilterHint.STARTWITH);
                        } else if (ORMUtil.isFtlikeContains((QFilterHint)this.qFilter.getQFilterHint())) {
                            ff = new QFilter(property, lcp, (Object)v, (QFilterHint)QFilterHint.CONTAINS);
                        } else {
                            v = "%" + v + "%";
                            ff = new QFilter(property, lcp, (Object)v);
                        }
                        f2 = f2 == null ? ff : f2.and(ff);
                    }
                    ret = ret == null ? f2 : ret.or(f2);
                    continue;
                }
                if (ORMUtil.isFtlikeStartWith((QFilterHint)this.qFilter.getQFilterHint())) {
                    f = new QFilter(property, lcp, (Object)value, (QFilterHint)QFilterHint.STARTWITH);
                } else if (ORMUtil.isFtlikeContains((QFilterHint)this.qFilter.getQFilterHint())) {
                    f = new QFilter(property, lcp, (Object)value, (QFilterHint)QFilterHint.CONTAINS);
                } else {
                    value = "%" + value + "%";
                    f = new QFilter(property, lcp, (Object)value);
                }
                ret = ret == null ? f : ret.or(f);
            }
        }
        return ret;
    }
}

