/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.ai.gai.core.engine.sys.action.query.CacheUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.oql.q.expr.QInfo;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class OQLExecutor
implements IGPTAction {
    private static final Log log = LogFactory.getLog(OQLExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        String returnType = map.get("return_type");
        String key = map.get("key");
        String entityNumber = map.get("entity");
        String oql = map.get("oql");
        String sessionId = map.get("sessionId");
        CacheUtil.setSessionId(sessionId);
        log.info("{} {}", (Object)entityNumber, (Object)oql);
        HashMap<String, String> rtn = new HashMap<String, String>(4);
        rtn.put("data", "");
        rtn.put("status", "true");
        rtn.put("message", "");
        try {
            QInfo qInfo = QInfo.parse((String)oql, (boolean)false);
            String orderBys = qInfo.getOrderBys();
            int top = qInfo.getTop();
            if (top == 0) {
                top = -1;
                qInfo.setTop(-1);
            }
            boolean needSubQuery = false;
            if (StringUtils.isEmpty((String)qInfo.getSelectFields())) {
                String[] props = new LinkedHashSet();
                MainEntityType met = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                this.getSelectList(entityNumber, met.getProperties(), (Set<String>)props);
                String selectFields = String.join((CharSequence)",", (Iterable<? extends CharSequence>)props);
                qInfo.setSelectFields(selectFields);
            } else if (StringUtils.isNotEmpty((String)orderBys)) {
                for (String exception : qInfo.getSelectFields().split(",")) {
                    String string = exception.toLowerCase();
                    if (!string.contains("as") || !orderBys.toLowerCase().contains(string.split("as")[1].trim())) continue;
                    needSubQuery = true;
                    break;
                }
            }
            String oldFilter = qInfo.getFilters();
            qInfo.setFilters(this.appendFilter(entityNumber, qInfo.getFilters()));
            rtn.put("oql", qInfo.toString());
            log.info("execute oql {}", rtn.get("oql"));
            if (needSubQuery) {
                qInfo.setOrderBys(null);
                qInfo.setTop(-1);
            }
            HashMap<String, List<Object>> data = new HashMap<String, List<Object>>(2);
            Throwable throwable = null;
            try (DataSet dataSet = ORM.create().queryDataSet("AI.OQLExecutor", qInfo.toString(), null);
                 DataSet sortDataSet = needSubQuery ? dataSet.orderBy(orderBys.split(",")) : dataSet;
                 DataSet topDataSet = needSubQuery && top > 0 ? sortDataSet.top(top) : sortDataSet;){
                int dataCount = this.readRowData(topDataSet, data);
                rtn.put("count", String.valueOf(dataCount));
                String dataStatus = "ok";
                if (dataCount == 0) {
                    int count;
                    dataStatus = !Objects.equals(oldFilter, qInfo.getFilters()) ? ((count = this.countData(entityNumber, oldFilter)) == 0 ? "noData" : "noPerm") : "noData";
                }
                rtn.put("dataStatus", dataStatus);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            String s1 = "";
            try {
                if ("withEntity".equals(returnType)) {
                    HashMap<String, HashMap<String, List<Object>>> hashMap = new HashMap<String, HashMap<String, List<Object>>>();
                    hashMap.put(entityNumber, data);
                    s1 = JSONUtils.toString(hashMap);
                } else if ("withKey".equals(returnType)) {
                    HashMap<String, HashMap<String, List<Object>>> hashMap = new HashMap<String, HashMap<String, List<Object>>>();
                    hashMap.put(key, data);
                    s1 = JSONUtils.toString(hashMap);
                } else {
                    s1 = JSONUtils.toString(data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            rtn.put("data", s1);
        }
        catch (Exception ex) {
            log.info(ex.getMessage(), (Object)ex);
            rtn.put("message", ex.getMessage());
            rtn.put("status", "false");
        }
        finally {
            CacheUtil.clearLocalCache();
        }
        return rtn;
    }

    protected int countData(String entity, String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            return ORM.create().count("AI.OQLExecutor.count", entity, new QFilter[0]);
        }
        return ORM.create().count("AI.OQLExecutor.count", entity, new QFilter[]{QFilter.of((String)filter, (Object[])new Object[0])});
    }

    protected String appendFilter(String entityNumber, String filters) {
        return filters;
    }

    private int readRowData(DataSet dataSet, Map<String, List<Object>> data) {
        RowMeta rowMeta = dataSet.getRowMeta();
        int columnCount = rowMeta.getFieldCount();
        ArrayList<String> fieldNames = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            fieldNames.add(rowMeta.getFieldName(i));
        }
        data.put("fieldNames", fieldNames);
        ArrayList values = new ArrayList(10);
        data.put("values", values);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ArrayList<Object> rowData = new ArrayList<Object>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                rowData.add(row.get(i));
            }
            values.add(rowData);
        }
        return values.size();
    }

    private int readRowData(DataSet dataSet, List<Map<String, Object>> data) {
        RowMeta rowMeta = dataSet.getRowMeta();
        int columnCount = rowMeta.getFieldCount();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>(columnCount);
            data.add(rowData);
            for (int i = 0; i < columnCount; ++i) {
                rowData.put(rowMeta.getFieldName(i), row.get(i));
            }
        }
        return data.size();
    }

    public void getSelectList(String entityName, DataEntityPropertyCollection properties, Set<String> props) {
        for (IDataEntityProperty dp : properties) {
            String parentEntityId = this.getParentEntityId(dp.getParent());
            if (dp instanceof EntryProp) {
                EntryProp entry = (EntryProp)dp;
                DynamicObjectType dot = entry.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = dot.getProperties();
                this.getSelectList(entry.getName(), entryProperties, props);
                continue;
            }
            if (!this.canShow(dp)) continue;
            String mainKey = dp.getName();
            if (StringUtils.isNotEmpty((String)parentEntityId)) {
                mainKey = String.format("%s.%s", parentEntityId, mainKey);
            }
            if (dp instanceof BasedataProp) {
                BasedataProp bd = (BasedataProp)dp;
                DynamicObjectType ref = bd.getDynamicComplexPropertyType();
                DataEntityPropertyCollection subPS = ref.getProperties();
                for (IDataEntityProperty subDP : subPS) {
                    String subKey;
                    if (!this.canShow(subDP) || !"id".equalsIgnoreCase(subKey = subDP.getName()) && !"number".equalsIgnoreCase(subKey) && !"name".equalsIgnoreCase(subKey)) continue;
                    props.add(String.format("%s.%s", mainKey, subKey));
                }
                continue;
            }
            props.add(mainKey);
        }
    }

    private String getParentEntityId(IDataEntityType dataEntityType) {
        String parentId = "";
        while (dataEntityType != null) {
            String pid = dataEntityType.getName();
            parentId = StringUtils.isEmpty((String)parentId) ? pid : String.format("%s.%s", pid, parentId);
            dataEntityType = dataEntityType.getParent();
        }
        parentId = !parentId.contains(".") ? "" : parentId.substring(parentId.indexOf(46) + 1);
        return parentId;
    }

    private boolean canShow(IDataEntityProperty dp) {
        return !(dp instanceof DynamicLocaleProperty) && StringUtils.isNotEmpty((String)dp.getAlias());
    }
}

