/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.nl2api.model.PlainField;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class ParseStringToMarkdown
implements IGPTAction {
    public static List<String> extractFieldInfo(String jsonString, List<String> fieldDesc) {
        JSONObject root = JSONObject.parseObject((String)jsonString);
        JSONArray fieldInfoList = root.getJSONArray("fieldInfoList");
        ArrayList<String> fieldIdList = new ArrayList<String>();
        for (int i = 0; i < fieldInfoList.size(); ++i) {
            JSONObject fieldInfo = fieldInfoList.getJSONObject(i);
            JSONArray plainFieldList = fieldInfo.getJSONArray("plainFieldList");
            for (int j = 0; j < plainFieldList.size(); ++j) {
                JSONObject plainField = plainFieldList.getJSONObject(j);
                String fieldId = plainField.getString("fieldId");
                if (fieldId == null) continue;
                fieldIdList.add(fieldId);
                fieldDesc.add(plainField.getString("fieldName"));
            }
        }
        return fieldIdList;
    }

    public Map<String, String> invokeAction1(String s, Map<String, String> map) {
        int i;
        String content = map.get("content");
        String metaData = map.get("metaData");
        JSONObject root = JSONObject.parseObject((String)metaData);
        JSONArray fieldInfoList = root.getJSONArray("fieldInfoList");
        JSONObject fieldInfo = fieldInfoList.getJSONObject(0);
        JSONArray plainFieldList = fieldInfo.getJSONArray("plainFieldList");
        String entityNumber = fieldInfo.getString("entityNumber");
        List list = JSON.parseArray((String)plainFieldList.toJSONString(), PlainField.class);
        JSONArray jsonArray = JSONArray.parseArray((String)content);
        JSONArray js = JSONArray.parseArray((String)jsonArray.getString(0));
        ArrayList<String> filedDesces = new ArrayList<String>();
        List<String> filedNames = ParseStringToMarkdown.extractFieldInfo(metaData, filedDesces);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        String name = mainEntityType.getDisplayName().toString();
        Object[] dynamicObjects = DynamicObjectSerializeUtil.deserialize((String)js.toJSONString(), (DynamicObjectType)mainEntityType);
        StringBuilder builder = new StringBuilder();
        builder.append("###").append("\n");
        for (String filed : filedDesces) {
            if (filed.equalsIgnoreCase("id")) continue;
            builder.append("|").append(filed);
        }
        builder.append("|\n");
        builder.append("| ");
        for (i = 0; i < filedNames.size(); ++i) {
            builder.append("-------------------------|");
        }
        builder.append("\n");
        for (i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects[i];
            builder.append("|  ");
            for (String filed : filedNames) {
                if (filed.equalsIgnoreCase("id")) continue;
                list.stream().filter(plainField -> plainField.getFieldId().equalsIgnoreCase(filed)).forEach(plainField -> {
                    String value = String.valueOf(dynamicObject.get(filed));
                    if (plainField.getEnumKv() != null && plainField.getEnumKv().size() > 0) {
                        value = String.valueOf(plainField.getEnumKv().get(value));
                    }
                    if (plainField.getFieldType().equals("dateTime") || plainField.getFieldType().equals("date")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = dynamicObject.getDate(filed);
                        value = simpleDateFormat.format(date);
                    }
                    if (plainField.getFieldType().equals("Decimal") && dynamicObject.getBigDecimal(filed) != null) {
                        BigDecimal result = dynamicObject.getBigDecimal(filed).setScale(2, 4);
                        value = result.toPlainString();
                    }
                    builder.append(value).append(" |");
                });
            }
            builder.append("\n");
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("result", builder.toString());
        return maps;
    }

    public static Object flattenJson(Object json) {
        if (json instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)json;
            JSONObject flattenedObj = new JSONObject();
            for (String key : jsonObj.keySet()) {
                Object value = jsonObj.get((Object)key);
                if (value instanceof JSONObject) {
                    JSONObject nestedFlattened = (JSONObject)ParseStringToMarkdown.flattenJson(value);
                    for (String nestedKey : nestedFlattened.keySet()) {
                        flattenedObj.put(key + "." + nestedKey, nestedFlattened.get((Object)nestedKey));
                    }
                    continue;
                }
                if (value instanceof JSONArray) {
                    flattenedObj.put(key, ParseStringToMarkdown.flattenJson(value));
                    continue;
                }
                flattenedObj.put(key, value);
            }
            return flattenedObj;
        }
        if (json instanceof JSONArray) {
            JSONArray jsonArr = (JSONArray)json;
            JSONArray flattenedArr = new JSONArray();
            for (int i = 0; i < jsonArr.size(); ++i) {
                flattenedArr.add(ParseStringToMarkdown.flattenJson(jsonArr.get(i)));
            }
            return flattenedArr;
        }
        return json;
    }

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        int i;
        String content = map.get("content");
        String metaData = map.get("metaData");
        JSONObject root = JSONObject.parseObject((String)metaData);
        JSONArray fieldInfoList = root.getJSONArray("fieldInfoList");
        JSONObject fieldInfo = fieldInfoList.getJSONObject(0);
        JSONArray plainFieldList = fieldInfo.getJSONArray("plainFieldList");
        List list = JSON.parseArray((String)plainFieldList.toJSONString(), PlainField.class);
        JSONArray jsonArray = JSONArray.parseArray((String)content);
        Object flattenedJson = ParseStringToMarkdown.flattenJson(jsonArray);
        JSONArray flattenedJsonArray = JSONArray.parseArray((String)flattenedJson.toString());
        ArrayList<String> filedDesces = new ArrayList<String>();
        List<String> filedNames = ParseStringToMarkdown.extractFieldInfo(metaData, filedDesces);
        StringBuilder builder = new StringBuilder();
        builder.append("###").append("\n");
        for (String filed : filedDesces) {
            builder.append("|").append(filed);
        }
        builder.append("|\n");
        builder.append("| ");
        for (i = 0; i < filedNames.size(); ++i) {
            builder.append("-------------------------|");
        }
        builder.append("\n");
        for (i = 0; i < flattenedJsonArray.size(); ++i) {
            JSONObject jsonObject = flattenedJsonArray.getJSONObject(i);
            builder.append("|  ");
            for (String filed : filedNames) {
                if (filed.equalsIgnoreCase("id")) continue;
                list.stream().filter(plainField -> plainField.getFieldId().equalsIgnoreCase(filed)).forEach(plainField -> {
                    String value = String.valueOf(jsonObject.get((Object)filed));
                    if (plainField.getEnumKv() != null && plainField.getEnumKv().size() > 0) {
                        value = String.valueOf(plainField.getEnumKv().get(value));
                    }
                    if (plainField.getFieldType().equals("dateTime") || plainField.getFieldType().equals("date")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = jsonObject.getDate(filed);
                        value = simpleDateFormat.format(date);
                    }
                    if (plainField.getFieldType().equals("Decimal") && jsonObject.getBigDecimal(filed) != null) {
                        BigDecimal result = jsonObject.getBigDecimal(filed).setScale(2, 4);
                        value = result.toPlainString();
                    }
                    builder.append(value).append(" |");
                });
            }
            builder.append("\n");
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("result", builder.toString());
        return maps;
    }
}

