/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.query;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.ai.gai.core.engine.sys.action.query.CacheUtil;
import kd.ai.gai.core.engine.sys.action.query.ConvertQFilterToAlgo;
import kd.ai.gai.core.engine.sys.action.query.OQLExecutor;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.StringUtils;

public class PermUtil {
    private static final Log log = LogFactory.getLog(OQLExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPermissionFilters(String entityNumber) {
        String cacheKey = entityNumber + "/perm";
        long begin = System.currentTimeMillis();
        try {
            String cacheVal = CacheUtil.getFromCache(cacheKey);
            if (StringUtils.isNotEmpty((String)cacheVal) && !"empty".equals(cacheVal)) {
                String string = cacheVal;
                return string;
            }
            MainEntityType met = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)met.getAppId());
            List orgFilters = PermissionFilterUtil.getListPermissionFilters((MainEntityType)met, (boolean)true, (String)appId, null, (IUserService)new UserService());
            String filterExpr = "";
            if (!orgFilters.isEmpty()) {
                QFilter allFilter = null;
                for (QFilter filter : orgFilters) {
                    if (filter == null || !PermUtil.checkQFilter(filter)) continue;
                    if (allFilter == null) {
                        allFilter = filter;
                        continue;
                    }
                    allFilter.and(filter);
                }
                if (allFilter != null) {
                    filterExpr = new ConvertQFilterToAlgo(allFilter).tryConvertToAlgoExpression();
                }
            }
            CacheUtil.putToCache(cacheKey, StringUtils.isEmpty((String)filterExpr) ? "empty" : filterExpr);
            String string = filterExpr;
            return string;
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
        finally {
            long cost = System.currentTimeMillis() - begin;
            if (cost > 1000L) {
                log.info("PermUtil.getPermissionFilters cost:{}ms", (Object)cost);
            }
        }
        return "";
    }

    private static boolean checkQFilter(QFilter filter) {
        String lcp = filter.getCP().toLowerCase(Locale.ENGLISH);
        if (lcp.equals("in") || lcp.equals("not in")) {
            Object value = filter.getValue();
            if (value.getClass().isArray()) {
                int c = Array.getLength(value);
                return c != 0;
            }
            if (value instanceof Set) {
                return !((Set)value).isEmpty();
            }
            if (value instanceof Collection) {
                return !((Collection)value).isEmpty();
            }
        }
        return true;
    }
}

