/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.util.StringUtils;

public class StringAction
implements IGPTAction {
    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        if ("concat".equals(s)) {
            return this.concat(map);
        }
        if ("format".equals(s)) {
            return this.format(map);
        }
        if ("contains".equals(s)) {
            return this.contains(map);
        }
        if ("join".equals(s)) {
            return this.join(map);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> contains(Map<String, String> map) {
        String str1 = map.get("str1");
        String str2 = map.get("str2");
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        return this.buildData(str1.contains(str2) ? "1" : "0");
    }

    private Map<String, String> format(Map<String, String> map) {
        HashMap<String, String> rtn = new HashMap<String, String>(16);
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        for (String key : keys) {
            if (!key.startsWith("str")) continue;
            rtn.put(key, map.get(key));
        }
        if (rtn.isEmpty()) {
            return rtn;
        }
        for (String key : keys) {
            if (!key.startsWith("param.")) continue;
            String v = map.get(key);
            if (v == null) {
                v = "";
            }
            String param = key.substring(6);
            for (Map.Entry entry : rtn.entrySet()) {
                String sv = (String)entry.getValue();
                sv = sv.replaceAll("\\{\\{" + param + "}}", v);
                entry.setValue(sv);
            }
        }
        return rtn;
    }

    private Map<String, String> concat(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        keys.sort(Comparator.comparingInt(String::length).thenComparing(o -> o));
        for (String key : keys) {
            String v;
            if (!key.startsWith("str") || (v = map.get(key)) == null) continue;
            sb.append(v);
        }
        return this.buildData(sb.toString());
    }

    private Map<String, String> join(Map<String, String> map) {
        String sep = map.get("sep");
        if (StringUtils.isEmpty((String)sep)) {
            sep = ",";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        keys.sort(Comparator.comparingInt(String::length).thenComparing(o -> o));
        for (String key : keys) {
            String v;
            if (!key.startsWith("str") || (v = map.get(key)) == null) continue;
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(v);
        }
        return this.buildData(sb.toString());
    }

    private Map<String, String> buildData(String data) {
        HashMap<String, String> rtn = new HashMap<String, String>(1);
        rtn.put("data", data);
        return rtn;
    }
}

