/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.engine.sys.action.query.ConvertQFilterToAlgo;
import kd.ai.gai.core.util.PropUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ToolAction
implements IGPTAction {
    private static final Log log = LogFactory.getLog(ToolAction.class);
    private static final int INIT_CAP = 16;

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        if ("getConfigData".equals(s)) {
            String key = map.get("key");
            String value = this.getConfigData(key);
            return this.buildData("data", value);
        }
        if ("buildVarMap".equals(s)) {
            return map;
        }
        if ("mergeFilter".equals(s)) {
            return this.mergeFilter(map);
        }
        if ("mergeMap".equals(s)) {
            return this.mergeMap(map);
        }
        if ("getFromMap".equals(s)) {
            String value = this.getDataFromMap(map.get("key"), map.get("data"), map.get("default"));
            return this.buildData("data", value);
        }
        if ("getFromList".equals(s)) {
            String value = this.getDataFromList(map.get("key"), map.get("data"));
            return this.buildData("data", value);
        }
        if ("covertDBResult".equals(s)) {
            String value = this.covertDBResult(map);
            return this.buildData("data", value);
        }
        if ("printDBResult".equals(s)) {
            String value = this.printDBResult(map);
            return this.buildData("data", value);
        }
        if ("findFromMap".equals(s)) {
            String value = this.findFromMap(map.get("key"), map.get("data"), map.get("default"));
            return this.buildData("data", value);
        }
        if ("getCurrUserId".equals(s)) {
            return this.buildData("data", RequestContext.get().getCurrUserId() + "");
        }
        return Collections.emptyMap();
    }

    private Map<String, String> mergeMap(Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        JSONObject rtn = new JSONObject();
        for (String key : keys) {
            String v;
            if (!key.startsWith("map") || (v = map.get(key)) == null) continue;
            try {
                JSONObject itemJson = JSON.parseObject((String)v);
                rtn.putAll((Map)itemJson);
            }
            catch (Exception exception) {}
        }
        return this.buildData("data", rtn.toJSONString());
    }

    private String getConfigData(String key) {
        QFilter qFilter = new QFilter("name", "=", (Object)key);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"gai_n2a_param_config", (String)"name,value,value_tag", (QFilter[])new QFilter[]{qFilter});
        if (configs.length > 0) {
            String value = configs[0].getString("value");
            String valueTag = configs[0].getString("value_tag");
            return StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
        }
        return "";
    }

    private String getDataFromMap(String key, String data, String defVal) {
        if (defVal == null) {
            defVal = "";
        }
        if (StringUtils.isEmpty((String)key)) {
            return defVal;
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)data);
            Object keyVal = PropUtil.getValueByPath(jsonObject, key);
            return keyVal == null ? defVal : keyVal.toString();
        }
        catch (Exception exception) {
            return defVal;
        }
    }

    private String findFromMap(String key, String data, String defVal) {
        if (defVal == null) {
            defVal = "";
        }
        if (StringUtils.isEmpty((String)key)) {
            return defVal;
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)data);
            Set keySet = jsonObject.keySet();
            if (keySet.contains(key)) {
                return jsonObject.getString(key);
            }
            for (String ks : keySet) {
                if (ks.startsWith("*") && key.endsWith(ks.substring(1))) {
                    return jsonObject.getString(ks);
                }
                if (!ks.endsWith("*") || !key.startsWith(ks.substring(0, ks.length() - 1))) continue;
                return jsonObject.getString(ks);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defVal;
    }

    private String getDataFromList(String key, String data) {
        if (StringUtils.isEmpty((String)key)) {
            return "";
        }
        try {
            JSONArray jsonArray = JSON.parseArray((String)data);
            int idx = Integer.parseInt(key);
            Object keyVal = jsonArray.get(idx);
            return keyVal == null ? "" : keyVal.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private JSONArray getMergeRule(String mergeRule) {
        JSONArray rtn = new JSONArray();
        if (StringUtils.isNotEmpty((String)mergeRule)) {
            if (!mergeRule.startsWith("[")) {
                DynamicObject[] configs;
                String[] mrRule = mergeRule.split(",");
                ArrayList<String> nameList = new ArrayList<String>(mrRule.length);
                for (String s : mrRule) {
                    nameList.add(s.trim() + ".defaultFilter");
                }
                QFilter qFilter = new QFilter("name", "in", nameList);
                for (DynamicObject config : configs = BusinessDataServiceHelper.load((String)"gai_n2a_param_config", (String)"name,value,value_tag", (QFilter[])new QFilter[]{qFilter})) {
                    String value = config.getString("value");
                    String valueTag = config.getString("value_tag");
                    String string = value = StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
                    if (!value.startsWith("[")) continue;
                    try {
                        JSONArray array = JSON.parseArray((String)value);
                        rtn.addAll((Collection)array);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else {
                rtn = JSON.parseArray((String)mergeRule);
            }
        }
        return rtn;
    }

    private Map<String, String> mergeFilter(Map<String, String> map) {
        String fields = map.get("fields");
        String filterStr = map.get("filter");
        String groupBy = map.get("groupBy");
        String mergeRule = map.get("mergeRule");
        HashSet<String> groupBySet = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)groupBy)) {
            String[] split;
            for (String s : split = groupBy.split(",")) {
                groupBySet.add(s.trim());
            }
        }
        if (fields == null) {
            fields = "";
        }
        HashMap<String, String> rtn = new HashMap<String, String>();
        rtn.put("fields", fields);
        rtn.put("filter", filterStr);
        try {
            List filterNests;
            JSONArray ruleList = this.getMergeRule(mergeRule);
            if (ruleList.isEmpty()) {
                return rtn;
            }
            QFilter filter = null;
            if (StringUtils.isNotEmpty((String)filterStr)) {
                filter = QFilter.of((String)filterStr, (Object[])new Object[0]);
                boolean isAllAnd = true;
                filterNests = filter.getNests(true);
                for (QFilter.QFilterNest nest : filterNests) {
                    if (nest.isAnd()) continue;
                    isAllAnd = false;
                    break;
                }
                if (!isAllAnd) {
                    rtn.put("errMsg", "not all and");
                    return rtn;
                }
            } else {
                filterNests = Collections.emptyList();
            }
            LinkedHashMap<String, QFilter> filterMap = new LinkedHashMap<String, QFilter>(filterNests.size() + 1);
            if (filter != null) {
                filterMap.put(filter.getProperty(), new QFilter(filter.getProperty(), filter.getCP(), filter.getValue()));
            }
            boolean dupFilterKey = false;
            for (QFilter.QFilterNest nest : filterNests) {
                QFilter nestFilter = nest.getFilter();
                if (!filterMap.containsKey(nestFilter.getProperty())) {
                    filterMap.put(nestFilter.getProperty(), new QFilter(nestFilter.getProperty(), nestFilter.getCP(), nestFilter.getValue()));
                    continue;
                }
                dupFilterKey = true;
                break;
            }
            if (dupFilterKey) {
                rtn.put("errMsg", "dupFilterKey");
                return rtn;
            }
            QFilter newRootFilter = null;
            int len = ruleList.size();
            block7: for (int i = 0; i < len; ++i) {
                JSONArray itemList = ruleList.getJSONArray(i);
                int lenj = itemList.size();
                for (int j = 0; j < lenj; ++j) {
                    QFilter qFilter;
                    JSONObject item = itemList.getJSONObject(j);
                    String type = item.getString("type");
                    if ("view".equals(type) && newRootFilter == null) {
                        String tmpFields;
                        String defFilter = item.getString("filter");
                        if (StringUtils.isNotEmpty((String)defFilter)) {
                            try {
                                newRootFilter = QFilter.of((String)defFilter, (Object[])new Object[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!StringUtils.isNotEmpty((String)(tmpFields = item.getString("fields")))) continue;
                        rtn.put("fields", tmpFields);
                        fields = tmpFields;
                        continue;
                    }
                    String field = item.getString("field");
                    if (groupBySet.contains(field) || fields.contains(field)) continue block7;
                    String cp = item.getString("cp");
                    String value = item.getString("value");
                    if (StringUtils.isEmpty((String)cp)) {
                        cp = "=";
                    }
                    if ((qFilter = (QFilter)filterMap.get(field)) != null) continue block7;
                    qFilter = new QFilter(field, cp, (Object)value);
                    filterMap.put(field, qFilter);
                }
            }
            for (Map.Entry entry : filterMap.entrySet()) {
                if (newRootFilter == null) {
                    newRootFilter = (QFilter)entry.getValue();
                    continue;
                }
                newRootFilter.and((QFilter)entry.getValue());
            }
            if (newRootFilter == null) {
                rtn.put("filter", "");
            } else {
                String newFilterStr = new ConvertQFilterToAlgo(newRootFilter).tryConvertToAlgoExpression();
                rtn.put("filter", newFilterStr);
            }
        }
        catch (Exception ex) {
            log.info("error", (Object)ex);
        }
        return rtn;
    }

    private String covertDBResult(Map<String, String> map) {
        String filedData = map.get("dbResult");
        JSONObject dataObj = JSONObject.parseObject((String)filedData);
        Set keys = dataObj.keySet();
        JSONArray values = new JSONArray();
        if (keys.contains("fieldNames") && keys.contains("values")) {
            JSONArray items = this.covertDbItem(dataObj.getJSONArray("fieldNames"), dataObj.getJSONArray("values"));
            values.addAll((Collection)items);
        } else {
            for (String key : keys) {
                JSONObject keyJo = dataObj.getJSONObject(key);
                JSONArray items = this.covertDbItem(keyJo.getJSONArray("fieldNames"), keyJo.getJSONArray("values"));
                values.addAll((Collection)items);
            }
        }
        return values.toJSONString();
    }

    private JSONArray covertDbItem(JSONArray fieldNames, JSONArray valuesArray) {
        JSONArray values = new JSONArray();
        if (fieldNames == null || valuesArray == null) {
            return values;
        }
        for (int i = 0; i < valuesArray.size(); ++i) {
            JSONArray rowArray = valuesArray.getJSONArray(i);
            HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
            int len = Math.min(fieldNames.size(), rowArray.size());
            for (int j = 0; j < len; ++j) {
                rowMap.put(fieldNames.getString(j), rowArray.get(j));
            }
            values.add(rowMap);
        }
        return values;
    }

    private String printDBResult(Map<String, String> map) {
        String filedData = map.get("dbResult");
        JSONObject dataObj = JSONObject.parseObject((String)filedData);
        Set keys = dataObj.keySet();
        StringBuilder sb = new StringBuilder();
        if (keys.contains("fieldNames") && keys.contains("values")) {
            this.printDbItem(sb, "", dataObj.getJSONArray("fieldNames"), dataObj.getJSONArray("values"), null);
        } else {
            Map<String, String> fieldDesc = this.queryFieldDesc(keys);
            for (String key : keys) {
                JSONObject keyJo = dataObj.getJSONObject(key);
                this.printDbItem(sb, key, keyJo.getJSONArray("fieldNames"), keyJo.getJSONArray("values"), fieldDesc);
            }
        }
        return sb.toString();
    }

    private void printDbItem(StringBuilder printBuilder, String entity, JSONArray fieldNames, JSONArray valuesArray, Map<String, String> fieldDesc) {
        if (fieldNames == null || valuesArray == null) {
            return;
        }
        for (int i = 0; i < valuesArray.size(); ++i) {
            JSONArray rowArray = valuesArray.getJSONArray(i);
            int len = Math.min(fieldNames.size(), rowArray.size());
            for (int j = 0; j < len; ++j) {
                String field = fieldNames.getString(j);
                if (StringUtils.isNotEmpty((String)entity) && fieldDesc != null && !fieldDesc.isEmpty()) {
                    String fieldName = fieldDesc.getOrDefault(entity + "." + field, "");
                    field = fieldName + "(" + field + ")";
                }
                printBuilder.append(field).append(":").append(rowArray.get(j)).append("\n");
            }
        }
    }

    private Map<String, String> queryFieldDesc(Set<String> keys) {
        JSONObject textJo = new JSONObject();
        for (String key : keys) {
            String businessStr = this.getConfigData(key);
            if (StringUtils.isEmpty((String)businessStr)) continue;
            textJo.put(key, JSONArray.parse((String)businessStr));
        }
        String text = textJo.toJSONString();
        Map resultMap = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, List<Map<String, Object>>>>(){}, (Feature[])new Feature[0]);
        HashMap<String, String> maps = new HashMap<String, String>();
        for (Map.Entry entry : resultMap.entrySet()) {
            for (Map subscrib : (List)entry.getValue()) {
                String name = String.valueOf(subscrib.get("name"));
                String desc = String.valueOf(subscrib.get("desc"));
                name = (String)entry.getKey() + "." + name;
                maps.put(name, desc);
            }
        }
        return maps;
    }

    private Map<String, String> buildData(String key, String data) {
        HashMap<String, String> rtn = new HashMap<String, String>(1);
        rtn.put(key, data);
        return rtn;
    }
}

