/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.wf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;

public class WorkFlowApprovalRecordsAction
implements IGPTAction {
    private static Log logger = LogFactory.getLog(WorkFlowApprovalRecordsAction.class);
    private static final String PARAM_ENTITY_NUMBER = "entityNumber";
    private static final String PARAM_BUSINESS_KEY = "ids";
    private static final String PARAM_NUMBER_KEY = "billnos";
    private static final String PARAM_ALL_RECORDS = "allRecords";
    private static final String RESULT_WORK_FLOW_APPROVAL_RECORDS = "workFlowApprovalRecords";
    private static final String RESULT_WORK_FLOW_MARKDOWN_ALL = "workFlowApprovalRecordsMarkdownAll";
    private static final String RESULT_WORK_FLOW_MARKDOWN_MAP = "workFlowApprovalRecordsMarkdownMap";
    private static final String RESULT_WORK_FLOW_NOt_EXIT = "workFlowProcessNotExit";
    private static final String RESULT_WORK_FLOW_BILLNO_MAP = "workFlowProcessBillnoMap";
    private static final String node_submit = "submit";
    private static final String node_wait = "wait";
    private static final String node_reject = "reject";
    private static final String node_approve = "approve";

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        if (params == null) {
            logger.warn("\u3010WorkFlowApprovalRecordsAction\u3011Input parameters are null");
            return Collections.emptyMap();
        }
        String entityNumber = params.get(PARAM_ENTITY_NUMBER);
        String businessKey = params.get(PARAM_BUSINESS_KEY);
        String billnos = params.get(PARAM_NUMBER_KEY);
        boolean allRecords = Boolean.parseBoolean(params.get(PARAM_ALL_RECORDS));
        List workFlowResult = Collections.emptyList();
        if (StringUtils.isNotEmpty((CharSequence)businessKey)) {
            logger.info("\u3010WorkFlowApprovalRecordsAction\u3011Input allRecords:{},parameters:{}", (Object)allRecords, (Object)JsonUtil.toJson(params));
            TypeReference<List<String>> typeRef = new TypeReference<List<String>>(){};
            List idList = (List)JSON.parseObject((String)businessKey, (TypeReference)typeRef, (Feature[])new Feature[0]);
            List numberList = (List)JSON.parseObject((String)billnos, (TypeReference)typeRef, (Feature[])new Feature[0]);
            if (idList != null && !idList.isEmpty()) {
                workFlowResult = new ArrayList(idList.size());
                HashMap<String, String> markdownMap = new HashMap<String, String>(idList.size());
                StringBuilder markdownALL = new StringBuilder();
                ArrayList<String> notExitbillnos = new ArrayList<String>(idList.size());
                ArrayList billnoMaps = new ArrayList(idList.size());
                for (int i = 0; i < idList.size(); ++i) {
                    String id = (String)idList.get(i);
                    String billno = (String)numberList.get(i);
                    List approvalRecords = WorkflowServiceHelper.getApprovalRecords((String)entityNumber, (String)id, (boolean)allRecords);
                    if (approvalRecords == null || approvalRecords.isEmpty()) {
                        logger.warn("\u3010WorkFlowApprovalRecordsAction\u3011approvalRecords is null");
                        notExitbillnos.add(billno);
                        continue;
                    }
                    String md = this.toMD(billno, approvalRecords);
                    workFlowResult.add(approvalRecords);
                    markdownALL.append(md);
                    markdownMap.put(billno, md);
                    HashMap<String, String> obj = new HashMap<String, String>(1);
                    obj.put(billno, id);
                    billnoMaps.add(obj);
                }
                params.put(RESULT_WORK_FLOW_MARKDOWN_ALL, markdownALL.toString());
                params.put(RESULT_WORK_FLOW_MARKDOWN_MAP, JsonUtil.toJson(markdownMap));
                params.put(RESULT_WORK_FLOW_NOt_EXIT, JsonUtil.toJson(notExitbillnos));
                params.put(RESULT_WORK_FLOW_BILLNO_MAP, JsonUtil.toJson(billnoMaps));
            }
        } else {
            logger.info("\u3010WorkFlowApprovalRecordsAction\u3011ids is Empty");
        }
        params.put(RESULT_WORK_FLOW_APPROVAL_RECORDS, JsonUtil.toJson(workFlowResult));
        logger.info("\u3010WorkFlowApprovalRecordsAction\u3011response params :{}", (Object)JsonUtil.toJson(params));
        return params;
    }

    private String toMD(String billno, List<IApprovalRecordGroup> approvalRecords) {
        StringBuilder markdown = new StringBuilder();
        markdown.append(ResManager.loadKDString((String)"\u5355\u636e[", (String)"WorkFlowApprovalRecordsAction_3", (String)"ai-gai-core", (Object[])new Object[0])).append(billno).append(ResManager.loadKDString((String)"]\u7684\u6d41\u7a0b\u56fe\uff1a", (String)"WorkFlowApprovalRecordsAction_4", (String)"ai-gai-core", (Object[])new Object[0])).append("\n");
        markdown.append("```mermaid\n");
        LinkedHashSet<String> mermaidLines = new LinkedHashSet<String>(approvalRecords.size());
        LinkedHashSet<String> nodeInfos = new LinkedHashSet<String>(approvalRecords.size());
        LinkedHashSet<String> nodeStatuss = new LinkedHashSet<String>(approvalRecords.size());
        String startNodeId = "start";
        String endNodeId = "end";
        StringBuilder mermaidDefinition = new StringBuilder();
        mermaidDefinition.append("graph TD\n");
        mermaidDefinition.append("classDef submit fill:#d4edda,stroke:#4caf50,stroke-width:2px,color:#000,rx:10px,ry:10px\n");
        mermaidDefinition.append("classDef wait fill:#eeeeee,stroke:#9e9e9e,stroke-width:1px,color:#666,rx:10px,ry:10px\n");
        mermaidDefinition.append("classDef reject fill:#fffde7,stroke:#4caf50,stroke-width:2px,color:#000,rx:10px,ry:10px\n");
        mermaidDefinition.append("classDef done fill:#d4edda,stroke:#4caf50,stroke-width:2px,color:#000,rx:10px,ry:10px\n");
        mermaidDefinition.append("classDef approve fill:#d4edda,stroke:#4caf50,stroke-width:2px,color:#000,rx:10px,ry:10px\n\n\n");
        nodeInfos.add(String.format("%s[%s]\n", startNodeId, ResManager.loadKDString((String)"\u5f00\u59cb", (String)"WorkFlowApprovalRecordsAction_1", (String)"ai-gai-core", (Object[])new Object[0])));
        nodeInfos.add(String.format("%s[%s]\n", endNodeId, ResManager.loadKDString((String)"\u7ed3\u675f", (String)"WorkFlowApprovalRecordsAction_2", (String)"ai-gai-core", (Object[])new Object[0])));
        String previousNode = startNodeId;
        for (int i = 0; i < approvalRecords.size(); ++i) {
            IApprovalRecordGroup group = approvalRecords.get(i);
            String nodeId = group.getGroup();
            String nodeStatus = group.getGroupDecisionType();
            for (IApprovalRecordItem child : group.getChildren()) {
                String currenNodeId = child.getActivityId();
                String assigeeHeader = ResManager.loadKDString((String)"<br>\u5ba1\u6279\u4eba:", (String)"WorkFlowApprovalRecordsAction_0", (String)"ai-gai-core", (Object[])new Object[0]);
                String message = child.getMessage();
                String assigeeMsg = "";
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    assigeeMsg = String.format("%s%s", ResManager.loadKDString((String)"<br>\u5ba1\u6279\u5efa\u8bae:", (String)"WorkFlowApprovalRecordsAction_0", (String)"ai-gai-core", (Object[])new Object[0]), this.escape(message));
                }
                nodeInfos.add(String.format("%s[%s %s%s %s]", currenNodeId, this.escape(child.getActivityName()), assigeeHeader, this.escape(child.getAssignee()), assigeeMsg));
                String lineRemark = child.getResult();
                String mermaidLine2 = previousNode + " --> |" + this.escape(lineRemark) + "|" + currenNodeId + "\n";
                mermaidLines.add(mermaidLine2);
                previousNode = currenNodeId;
            }
            nodeStatuss.add(String.format("class %s %s\n", nodeId, nodeStatus));
        }
        IApprovalRecordGroup lastNode = approvalRecords.get(approvalRecords.size() - 1);
        boolean done = node_approve.equals(lastNode.getGroupDecisionType());
        if (done) {
            mermaidDefinition.append(previousNode).append(" --> ").append(endNodeId).append("\n");
            nodeStatuss.add(String.format("class %s %s\n", endNodeId, node_approve));
        }
        nodeInfos.forEach(nodeInfo -> mermaidDefinition.append((String)nodeInfo).append("\n"));
        mermaidDefinition.append("\n");
        mermaidLines.forEach(mermaidLine -> mermaidDefinition.append((String)mermaidLine).append("\n"));
        mermaidDefinition.append("\n");
        nodeStatuss.forEach(nodeStatusInfo -> mermaidDefinition.append((String)nodeStatusInfo).append("\n"));
        markdown.append((CharSequence)mermaidDefinition);
        markdown.append("```\n\n\n");
        return markdown.toString();
    }

    private String escape(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        return text.replace("\"", "\\\"").replace("\n", " ").replace("|", "-");
    }
}

