/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.wf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class WorkFlowAssigneeInfoAction
implements IGPTAction {
    private static Log logger = LogFactory.getLog(WorkFlowAssigneeInfoAction.class);
    private static final String PARAM_ASSIGNEE_IDS = "assignees";
    private static final String RESULT_ASSIGNEE_INFO = "assigneeInfos";
    private static final String RESULT_ASSIGNEE_MD = "assigneeInfoMD";
    private static final String ENTITY_NUMBER = "bos_user";

    public Map<String, String> invokeAction(String s, Map<String, String> params) {
        MainEntityType dataEntityType;
        TypeReference<List<String>> typeRef;
        if (params == null) {
            logger.warn("\u3010WorkFlowAssigneeInfoAction\u3011Input parameters are null");
            return Collections.emptyMap();
        }
        String idstr = params.get(PARAM_ASSIGNEE_IDS);
        List idList = (List)JSON.parseObject((String)idstr, (TypeReference)(typeRef = new TypeReference<List<String>>(){}), (Feature[])new Feature[0]);
        Object[] ids = WorkFlowAssigneeInfoAction.conversionIds(idList, ENTITY_NUMBER);
        DynamicObject[] assigeeInfos = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)(dataEntityType = MetadataServiceHelper.getDataEntityType((String)ENTITY_NUMBER)));
        if (assigeeInfos != null && assigeeInfos.length > 0) {
            ArrayList<Map<String, Object>> userInfos = new ArrayList<Map<String, Object>>(assigeeInfos.length);
            for (DynamicObject assigeeInfo : assigeeInfos) {
                HashMap<String, Object> userInfo = new HashMap<String, Object>(4);
                Object name = assigeeInfo.get("name");
                Object number = assigeeInfo.get("number");
                Object phone = assigeeInfo.get("phone");
                Object email = assigeeInfo.get("email");
                userInfo.put("name", name);
                userInfo.put("number", number);
                userInfo.put("phone", phone);
                userInfo.put("email", email);
                userInfos.add(userInfo);
            }
            params.put(RESULT_ASSIGNEE_INFO, JSON.toJSONString(userInfos));
            params.put(RESULT_ASSIGNEE_MD, JSON.toJSONString((Object)this.toMd(userInfos)));
        }
        return params;
    }

    private String toMd(List<Map<String, Object>> userInfos) {
        if (userInfos != null && !userInfos.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("|\u59d3\u540d|\u5de5\u53f7|\u624b\u673a\u53f7|\u90ae\u7bb1|\n");
            sb.append("|---|---|---|---|\n");
            for (Map<String, Object> userInfo : userInfos) {
                sb.append("|").append(userInfo.get("name")).append("|");
                sb.append(userInfo.get("number")).append("|");
                sb.append(userInfo.get("phone")).append("|");
                sb.append(userInfo.get("email")).append("|\n");
            }
            return sb.toString();
        }
        return "";
    }

    private static Object[] conversionIds(List<String> idList, String bizBill) {
        if (idList == null || idList.isEmpty()) {
            throw new KDBizException(Errors.billOperateError(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillOperateNodeApplication_5", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
        }
        BillEntityType dataEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)bizBill);
        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
        try {
            if (primaryKey instanceof LongProp) {
                return idList.stream().map(Long::parseLong).toArray();
            }
            if (primaryKey instanceof VarcharProp) {
                return idList.stream().map(String::valueOf).toArray();
            }
        }
        catch (Exception ex) {
            ErrorCode errorCode = Errors.billIdConvertionError(String.format(ResManager.loadKDString((String)"\u6570\u636e\uff1a%s,\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"BillOperateNodeApplication_6", (String)"ai-gai-core", (Object[])new Object[0]), JsonUtil.toJson(idList), ex.getMessage()));
            logger.error("bill operate conversion ids error :{}", (Object)JsonUtil.toJson(errorCode), (Object)ex);
            throw new KDBizException(errorCode, new Object[0]);
        }
        return null;
    }
}

