/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.wf;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcessModel;

public class WorkFlowDescAction
implements IGPTAction {
    private static Log logger = LogFactory.getLog(WorkFlowDescAction.class);
    private static final String PARAM_ENTITYNUMBER = "entityNumber";
    private static final String RESULT_WORK_FLOW_DESC = "workFlowDesc";
    private static final String RESULT_WORK_FLOW_DESC_MD = "workFlowDescMD";
    private static final LinkedHashMap<String, String> headers = new LinkedHashMap(13);

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        if (params == null) {
            logger.warn("\u3010WorkFlowDescAction\u3011Input parameters are null");
            return Collections.emptyMap();
        }
        String entityNumber = params.get(PARAM_ENTITYNUMBER);
        List processModels = WorkflowServiceHelper.getProcessesByEntityNumber((String)entityNumber);
        if (processModels == null || processModels.isEmpty()) {
            logger.warn("\u3010WorkFlowDescAction\u3011processModels is empty");
            return Collections.emptyMap();
        }
        StringBuilder markdownTable = new StringBuilder();
        markdownTable.append("| ").append(String.join((CharSequence)" | ", headers.values())).append(" |\n");
        markdownTable.append("|");
        for (int i = 0; i < headers.size(); ++i) {
            markdownTable.append(" - |");
        }
        markdownTable.append("\n");
        for (ProcessModel model : processModels) {
            markdownTable.append("| ");
            for (String key : headers.keySet()) {
                try {
                    markdownTable.append(ProcessModel.class.getMethod("get" + WorkFlowDescAction.capitalize(key), new Class[0]).invoke((Object)model, new Object[0]));
                }
                catch (Exception e) {
                    markdownTable.append(" ");
                }
                markdownTable.append(" | ");
            }
            markdownTable.append("\n");
        }
        params.put(RESULT_WORK_FLOW_DESC, JsonUtil.toJson(processModels));
        params.put(RESULT_WORK_FLOW_DESC_MD, markdownTable.toString());
        logger.info("\u3010WorkFlowDescAction\u3011response params :{}", (Object)JsonUtil.toJson(params));
        return params;
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    static {
        headers.put("number", "\u6d41\u7a0b\u7f16\u7801");
        headers.put("name", "\u6d41\u7a0b\u540d\u79f0");
        headers.put("description", "\u6d41\u7a0b\u63cf\u8ff0");
        headers.put(PARAM_ENTITYNUMBER, "\u6d41\u7a0b\u7684\u5b9e\u4f53\u7f16\u7801");
        headers.put("type", "\u6d41\u7a0b\u7c7b\u578b");
        headers.put("operation", "\u6d41\u7a0b\u89e6\u53d1\u64cd\u4f5c");
        headers.put("id", "\u6d41\u7a0b\u6a21\u578bID");
        headers.put("cloudId", "\u6d41\u7a0b\u6240\u5c5e\u7684\u4e91ID");
        headers.put("appId", "\u6d41\u7a0b\u6240\u5c5e\u7684\u5e94\u7528ID");
        headers.put("entityId", "\u6d41\u7a0b\u7684\u5b9e\u4f53ID");
        headers.put("businessId", "\u6d41\u7a0b\u6807\u8bc6");
        headers.put("orgId", "\u6d41\u7a0b\u6240\u5c5e\u7ec4\u7ec7");
        headers.put("data", "\u6d41\u7a0b\u6570\u636e(JSON\u683c\u5f0f)");
    }
}

