/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.sys.action.wf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class WorkFlowProcessWindowRecordsAction
implements IGPTAction {
    private static Log logger = LogFactory.getLog(WorkFlowProcessWindowRecordsAction.class);
    private static final String PARAM_BUSINESS_KEY = "ids";
    private static final String PARAM_BILLNOS_KEY = "billnos";
    private static final String RESULT_WORK_FLOW = "workFlowProcessWindowRecordsResult";
    private static final String RESULT_WORK_FLOW_MARKDOWN_ALL = "workFlowProcessMarkdownAll";
    private static final String RESULT_WORK_FLOW_MARKDOWN_MAP = "workFlowProcessMarkdownMap";
    private static final String RESULT_WORK_FLOW_NOt_EXIT = "workFlowProcessNotExit";
    private static final String RESULT_WORK_FLOW_BILLNO_MAP = "workFlowProcessBillnoMap";
    private static final String NODE_STATUS_RUNNING = "running";
    private static final String NODE_STATUS_APPROVE = "approve";
    private static final String NODE_STATUS_REJECT = "reject";
    private static final String NODE_STATUS_WAIT = "wait";

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        Map<String, List> result;
        if (params == null) {
            logger.warn("\u3010WorkFlowProcessWindowRecordsAction\u3011Input parameters are null");
            return Collections.emptyMap();
        }
        String businessKey = params.get(PARAM_BUSINESS_KEY);
        String billnosKey = params.get(PARAM_BILLNOS_KEY);
        Map<String, String> markdownMap = Collections.emptyMap();
        ArrayList<String> notExitbillnos = null;
        ArrayList billnoMaps = null;
        StringBuilder markdownALL = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)businessKey)) {
            logger.info("\u3010WorkFlowProcessWindowRecordsAction\u3011Input parameters:{}", (Object)JsonUtil.toJson(params));
            TypeReference<List<String>> typeRef = new TypeReference<List<String>>(){};
            List idList = (List)JSON.parseObject((String)businessKey, (TypeReference)typeRef, (Feature[])new Feature[0]);
            List billnos = (List)JSON.parseObject((String)billnosKey, (TypeReference)typeRef, (Feature[])new Feature[0]);
            if (idList != null && !idList.isEmpty() && billnos != null && !billnos.isEmpty()) {
                billnoMaps = new ArrayList(idList.size());
                result = new HashMap(idList.size());
                markdownMap = new HashMap(idList.size());
                notExitbillnos = new ArrayList<String>(idList.size());
                for (int i = 0; i < idList.size(); ++i) {
                    String id = (String)idList.get(i);
                    String billno = (String)billnos.get(i);
                    List processWindowRecords = WorkflowServiceHelper.getProcessWindowRecords((String)id);
                    if (processWindowRecords == null || processWindowRecords.isEmpty()) {
                        logger.warn("\u3010WorkFlowProcessWindowRecordsAction\u3011participants is null");
                        notExitbillnos.add(billno);
                        continue;
                    }
                    result.put(billno, processWindowRecords);
                    HashMap<String, String> billObj = new HashMap<String, String>(1);
                    billObj.put(billno, id);
                    billnoMaps.add(billObj);
                    String md = this.toMD(billno, processWindowRecords);
                    markdownALL.append(md);
                    markdownMap.put(billno, md);
                }
                if (markdownMap.size() != idList.size()) {
                    logger.warn("\u3010WorkFlowProcessWindowRecordsAction\u3011markdownMap size is not equals idList size");
                }
            } else {
                logger.error("\u3010WorkFlowProcessWindowRecordsAction\u3011id List or billno list is Empty");
                result = Collections.emptyMap();
            }
        } else {
            logger.info("\u3010WorkFlowProcessWindowRecordsAction\u3011bizId is Empty");
            result = Collections.emptyMap();
        }
        params.put(RESULT_WORK_FLOW, JsonUtil.toJson(result));
        params.put(RESULT_WORK_FLOW_MARKDOWN_MAP, JsonUtil.toJson(markdownMap));
        params.put(RESULT_WORK_FLOW_MARKDOWN_ALL, markdownALL.toString());
        params.put(RESULT_WORK_FLOW_NOt_EXIT, JsonUtil.toJson(notExitbillnos));
        params.put(RESULT_WORK_FLOW_BILLNO_MAP, JsonUtil.toJson(billnoMaps));
        logger.info("\u3010WorkFlowProcessWindowRecordsAction\u3011response params :{}", (Object)JsonUtil.toJson(params));
        return params;
    }

    private String toMD(String billno, List<Map<String, Object>> processWindowRecords) {
        StringBuilder markdown = new StringBuilder();
        markdown.append(ResManager.loadKDString((String)"\u5355\u636e[", (String)"WorkFlowApprovalRecordsAction_3", (String)"ai-gai-core", (Object[])new Object[0])).append(billno).append(ResManager.loadKDString((String)"]\u7684\u6d41\u7a0b\u56fe\uff1a", (String)"WorkFlowApprovalRecordsAction_4", (String)"ai-gai-core", (Object[])new Object[0])).append("\n");
        markdown.append("```mermaid\n");
        StringBuilder mermaidDefinition = new StringBuilder("graph TD\n");
        mermaidDefinition.append("classDef running fill:#e3f2fd,stroke:#2196f3,stroke-width:2px,color:#000,rx:10px,ry:10px\n");
        mermaidDefinition.append("classDef wait fill:#eeeeee,stroke:#9e9e9e,stroke-width:1px,color:#666,rx:10px,ry:10px\n");
        mermaidDefinition.append("classDef reject fill:#fffde7,stroke:#4caf50,stroke-width:2px,color:#000,rx:10px,ry:10px\n");
        mermaidDefinition.append("classDef approve fill:#d4edda,stroke:#4caf50,stroke-width:2px,color:#000,rx:10px,ry:10px\n\n\n");
        LinkedHashSet<String> mermaidLines = new LinkedHashSet<String>();
        LinkedHashSet<String> nodeInfos = new LinkedHashSet<String>();
        LinkedHashSet<String> nodeStatuss = new LinkedHashSet<String>();
        int processSize = processWindowRecords.size();
        Map<String, Object> startNode = processWindowRecords.get(0);
        WorkFlowProcessWindowRecordsAction.buildMermaid(startNode, nodeInfos, true, nodeStatuss, mermaidLines);
        boolean preRunNodeStatus = true;
        if (processSize > 2) {
            for (int j = 1; j < processSize - 1; ++j) {
                Map<String, Object> node = processWindowRecords.get(j);
                preRunNodeStatus = WorkFlowProcessWindowRecordsAction.buildMermaid(node, nodeInfos, preRunNodeStatus, nodeStatuss, mermaidLines);
            }
        }
        Map<String, Object> endNode = processWindowRecords.get(processSize - 1);
        WorkFlowProcessWindowRecordsAction.buildMermaid(endNode, nodeInfos, preRunNodeStatus, nodeStatuss, mermaidLines);
        nodeInfos.forEach(nodeInfo -> mermaidDefinition.append((String)nodeInfo).append("\n"));
        mermaidDefinition.append("\n");
        mermaidLines.forEach(mermaidLine -> mermaidDefinition.append((String)mermaidLine).append("\n"));
        mermaidDefinition.append("\n");
        nodeStatuss.forEach(nodeStatusInfo -> mermaidDefinition.append((String)nodeStatusInfo).append("\n"));
        markdown.append((CharSequence)mermaidDefinition).append("```").append("\n\n\n");
        return markdown.toString();
    }

    private static boolean buildMermaid(Map<String, Object> node, Set<String> nodeInfos, boolean preRunNodeStatus, Set<String> nodeStatuss, Set<String> mermaidLines) {
        List nextNode;
        String nodeStatus;
        Object nodeId = node.get("nodeId");
        Object nodeName = node.get("nodeName");
        boolean executed = (Boolean)node.get("executed");
        Object assignee = node.get("assignee");
        String assigneeName = (String)node.get("assigneeName");
        if (assignee == null) {
            assigneeName = "";
        } else if (assignee instanceof List) {
            List assigneeList = (List)assignee;
            assigneeName = assigneeList.size() <= 0 ? "" : assigneeName;
        }
        String remark = "";
        if (preRunNodeStatus) {
            if (executed) {
                nodeStatus = NODE_STATUS_APPROVE;
            } else {
                nodeStatus = NODE_STATUS_RUNNING;
                assigneeName = assigneeName.replaceAll(ResManager.loadKDString((String)"\u9884\u4f30\u7684\u53c2\u4e0e\u4eba:", (String)"WorkFlowProcessWindowRecordsAction_0", (String)"ai-gai-core", (Object[])new Object[0]), "\u53c2\u4e0e\u4eba:");
                remark = ResManager.loadKDString((String)"<br>\u5904\u7406\u4e2d", (String)"WorkFlowProcessWindowRecordsAction_1", (String)"ai-gai-core", (Object[])new Object[0]);
            }
        } else {
            nodeStatus = NODE_STATUS_WAIT;
        }
        nodeInfos.add(String.format("%s[%s %s%s]", nodeId, nodeName, assigneeName, remark));
        nodeStatuss.add(String.format("class %s %s", nodeId, nodeStatus));
        Object nextNodeObj = node.get("nextNode");
        preRunNodeStatus = executed;
        if (nextNodeObj instanceof List && !(nextNode = (List)nextNodeObj).isEmpty()) {
            StringBuilder mermaidLine = new StringBuilder();
            for (Object nextNodeId : nextNode) {
                mermaidLine.append(nodeId).append(" --> ").append(nextNodeId).append("\n");
                mermaidLines.add(mermaidLine.toString());
            }
        }
        return preRunNodeStatus;
    }
}

