/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.enuz;

import kd.ai.gai.core.enuz.LLM;

public enum EmbeddingModel {
    AZURE_EMBEDDING_ADA_002_SINGLE(LLM.AZURE_EMBEDDING_ADA_002, 1, false),
    BAIDU_EMBEDDING_V1_BATCH(LLM.BAIDU_EMBEDDING_V1, 10, true),
    AZURE_EMBEDDING_ADA_002_NEW_BATCH(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 20, true),
    KINGDEE_EMBEDDING_BATCH(LLM.KINGDEE_EMBEDDING, 4, true),
    BAIDU_EMBEDDING_BGE_LARGE_ZH_BATCH(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 10, true),
    BAIDU_EMBEDDING_TAO_8K_BATCH(LLM.BAIDU_EMBEDDING_TAO_8K, 1, false),
    KINGDEE_NEW_EMBEDDING_BATCH(LLM.KINGDEE_EMBEDDING_NEW, 10, true),
    DOUBAO_EMBEDDING_BATCH(LLM.DOUBAO_EMBEDDING, 4, true),
    DOUBAO_EMBEDDING_LARGE_BATCH(LLM.DOUBAO_EMBEDDING_LARGE, 4, true),
    SHENGTENG_EMBEDDING_BATCH(LLM.SHENGTENG_EMBEDDING, 10, true);

    LLM llm;
    int batchSize;
    boolean batch;

    private EmbeddingModel(LLM llm, int batchSize, boolean batch) {
        this.llm = llm;
        this.batchSize = batchSize;
        this.batch = batch;
    }

    public LLM getLlm() {
        return this.llm;
    }

    public void setLlm(LLM llm) {
        this.llm = llm;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public static EmbeddingModel parse(LLM llm) {
        for (EmbeddingModel embedding : EmbeddingModel.values()) {
            if (embedding.llm != llm) continue;
            return embedding;
        }
        return null;
    }
}

