/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.enuz.repo;

import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.repo.RepoChunkStrategy;

public enum RepoChunkEmbeddingRule {
    AZURE_002_BASE_SPLIT(LLM.AZURE_EMBEDDING_ADA_002, 1, 400, RepoChunkStrategy.BASE_FIXED_LENGTH),
    AZURE_002NEW_BASE_SPLIT(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 1, 400, RepoChunkStrategy.BASE_FIXED_LENGTH),
    BAIDU_BASE_SPLIT(LLM.BAIDU_EMBEDDING_V1, 1, 300, RepoChunkStrategy.BASE_FIXED_LENGTH),
    BAIDU_BGE_LARGE_ZH_BASE_SPLIT(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 1, 300, RepoChunkStrategy.BASE_FIXED_LENGTH),
    BAIDU_TAO_8K_BASE_SPLIT(LLM.BAIDU_EMBEDDING_TAO_8K, 1, 512, RepoChunkStrategy.BASE_FIXED_LENGTH),
    KINGDEE_BASE_SPLIT(LLM.KINGDEE_EMBEDDING, 1, 400, RepoChunkStrategy.BASE_FIXED_LENGTH),
    KINGDEE_NEW_BASE_SPLIT(LLM.KINGDEE_EMBEDDING_NEW, 1, 300, RepoChunkStrategy.BASE_FIXED_LENGTH),
    SHENGTENG_BASE_SPLIT(LLM.SHENGTENG_EMBEDDING, 1, 300, RepoChunkStrategy.BASE_FIXED_LENGTH),
    DOUBAO_EMBEDDING_BASE_SPLIT(LLM.DOUBAO_EMBEDDING, 1, 300, RepoChunkStrategy.BASE_FIXED_LENGTH),
    DOUBAO_EMBEDDING_LARGE_BASE_SPLIT(LLM.DOUBAO_EMBEDDING_LARGE, 1, 300, RepoChunkStrategy.BASE_FIXED_LENGTH),
    AZURE_002_CUSTOMIZE(LLM.AZURE_EMBEDDING_ADA_002, 1, 2000, RepoChunkStrategy.CUSTOMIZE),
    AZURE_002NEW_CUSTOMIZE(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 1, 2000, RepoChunkStrategy.CUSTOMIZE),
    BAIDU_CUSTOMIZE(LLM.BAIDU_EMBEDDING_V1, 1, 350, RepoChunkStrategy.CUSTOMIZE),
    BAIDU_BGE_LARGE_ZH_CUSTOMIZE(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 1, 512, RepoChunkStrategy.CUSTOMIZE),
    BAIDU_TAO_8K_CUSTOMIZE(LLM.BAIDU_EMBEDDING_TAO_8K, 1, 5000, RepoChunkStrategy.CUSTOMIZE),
    KINGDEE_CUSTOMIZE(LLM.KINGDEE_EMBEDDING, 1, 350, RepoChunkStrategy.CUSTOMIZE),
    KINGDEE_NEW_CUSTOMIZE(LLM.KINGDEE_EMBEDDING_NEW, 1, 350, RepoChunkStrategy.CUSTOMIZE),
    SHENGTENG_CUSTOMIZE(LLM.SHENGTENG_EMBEDDING, 1, 350, RepoChunkStrategy.CUSTOMIZE),
    DOUBAO_EMBEDDING_CUSTOMIZE(LLM.DOUBAO_EMBEDDING, 1, 300, RepoChunkStrategy.CUSTOMIZE),
    DOUBAO_EMBEDDING_LARGE_CUSTOMIZE(LLM.DOUBAO_EMBEDDING_LARGE, 1, 300, RepoChunkStrategy.CUSTOMIZE),
    AZURE_002_IDENTIFIER(LLM.AZURE_EMBEDDING_ADA_002, 50, 5000, RepoChunkStrategy.IDENTIFIER),
    AZURE_002NEW_IDENTIFIER(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 50, 5000, RepoChunkStrategy.IDENTIFIER),
    BAIDU_IDENTIFIER(LLM.BAIDU_EMBEDDING_V1, 50, 600, RepoChunkStrategy.IDENTIFIER),
    BAIDU_BGE_LARGE_ZH_IDENTIFIER(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 50, 800, RepoChunkStrategy.IDENTIFIER),
    BAIDU_TAO_8K_IDENTIFIER(LLM.BAIDU_EMBEDDING_TAO_8K, 50, 12000, RepoChunkStrategy.IDENTIFIER),
    KINGDEE_IDENTIFIER(LLM.KINGDEE_EMBEDDING, 50, 400, RepoChunkStrategy.IDENTIFIER),
    KINGDEE_NEW_IDENTIFIER(LLM.KINGDEE_EMBEDDING_NEW, 50, 600, RepoChunkStrategy.IDENTIFIER),
    DOUBAO_EMBEDDING_IDENTIFIER(LLM.DOUBAO_EMBEDDING, 50, 600, RepoChunkStrategy.IDENTIFIER),
    DOUBAO_EMBEDDING_LARGE_IDENTIFIER(LLM.DOUBAO_EMBEDDING_LARGE, 50, 600, RepoChunkStrategy.IDENTIFIER),
    SHENGTENG_IDENTIFIER(LLM.SHENGTENG_EMBEDDING, 50, 600, RepoChunkStrategy.IDENTIFIER);

    private LLM llm;
    private int minSize;
    private int maxSize;
    private RepoChunkStrategy chunkStrategy;
    public static final RepoChunkEmbeddingRule[] VALUE;

    private RepoChunkEmbeddingRule(LLM llm, int minSize, int maxSize, RepoChunkStrategy chunkStrategy) {
        this.llm = llm;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.chunkStrategy = chunkStrategy;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public RepoChunkStrategy getChunkStrategy() {
        return this.chunkStrategy;
    }

    public void setChunkStrategy(RepoChunkStrategy chunkStrategy) {
        this.chunkStrategy = chunkStrategy;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public LLM getLlm() {
        return this.llm;
    }

    public void setLlm(LLM llm) {
        this.llm = llm;
    }

    public static RepoChunkEmbeddingRule parse(LLM llm, RepoChunkStrategy type) {
        for (RepoChunkEmbeddingRule rule : RepoChunkEmbeddingRule.values()) {
            if (rule.llm != llm || rule.chunkStrategy != type) continue;
            return rule;
        }
        return null;
    }

    static {
        VALUE = RepoChunkEmbeddingRule.values();
    }
}

