/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.flow.func.ParentParamFinder;
import kd.ai.gai.core.flow.param.builder.ParamPathBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.MessageParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.flow.param.dimension.ParamVisibility;
import kd.ai.gai.core.flow.param.helper.ParamPathHelper;
import kd.ai.gai.core.flow.param.helper.ParamReferenceHelper;
import kd.bos.dataentity.entity.DynamicObject;
import org.apache.commons.lang3.StringUtils;

public class FlowConfigParamHelper {
    public static Optional<ParamDefinition> findParentParamDefinition(Flow flow, Action action, String nodeIdStr, String paramName) {
        int sourceNodeId = Integer.parseInt(nodeIdStr);
        if (flow.getStart().getId() == sourceNodeId) {
            Start start = flow.getStart();
            return start.getParamByName(paramName, ParamVisibility.PUBLIC, ParamVisibility.PRIVATE);
        }
        Action parentAction = flow.findActionById(sourceNodeId);
        if (action.getBlockNodeId() == sourceNodeId || action.getId() == sourceNodeId) {
            return parentAction.getParamByName(paramName, ParamVisibility.PUBLIC, ParamVisibility.PRIVATE);
        }
        return parentAction.getParamByName(paramName, ParamVisibility.PUBLIC);
    }

    public static ParamDefinition createCustomDefParam(DynamicObject row, ParamDirection direction, String name, String desc, String typeStr, boolean isConstant, String constantValue, String referenceParam) {
        String must;
        ParamDefinition paramDefinition;
        ParamType paramType = ParamType.convertStringToParamType(typeStr);
        switch (paramType) {
            case OBJECT: {
                paramDefinition = new ObjectParamDefinition(name);
                break;
            }
            case ARRAY: {
                ParamType itemType = ParamType.STRING;
                if (typeStr != null && typeStr.startsWith("Array<")) {
                    String elementTypeStr = typeStr.substring(6, typeStr.length() - 1);
                    itemType = ParamType.convertStringToParamType(elementTypeStr);
                }
                if (itemType == ParamType.OBJECT) {
                    paramDefinition = new ArrayParamDefinition(name, new ObjectParamDefinition("item"));
                    break;
                }
                paramDefinition = new ArrayParamDefinition(name, new BasicParamDefinition("item", itemType));
                break;
            }
            default: {
                MessageType messageType = MessageType.parse(typeStr);
                paramDefinition = messageType != null ? new MessageParamDefinition(name, messageType) : new BasicParamDefinition(name, paramType);
            }
        }
        if (direction != null) {
            paramDefinition.setDirection(direction);
            FlowConfigParamHelper.setVisibilityByDirection(paramDefinition, direction);
        }
        if (StringUtils.isNotBlank((CharSequence)referenceParam)) {
            NodeParamPath nodeParamPath = ParamPathHelper.parseFullPath(referenceParam);
            paramDefinition.setReferencePath(nodeParamPath);
            paramDefinition.setHeterogeneousReference(true);
        }
        paramDefinition.setDescription(desc);
        boolean containRow = row.getDynamicObjectType().getProperties().containsKey((Object)"must");
        if (containRow && StringUtils.isNotEmpty((CharSequence)(must = row.getString("must")))) {
            HashMap<String, String> mustProperties = new HashMap<String, String>(1);
            mustProperties.put("isMust", must);
            paramDefinition.setCustomProperties(mustProperties);
        }
        return paramDefinition;
    }

    public static ParamDefinition createReferenceParamDefinition(Flow flow, Action action, ParamDefinition originParamDefinition) {
        Optional<ParamDefinition> referenceParamDef = FlowConfigParamHelper.createReferenceParam(originParamDefinition, (nodeId, paramName) -> FlowConfigParamHelper.findParentParamDefinition(flow, action, nodeId, paramName));
        ParamDefinition paramDef = referenceParamDef.orElseThrow(() -> new RuntimeException(String.format("\u5f15\u7528\u578b\u53c2\u6570 %s \u6784\u5efa\u5931\u8d25", originParamDefinition.getName())));
        int referenceBlockNodeId = flow.getBlockNodeIdByActionId(paramDef.getReferencePath().getNodeIdAtInt());
        if (referenceBlockNodeId == action.getId()) {
            paramDef = FlowConfigParamHelper.wrapperArrayParamDefinition(paramDef);
        }
        if (originParamDefinition instanceof MessageParamDefinition) {
            paramDef = FlowConfigParamHelper.wrapperMessageParamDefinition(((MessageParamDefinition)originParamDefinition).getMessageType(), paramDef);
        }
        return paramDef;
    }

    public static ParamDefinition createReferenceParamDefinition(Flow flow, Action action, ParamDirection paramDirection, String name, String desc, String type, String referenceParamFullPath) {
        MessageType messageType;
        Optional<ParamDefinition> referenceParamDef = FlowConfigParamHelper.createReferenceParam(paramDirection, name, desc, type, referenceParamFullPath, (nodeId, paramName) -> FlowConfigParamHelper.findParentParamDefinition(flow, action, nodeId, paramName));
        NodeParamPath nodeParamPath = ParamPathHelper.parseFullPath(referenceParamFullPath);
        ParamDefinition paramDef = !nodeParamPath.getNodeId().equals(String.valueOf(action.getId())) ? referenceParamDef.orElseThrow(() -> new RuntimeException(String.format("\u5f15\u7528\u578b\u53c2\u6570 %s \u6784\u5efa\u5931\u8d25", name))) : referenceParamDef.orElseThrow(() -> new RuntimeException(String.format("\u53c2\u6570 %s \u5f15\u7528\u7684\u53c2\u6570 %s \u4e0d\u5b58\u5728\u3002", name, nodeParamPath.getOutputParamName())));
        int referenceBlockNodeId = flow.getBlockNodeIdByActionId(paramDef.getReferencePath().getNodeIdAtInt());
        if (referenceBlockNodeId == action.getId()) {
            paramDef = FlowConfigParamHelper.wrapperArrayParamDefinition(paramDef);
        }
        if ((messageType = MessageType.parse(type)) != null) {
            paramDef = FlowConfigParamHelper.wrapperMessageParamDefinition(messageType, paramDef);
        }
        return paramDef;
    }

    private static Optional<ParamDefinition> createReferenceParam(ParamDirection direction, String name, String desc, String typeStr, String referenceParam, ParentParamFinder paramFinder) {
        NodeParamPath nodeParamPath = ParamPathHelper.parseFullPath(referenceParam);
        Optional<ParamDefinition> referenceParamDefinition = FlowConfigParamHelper.createReferenceParam(name, nodeParamPath.getNodeId(), nodeParamPath.getOutputParamName(), nodeParamPath.getPropertyPathString(), paramFinder);
        return referenceParamDefinition.flatMap(paramDefinition -> FlowConfigParamHelper.wrapperParamDefinition(direction, desc, typeStr, null, paramDefinition));
    }

    private static Optional<ParamDefinition> createReferenceParam(ParamDefinition originParamDefinition, ParentParamFinder paramFinder) {
        NodeParamPath nodeParamPath = originParamDefinition.getReferencePath();
        Optional<ParamDefinition> referenceParamDefinition = FlowConfigParamHelper.createReferenceParam(originParamDefinition.getName(), nodeParamPath.getNodeId(), nodeParamPath.getOutputParamName(), nodeParamPath.getPropertyPathString(), paramFinder);
        return referenceParamDefinition.flatMap(paramDefinition -> FlowConfigParamHelper.wrapperParamDefinition(originParamDefinition.getDirection(), originParamDefinition.getDescription(), originParamDefinition.getType().toString(), originParamDefinition.getCustomProperties(), paramDefinition));
    }

    private static Optional<ParamDefinition> wrapperParamDefinition(ParamDirection direction, String desc, String typeStr, Map<String, String> customProperties, ParamDefinition referenceParamDefinition) {
        ParamDefinition paramDef = referenceParamDefinition;
        if (direction != null) {
            referenceParamDefinition.setDirection(direction);
            FlowConfigParamHelper.setVisibilityByDirection(paramDef, direction);
        }
        paramDef.setDescription(desc);
        paramDef.setCustomProperties(customProperties);
        return Optional.of(paramDef);
    }

    private static ParamDefinition wrapperMessageParamDefinition(MessageType messageType, ParamDefinition originParamDefinition) {
        return MessageParamDefinition.from(originParamDefinition, messageType);
    }

    public static ParamDefinition wrapperArrayParamDefinition(ParamDefinition originParamDefinition) {
        ArrayParamDefinition paramDefinition = new ArrayParamDefinition(originParamDefinition.getName(), originParamDefinition);
        if (originParamDefinition.isReference() && !originParamDefinition.isHeterogeneousReference()) {
            paramDefinition.setReferencePath(originParamDefinition.getReferencePath());
        }
        if (originParamDefinition.isConstant()) {
            paramDefinition.setConstantValue(originParamDefinition.getConstantValue());
        }
        ((ParamDefinition)paramDefinition).setDirection(originParamDefinition.getDirection());
        FlowConfigParamHelper.setVisibilityByDirection(paramDefinition, originParamDefinition.getDirection());
        return paramDefinition;
    }

    private static Optional<ParamDefinition> createReferenceParam(String name, String sourceNodeId, String sourceParamName, String sourceParamPath, ParentParamFinder paramFinder) {
        Optional<ParamDefinition> sourceParamDef = paramFinder.findParentParam(sourceNodeId, sourceParamName);
        return sourceParamDef.map(paramDefinition -> {
            NodeParamPath nodeParamPath = ParamPathBuilder.from(sourceNodeId, sourceParamName).build();
            List<String> propertyPath = ParamPathHelper.parsePropertyPath(sourceParamPath);
            nodeParamPath.setPropertyPath(propertyPath);
            return ParamReferenceHelper.resolveReference(name, paramDefinition, nodeParamPath);
        });
    }

    private static void setVisibilityByDirection(ParamDefinition paramDefinition, ParamDirection direction) {
        switch (direction) {
            case INPUT: {
                paramDefinition.setVisibility(ParamVisibility.PRIVATE);
                break;
            }
            case OUTPUT: 
            case BOTH: {
                paramDefinition.setVisibility(ParamVisibility.PUBLIC);
                break;
            }
        }
    }

    private static ParamDefinition buildItemParamDefinition(ParamType type) {
        switch (type) {
            case STRING: 
            case FLOAT: 
            case INTEGER: 
            case BOOLEAN: 
            case DATE: {
                return new BasicParamDefinition("item", type);
            }
            case OBJECT: {
                return new ObjectParamDefinition("item");
            }
        }
        return new BasicParamDefinition("item", ParamType.STRING);
    }
}

