/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.handler.MessageHandler;
import kd.ai.gai.core.engine.message.AskUserCallbackMessage;
import kd.ai.gai.core.engine.message.AskUserMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AskUserNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(AskUserNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private AskUserAction action;

    public AskUserNodeApplication(Context context, Flow gaiFlow, AskUserAction action) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        AskUserMessage message = this.buildAskUserMessage(this.context, this.gaiFlow, this.action, e);
        AskUserCallbackMessage callbackMessage = new AskUserCallbackMessage();
        callbackMessage.setChatSessionId(this.context.getChatSessionId());
        callbackMessage.setFlowId(message.getFlowId());
        callbackMessage.setNodeId(message.getNodeId());
        callbackMessage.setMessage(message);
        callbackMessage.setStartTs(start);
        FlowRuntime runtime = e.getRuntime();
        Map runtimeDoc = runtime.toJson();
        callbackMessage.setRuntimeDoc(runtimeDoc);
        FlowCacheData.putCache(this.context.getChatSessionId(), this.context.getChatSessionId() + "_ASK_USER", JSONObject.toJSONString((Object)callbackMessage));
        String userContent = MessageHandler.messageToHistory(message.getElementList());
        MessageConfig messageConfig = new MessageConfig();
        messageConfig.setAskUser(Boolean.TRUE);
        Message chatMessage = MessageService.insertMessage(this.context.getChatSessionId(), userContent, "", messageConfig.toString(), this.context.getCurrentSkill(), ChatMessageTypeEnum.PROCESS, this.context.messageIsEnable());
        PushMsgService.pushAskUser(this.context, message.getElementList(), StrUtils.longAsString(chatMessage.getMessageId()), messageConfig, message.isAllowUserInput(), message.isSseAutoClose());
    }

    public AskUserMessage buildAskUserMessage(Context context, Flow flow, AskUserAction askUserAction, Execution e) {
        AskUserMessage message = new AskUserMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(askUserAction.getId());
        message.setElementList(FlowUtils.toMessages(context, askUserAction.getVarList(), askUserAction.getInParamMap(), askUserAction, e));
        message.setAllowUserInput(askUserAction.isAllowUserInput());
        message.setSseAutoClose(askUserAction.isSseAutoClose());
        return message;
    }
}

