/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.cache.SessionCache;
import kd.ai.gai.core.domain.vo.DebugInfo;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseNodeApplication {
    private static final Log log = LogFactory.getLog(BaseNodeApplication.class);

    protected void initExecEnv(Context context, Action action, Flow gaiFlow, Execution e) {
        this.flowCancelledJudge(context, e);
        this.loopNextJudge(context, action, gaiFlow, e);
        FlowUtils.loadParentProperties(e);
        this.initVarInfo(action, e);
    }

    protected void flowCancelledJudge(Context context, Execution e) {
        String flowCancelled = FlowCacheData.getCache(context.getChatSessionId(), "flowCancelled");
        if (StringUtils.isNotEmpty((CharSequence)flowCancelled) && Boolean.parseBoolean(flowCancelled)) {
            e.getRuntime().terminate();
        }
    }

    protected void loopNextJudge(Context context, Action action, Flow gaiFlow, Execution e) {
        if (action.isBlockInnerNode() && gaiFlow.findNodeById(action.getBlockNodeId()).isLoopBlockNode()) {
            this.currentNodeLoopIndexIncrement(context, e, action.getId());
            List<Object> minLengthValueList = null;
            LoopAction loopAction = (LoopAction)gaiFlow.findActionById(action.getBlockNodeId());
            List<Var> varList = loopAction.getVarList();
            if (varList != null && !varList.isEmpty()) {
                List isInputVarList = varList.stream().filter(Var::isInput).collect(Collectors.toList());
                List notIsInputVarList = varList.stream().filter(var -> !var.isInput()).collect(Collectors.toList());
                for (Var var2 : isInputVarList) {
                    minLengthValueList = this.getMinLengthValueList(var2.getValue(), minLengthValueList);
                }
                List<VarMapper> inParamMap = loopAction.getInParamMap();
                Map varNameVarMapperMap = Optional.ofNullable(inParamMap).map(map -> map.stream().collect(Collectors.toMap(VarMapper::getInVarName, Function.identity(), (key1, key2) -> key2))).orElseGet(HashMap::new);
                for (Var var3 : notIsInputVarList) {
                    VarMapper outVarMapper = (VarMapper)varNameVarMapperMap.get(var3.getName());
                    String value = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(outVarMapper.getOutNodeId(), outVarMapper.getOutVarName()), e);
                    minLengthValueList = this.getMinLengthValueList(value, minLengthValueList);
                }
            }
            if (minLengthValueList != null) {
                String loopBreakVar = String.format("%s_%s", "loopBreak", action.getBlockNodeId());
                if (!minLengthValueList.isEmpty()) {
                    int loopCount = minLengthValueList.size();
                    String loopIndexVar = String.format("%s_%s", "loopIndex", action.getBlockNodeId());
                    int loopIndex = (Integer)e.get(loopIndexVar);
                    if (loopIndex >= loopCount - 1) {
                        e.set(loopBreakVar, (Object)true);
                    }
                } else {
                    e.set(loopBreakVar, (Object)true);
                }
            }
        } else if (action.isParallelBlockNode()) {
            List<Object> minLengthValueList = null;
            ParallelAction parallelAction = (ParallelAction)gaiFlow.findActionById(action.getId());
            int minParallelArrayLength = parallelAction.getParallelLimit();
            List<Var> varList = parallelAction.getVarList();
            if (varList != null && !varList.isEmpty()) {
                List isInputVarList = varList.stream().filter(Var::isInput).collect(Collectors.toList());
                List notIsInputVarList = varList.stream().filter(var -> !var.isInput()).collect(Collectors.toList());
                for (Var var4 : isInputVarList) {
                    minLengthValueList = this.getMinLengthValueList(var4.getValue(), minLengthValueList);
                }
                List<VarMapper> inParamMap = parallelAction.getInParamMap();
                Map varNameVarMapperMap = Optional.ofNullable(inParamMap).map(map -> map.stream().collect(Collectors.toMap(VarMapper::getInVarName, Function.identity(), (key1, key2) -> key2))).orElseGet(HashMap::new);
                for (Var var5 : notIsInputVarList) {
                    VarMapper outVarMapper = (VarMapper)varNameVarMapperMap.get(var5.getName());
                    String value = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(outVarMapper.getOutNodeId(), outVarMapper.getOutVarName()), e);
                    minLengthValueList = this.getMinLengthValueList(value, minLengthValueList);
                }
                minParallelArrayLength = CollectionUtils.isNotEmpty(minLengthValueList) ? minLengthValueList.size() : 0;
            }
            String parallelLimitVar = String.format("%s_%s_%s", "parallelBlockInput", "parallelLimit", action.getId());
            e.set(parallelLimitVar, (Object)Integer.min(parallelAction.getParallelLimit(), minParallelArrayLength));
        }
    }

    protected int getNodeLoopIndex(Context context, Execution e, int nodeId) {
        String loopIndexVar = String.format("%s_%s", "loopIndex", nodeId);
        String loopIndex = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(nodeId, loopIndexVar), e);
        return StringUtils.isNotEmpty((CharSequence)loopIndex) ? (int)Double.parseDouble(loopIndex) : -1;
    }

    private void currentNodeLoopIndexIncrement(Context context, Execution e, int nodeId) {
        String loopIndexVar = String.format("%s_%s", "loopIndex", nodeId);
        String varValue = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(nodeId, loopIndexVar), e);
        int loopIndex = StringUtils.isNotEmpty((CharSequence)varValue) ? (int)Double.parseDouble(varValue) + 1 : 0;
        FlowUtils.setNodeProperty(e, nodeId, loopIndexVar, loopIndex);
    }

    private List<Object> getMinLengthValueList(String value, List<Object> minLengthValueList) {
        List valueList;
        List list = valueList = StringUtils.isNotEmpty((CharSequence)value) ? JSONObject.parseArray((String)value, Object.class) : new ArrayList();
        if (minLengthValueList == null || valueList != null && valueList.size() < minLengthValueList.size()) {
            minLengthValueList = valueList;
        }
        return minLengthValueList;
    }

    protected String getUserInput(Execution e) {
        Object userInputObj = FlowUtils.getNodeProperty(e, 0, "system.user_input");
        return userInputObj != null ? (String)userInputObj : "";
    }

    private boolean isDebug(Execution e) {
        Object isDebugObj = FlowUtils.getNodeProperty(e, 0, "debug_is_debug");
        return isDebugObj != null && Boolean.parseBoolean((String)isDebugObj);
    }

    protected void cacheDebugVarValue(Context context, Flow gaiFlow, int nodeId, Execution e) {
        if (this.isDebug(e)) {
            String debugResultCacheKey = String.format("%s_%s_%s", "debugProcessResult", RequestContext.get().getCurrUserId(), gaiFlow.getDefId());
            Map<String, Object> properties = FlowUtils.getMemoryProperties(e);
            properties.put(FlowUtils.getPropertyName(0, "system.chat_sessionid"), context.getChatSessionId());
            DebugInfo debugInfo = (DebugInfo)JSONObject.parseObject((String)FlowUtils.getNodePropertyStr(e, 0, "debug_info"), DebugInfo.class);
            if (StringUtils.isNotEmpty((CharSequence)debugInfo.getDebugNodeId()) && Integer.parseInt(debugInfo.getDebugNodeId()) == nodeId) {
                FlowRuntime runtime = e.getRuntime();
                Map runtimeDoc = runtime.toJson();
                debugInfo.setRuntimeDoc(runtimeDoc);
                debugInfo.setFlowId(gaiFlow.getId());
                debugInfo.setSuspend(true);
                FlowUtils.suspend(context.getChatSessionId(), gaiFlow.getId(), runtime);
            } else {
                debugInfo.setSuspend(false);
            }
            debugInfo.setExecNodeId(nodeId);
            properties.put(FlowUtils.getPropertyName(0, "debug_info"), JSONObject.toJSONString((Object)debugInfo));
            SessionCache.get().put(debugResultCacheKey, JSONObject.toJSONString(properties));
        }
    }

    protected void initVarInfo(Action action, Execution e) {
        ArrayList<Var> varList = new ArrayList<Var>(10);
        if (action instanceof LLMAction) {
            LLMAction llmAction = (LLMAction)action;
            BaseNodeApplication.fillPromptVarInfo(llmAction, varList);
        } else if (action instanceof JavaPluginAction) {
            JavaPluginAction javaPluginAction = (JavaPluginAction)action;
            BaseNodeApplication.fillJavaPluginVarInfo(javaPluginAction, varList);
        } else if (action instanceof MessageAction) {
            MessageAction messageAction = (MessageAction)action;
            varList.addAll(CollectionUtils.emptyIfNull(messageAction.getVarList()));
        } else if (action instanceof AskUserAction) {
            AskUserAction askUserAction = (AskUserAction)action;
            varList.addAll(CollectionUtils.emptyIfNull(askUserAction.getVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(askUserAction.getOutputVarList()));
        } else if (action instanceof RepoAction) {
            RepoAction repoAction = (RepoAction)action;
            varList.addAll(CollectionUtils.emptyIfNull(repoAction.getVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(repoAction.getOutputVarList()));
        } else if (action instanceof RepoReplyAction) {
            RepoReplyAction repoReplyAction = (RepoReplyAction)action;
            varList.addAll(CollectionUtils.emptyIfNull(repoReplyAction.getVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(repoReplyAction.getOutputVarList()));
        } else if (action instanceof LoopAction) {
            LoopAction loopAction = (LoopAction)action;
            varList.addAll(CollectionUtils.emptyIfNull(loopAction.getLoopVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(loopAction.getVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(loopAction.getOutputVars()));
        } else if (action instanceof CodeAction) {
            CodeAction codeAction = (CodeAction)action;
            varList.addAll(CollectionUtils.emptyIfNull(codeAction.getVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(codeAction.getOutputVarList()));
        } else if (action instanceof ParallelAction) {
            ParallelAction parallelAction = (ParallelAction)action;
            varList.addAll(CollectionUtils.emptyIfNull(parallelAction.getLoopVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(parallelAction.getVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(parallelAction.getOutputVars()));
        } else if (action instanceof ToolAction) {
            ToolAction toolAction = (ToolAction)action;
            varList.addAll(CollectionUtils.emptyIfNull(toolAction.getInputVarList()));
            varList.addAll(CollectionUtils.emptyIfNull(toolAction.getOutputVarList()));
        }
        this.initVarList(action.getId(), e, varList);
    }

    private static void fillPromptVarInfo(LLMAction llmAction, List<Var> varList) {
        int promptType = llmAction.getPromptType();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            DynamicObject prompt = BusinessDataServiceHelper.loadSingleFromCache((Object)llmAction.getLlmPromptId(), (String)GaiFormIdEnum.GAI_PROMPT.getId());
            if (prompt != null) {
                DynamicObjectCollection outputs;
                DynamicObjectCollection inputs = prompt.getDynamicObjectCollection("var_configs");
                if (inputs != null) {
                    for (DynamicObject input : inputs) {
                        Var var = new Var();
                        var.setName(input.getString("var_name"));
                        var.setType(input.getString("var_type"));
                        varList.add(var);
                    }
                }
                if ((outputs = prompt.getDynamicObjectCollection("out_var_configs")) != null) {
                    for (DynamicObject output : outputs) {
                        Var var = new Var();
                        var.setName(output.getString("out_var_name"));
                        var.setType(output.getString("out_var_type"));
                        varList.add(var);
                    }
                }
            }
        } else {
            List<Var> inputVarList = llmAction.getPromptTemplateContent().getInputVarList();
            varList.addAll(CollectionUtils.emptyIfNull(inputVarList));
            List<Var> outputVarList = llmAction.getPromptTemplateContent().getOutputVarList();
            varList.addAll(CollectionUtils.emptyIfNull(outputVarList));
        }
    }

    private static void fillJavaPluginVarInfo(JavaPluginAction javaPluginAction, List<Var> varList) {
        DynamicObject operation = BusinessDataServiceHelper.loadSingle((Object)javaPluginAction.getActionId(), (String)GaiFormIdEnum.GAI_OPERATION.getId());
        if (operation != null) {
            DynamicObjectCollection outputs;
            DynamicObjectCollection inputs = operation.getDynamicObjectCollection("input");
            if (inputs != null) {
                for (DynamicObject input : inputs) {
                    Var var = new Var();
                    var.setName(input.getString("input_name"));
                    var.setType(input.getString("input_type"));
                    var.setDesc(input.getString("input_desc"));
                    varList.add(var);
                }
            }
            if ((outputs = operation.getDynamicObjectCollection("output")) != null) {
                for (DynamicObject output : outputs) {
                    Var var = new Var();
                    var.setName(output.getString("output_name"));
                    var.setType(output.getString("output_type"));
                    var.setDesc(output.getString("output_desc"));
                    varList.add(var);
                }
            }
        }
    }

    private void initVarList(int nodeId, Execution e, List<Var> varList) {
        if (CollectionUtils.isNotEmpty(varList)) {
            varList.forEach(var -> FlowUtils.setNodePropertyConditionVarType(e, nodeId, var.getName(), var.getType()));
        }
    }

    protected void saveTraceLog(Context context, Flow gaiFlow, Action action, Message message, long startTs, Map<String, String> bizResult) {
        long end = System.currentTimeMillis();
        Node node = gaiFlow.findNodeById(action.getId());
        TraceUtil.saveFlowNodeLog(new Result(Errors.OK), context, gaiFlow, node, message, action, startTs, end, bizResult);
    }

    protected void saveErrorTraceLog(Context context, Flow gaiFlow, Action action, Message message, long start, Result errorResult) {
        long end = System.currentTimeMillis();
        Node node = gaiFlow.findNodeById(action.getId());
        TraceUtil.saveFlowNodeLog(errorResult, context, gaiFlow, node, message, action, start, end, null);
    }
}

