/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.BillOperateAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.BillOperateMessage;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BillOperateNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(BillOperateNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private BillOperateAction action;
    private int parallelIndex;

    public BillOperateNodeApplication(Context context, Flow gaiFlow, BillOperateAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope variableScope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        log.info("Bill Operate process run");
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        BillOperateMessage message = this.buildBillOperateMessage(this.context, this.gaiFlow, this.action, e, this.parallelIndex);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Object[] ids = message.getIds();
        if (ids == null || ids.length == 0) {
            throw new KDBizException(Errors.billOperateError(ResManager.loadKDString((String)"\u8282\u70b9\u6570\u636e\u5f02\u5e38,\u4e1a\u52a1\u5355\u636eids\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6570\u636e\u6765\u6e90\u3002", (String)"BillOperateNodeApplication_8", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
        }
        String bizBill = message.getBizBill();
        String bizOperate = message.getBizOperate();
        try {
            String msg;
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)bizOperate, (String)bizBill, (Object[])ids, (OperateOption)OperateOption.create());
            boolean operateStatus = operationResult.isSuccess();
            int billCount = operationResult.getBillCount();
            List successPkIds = operationResult.getSuccessPkIds();
            Set errorIds = Collections.EMPTY_SET;
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            if (operateStatus) {
                msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"BillOperateNodeApplication_0", (String)"ai-gai-core", (Object[])new Object[0]);
            } else {
                errorIds = allErrorOrValidateInfo.stream().map(operateInfo -> String.valueOf(operateInfo.getPkValue())).collect(Collectors.toSet());
                int errorSize = errorIds.size();
                String operateName = BillOperateNodeApplication.getOperateName(bizBill, bizOperate);
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5171%s%s\u6761\u5355\u636e\uff0c\u6210\u529f%s\u6761\uff0c\u5931\u8d25%s\u6761\n", (String)"BillOperateNodeApplication_1", (String)"ai-gai-core", (Object[])new Object[0]), operateName, billCount, successPkIds.size(), errorSize));
                errorMsg.append(ResManager.loadKDString((String)"\u5931\u8d25\u5355\u636e\u8be6\u60c5\uff1a", (String)"BillOperateNodeApplication_2", (String)"ai-gai-core", (Object[])new Object[0]));
                allErrorOrValidateInfo.forEach(operateInfo -> errorMsg.append("\n").append(operateInfo.getMessage()));
                msg = errorMsg.toString();
            }
            List successIds = Collections.EMPTY_LIST;
            if (successPkIds != null && !successPkIds.isEmpty()) {
                successIds = successPkIds.stream().map(Object::toString).collect(Collectors.toList());
            }
            dataMap.put("status", operateStatus);
            dataMap.put("successIds", successIds);
            dataMap.put("errorIds", errorIds);
            dataMap.put("message", msg);
            FlowUtils.setNodeProperties(e, this.action.getId(), dataMap);
            this.action.setName(e.getDefine().getTitle());
            this.saveTraceLog(this.context, this.gaiFlow, this.action, message, start, BillOperateNodeApplication.convertTraceLog(dataMap));
            this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
        }
        catch (Exception ex) {
            log.error("Bill Operate error msg:{}", (Object)ex.getMessage(), (Object)ex);
            if (ex instanceof KDException) {
                String billName = MetadataServiceHelper.getDataEntityType((String)bizBill).getDisplayName().getLocaleValue();
                String operateName = BillOperateNodeApplication.getOperateName(bizBill, bizOperate);
                operateName = StringUtils.isEmpty((String)operateName) ? bizOperate : String.format("%s(%s)", operateName, bizOperate);
                ErrorCode errorCode = Errors.billOperateError(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%s(%s)\u3011,\u4e1a\u52a1\u64cd\u4f5c\u3010%s\u3011\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u65b9\u68c0\u67e5,\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"BillOperateNodeApplication_7", (String)"ai-gai-core", (Object[])new Object[0]), billName, bizBill, operateName, ex.getMessage()));
                throw new KDBizException(errorCode, new Object[0]);
            }
            throw ex;
        }
    }

    @Nullable
    private static String getOperateName(String bizBill, String bizOperate) {
        Map billOperate = EntityMetadataCache.getDataEntityOperate((String)bizBill).stream().filter(op -> bizOperate.equals(op.get("key"))).findFirst().orElse(null);
        String operateName = null;
        if (billOperate != null) {
            operateName = LocaleString.fromMap((Map)((Map)billOperate.get("name"))).getLocaleValue();
        }
        return operateName;
    }

    public BillOperateMessage buildBillOperateMessage(Context context, Flow flow, BillOperateAction action, Execution e, int parallelIndex) {
        BillOperateMessage message = new BillOperateMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(action.getId());
        message.setBizBill(action.getBizBill());
        message.setBizOperate(action.getBizOperate());
        Object[] billIdList = this.getBillIdList(context, action, e, parallelIndex);
        message.setIds(billIdList);
        return message;
    }

    private Object[] getBillIdList(Context context, BillOperateAction action, Execution e, int parallelIndex) {
        String bizBill = action.getBizBill();
        Var var = action.getInputVarList().get(0);
        if (var != null && var.isInput()) {
            String input = var.getValue();
            try {
                List ids = JsonUtil.fromJson(input, List.class);
                return BillOperateNodeApplication.conversionIds(ids, bizBill);
            }
            catch (Exception ex) {
                if (ex instanceof KDBizException) {
                    throw ex;
                }
                log.error("bill operate ids input error :{}", (Object)ex.getMessage(), (Object)ex);
                throw new KDBizException(Errors.billOperateError(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636eids\u6570\u636e\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5\u8282\u70b9\u5165\u53c2\u3010ids\u3011\u914d\u7f6e", (String)"BillOperateNodeApplication_3", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
            }
        }
        List<VarMapper> inParamMap = action.getInParamMap();
        if (inParamMap != null && !inParamMap.isEmpty()) {
            if (StringUtils.isEmpty((String)bizBill)) {
                throw new KDBizException(Errors.billOperateError(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillOperateNodeApplication_4", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
            }
            VarMapper inParam = action.getInParamMap().get(0);
            List idList = (List)FlowUtils.getVarValue(context, FlowUtils.getPropertyName(inParam.getOutNodeId(), inParam.getOutVarName()), e, VarFieldType.ARRAY_STRING, parallelIndex);
            Object[] idList1 = BillOperateNodeApplication.conversionIds(idList, bizBill);
            if (idList1 != null) {
                return idList1;
            }
        }
        return null;
    }

    private static Object[] conversionIds(List<String> idList, String bizBill) {
        if (idList == null || idList.isEmpty()) {
            throw new KDBizException(Errors.billOperateError(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillOperateNodeApplication_5", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
        }
        BillEntityType dataEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)bizBill);
        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
        try {
            if (primaryKey instanceof LongProp) {
                return idList.stream().map(Long::parseLong).toArray();
            }
            if (primaryKey instanceof VarcharProp) {
                return idList.stream().map(String::valueOf).toArray();
            }
        }
        catch (Exception ex) {
            ErrorCode errorCode = Errors.billIdConvertionError(String.format(ResManager.loadKDString((String)"\u6570\u636e\uff1a%s,\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"BillOperateNodeApplication_6", (String)"ai-gai-core", (Object[])new Object[0]), JsonUtil.toJson(idList), ex.getMessage()));
            log.error("bill operate conversion ids error :{}", (Object)JsonUtil.toJson(errorCode), (Object)ex);
            throw new KDBizException(errorCode, new Object[0]);
        }
        return null;
    }

    public static Map<String, String> convertTraceLog(Map<String, Object> originalMap) {
        if (originalMap == null) {
            return new HashMap<String, String>();
        }
        return originalMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonUtil.toJson(entry.getValue())));
    }
}

