/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.message.CodeMessage;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.flow.script.GaiScript;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.script.Script;
import kd.ai.gai.flow.script.Util;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CodeNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(CodeNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private CodeAction action;
    private int parallelIndex;

    public CodeNodeApplication(Context context, Flow gaiFlow, CodeAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        CodeMessage message = this.buildCodeMessage(this.context, this.gaiFlow, this.action, e, this.parallelIndex);
        HashMap<String, Object> scriptCtx = new HashMap<String, Object>(10);
        scriptCtx.putAll(Constant.ENGINE.scriptCtx);
        scriptCtx.put("$input", message.getInParams());
        Script p = null;
        try {
            p = GaiScript.compile(message.getCode(), scriptCtx);
        }
        catch (Exception ex) {
            log.error("\u4ee3\u7801\u7f16\u8bd1\u9519\u8bef:{}" + ex.getMessage(), (Throwable)ex);
            throw new KDBizException(Errors.codeCompileError(this.action.getName(), ex.getMessage()), new Object[0]);
        }
        Object result = null;
        try {
            result = p.eval(scriptCtx);
            log.info("code eval result: {}", result);
        }
        catch (Exception ex) {
            String msg = Util.formatException((Exception)ex);
            log.error("\u4ee3\u7801\u6267\u884c\u5f02\u5e38:{}" + msg, (Throwable)ex);
            throw new KDBizException(Errors.codeExecuteError(this.action.getName(), ex.getMessage()), new Object[0]);
        }
        String resultStr = StrUtils.getEvalResult(result);
        HashMap<String, String> outputDataMap = new HashMap<String, String>();
        if (message.isEnableParseJson()) {
            JSONObject resultJo;
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                log.error("\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a");
                throw new KDBizException(Errors.codeResultParseError(this.action.getName(), "\u4ee3\u7801\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a\u3002"), new Object[0]);
            }
            try {
                resultJo = JSONObject.parseObject((String)resultStr);
            }
            catch (Exception ex) {
                log.error("\u6267\u884c\u7ed3\u679c\u8f6cJSON\u5f02\u5e38:{}" + ex.getMessage(), (Throwable)ex);
                throw new KDBizException(Errors.codeResultParseError(this.action.getName(), String.format("\u4ee3\u7801\u6267\u884c\u7ed3\u679c\uff1a%s\u3002\u4e0d\u662f\u6709\u6548JSONObject\u3002", resultStr)), new Object[0]);
            }
            List<Var> outputVarList = this.action.getOutputVarList();
            if (outputVarList != null && !outputVarList.isEmpty()) {
                outputVarList.forEach(var -> {
                    Object varValue = resultJo.get((Object)var.getName());
                    FlowUtils.setNodeProperty(e, this.action.getId(), var.getName(), varValue);
                    outputDataMap.put(var.getName(), varValue != null ? varValue.toString() : null);
                });
            }
        } else {
            FlowUtils.setNodeProperty(e, this.action.getId(), "output", resultStr);
            outputDataMap.put("output", resultStr);
        }
        this.action.setName(e.getDefine().getTitle());
        this.saveTraceLog(this.context, this.gaiFlow, this.action, message, start, outputDataMap);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }

    public CodeMessage buildCodeMessage(Context context, Flow flow, CodeAction codeAction, Execution e, int parallelIndex) {
        AtomicReference<String> code = new AtomicReference<String>(codeAction.getCode());
        CodeMessage message = new CodeMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(codeAction.getId());
        message.setEnableParseJson(codeAction.isEnableParseJson());
        LinkedHashMap<String, Object> inParams = new LinkedHashMap<String, Object>();
        inParams.put("chatSessionId", context.getChatSessionId());
        List<VarMapper> inParamMap = codeAction.getInParamMap();
        if (inParamMap != null && !inParamMap.isEmpty()) {
            inParamMap.forEach(inParam -> {
                String value = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(inParam.getOutNodeId(), inParam.getOutVarName()), e, parallelIndex);
                inParams.put(inParam.getInVarName(), value);
                code.set(FlowUtils.fillCode((String)code.get(), inParam.getInVarName(), value));
            });
        }
        message.setInParams(inParams);
        message.setCode(code.get());
        return message;
    }
}

