/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.message.EndFlowMessage;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.flow.var.FlowVariableService;
import kd.ai.gai.core.helper.ClusterWaiter;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

public class EndNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(EndNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private EndFlowMessage message;
    private FlowVariableService flowVariableService = FlowVariableService.getInstance();

    public EndNodeApplication(Context context, Flow gaiFlow, EndFlowMessage message) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.message = message;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long startTs = System.currentTimeMillis();
        FlowUtils.loadParentProperties(e);
        Result flowResult = new Result(Errors.OK);
        End end = this.gaiFlow.getEnd();
        List<VarMapper> outParamMap = end.getOutParamMap();
        HashMap<String, String> data = new HashMap<String, String>(0);
        if (outParamMap != null && !outParamMap.isEmpty()) {
            Map<String, Object> properties = FlowUtils.getMemoryProperties(e);
            for (VarMapper varMapper : outParamMap) {
                String name = FlowUtils.getPropertyName(varMapper.getOutNodeId(), varMapper.getOutVarName());
                Object obj = properties.get(name);
                String value = obj != null ? obj.toString() : "";
                data.put(varMapper.getInVarName(), value);
            }
            flowResult.setData(data);
            FlowUtils.setNodeProperties(e, end.getId(), data);
        }
        PushMsgService.pushEndOutput(this.context, this.gaiFlow.getId(), data);
        flowResult.setStatus(Result.Status.END);
        String key = String.format("%s_%s", this.context.getChatSessionId(), this.gaiFlow.getDefId());
        FlowCacheData.putCache(this.context.getChatSessionId(), key, JSON.toJSONString((Object)flowResult));
        ClusterWaiter.release(key);
        this.flowVariableService.storeFlowVariables(this.context.getChatSessionId(), e, this.gaiFlow);
        PushMsgService.pushWaitingDone(this.context);
        this.clearFlowCacheData(this.context, this.message, this.gaiFlow);
        End endAction = this.gaiFlow.getEnd();
        this.saveTraceLog(this.context, this.gaiFlow, endAction, null, startTs, flowResult.getData());
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.gaiFlow.getEnd().getId(), e);
        IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(this.context.getSlideenv(), this.context.getChatTraceId(), this.context.getTraceId(), UserFeedbackTypeEnum.OK.getId(), KDDateUtils.now().getTime()));
    }

    private void clearFlowCacheData(Context context, EndFlowMessage message, Flow flow) {
        String chatSessionId = context.getChatSessionId();
        long flowId = message.getFlowId();
        FlowCacheData.clearFlowNodeData(chatSessionId, flowId, flow.getStart().getId());
        for (Action action : flow.getActions()) {
            FlowCacheData.clearFlowNodeData(chatSessionId, flowId, action.getId());
        }
        FlowCacheData.clearFlow(chatSessionId, flowId);
    }
}

