/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Operation;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.handler.SysOperateHandler;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.ForwardMessage;
import kd.ai.gai.core.engine.message.JavaActionMessage;
import kd.ai.gai.core.enuz.ForwardType;
import kd.ai.gai.core.enuz.OperationType;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.service.OperationService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class JavaActionNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(JavaActionNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private JavaPluginAction action;
    private int parallelIndex;

    public JavaActionNodeApplication(Context context, Flow gaiFlow, JavaPluginAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        Result result = new Result(Errors.OK);
        JavaActionMessage message = this.buildJavaActionMessage(this.context, this.gaiFlow, this.action, e, this.parallelIndex);
        if (this.isSysOperation(message)) {
            Map<String, String> bizResult = this.callSysOperation(message);
            FlowUtils.setNodeProperties(e, message.getNodeId(), bizResult);
            this.saveTraceLog(this.context, this.gaiFlow, this.action, message, start, bizResult);
            this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
            return;
        }
        if (message.isFrontOperation()) {
            if (this.action.isBlockInnerNode() && this.gaiFlow.findActionById(this.action.getBlockNodeId()).isParallelBlockNode()) {
                throw new KDBizException(Errors.notSupportActionType(ResManager.loadKDString((String)"\u6279\u5904\u7406\u6a21\u5f0f\u4e0d\u652f\u6301\u524d\u7aef\u64cd\u4f5cIGPTFormAction", (String)"JavaActionNodeApplication_0", (String)"ai-gai-core", (Object[])new Object[0])), new Object[0]);
            }
            String bizPageIdOrRootPageId = message.getPageId() == null ? this.context.getRootPageId() : message.getPageId();
            bizPageIdOrRootPageId = bizPageIdOrRootPageId == null ? "" : bizPageIdOrRootPageId;
            Map<String, String> bizResult = this.callAction(this.context, message.getAppId(), message.getClassName(), new Object[]{bizPageIdOrRootPageId, message.getActionName(), message.getParams()});
            String actionResultStr = bizResult.get("actionresult");
            if (StringUtils.isEmpty((String)actionResultStr)) {
                log.warn("\u524d\u7aef\u4e1a\u52a1\u64cd\u4f5c\u6ca1\u6709\u8fd4\u56deactionresult\u3002 {}", (Object)JSONObject.toJSONString((Object)message));
            } else if (this.context.getAssistantPageId() != null) {
                PageCache pageCache = new PageCache(this.context.getAssistantPageId());
                String actionKey = "action_result_" + this.context.getChatSessionId();
                pageCache.put(actionKey, actionResultStr);
                ForwardMessage forwardMessage = new ForwardMessage();
                forwardMessage.setChatSessionId(message.getChatSessionId());
                forwardMessage.setFlowId(message.getFlowId());
                forwardMessage.setNodeId(message.getNodeId());
                FlowRuntime runtime = e.getRuntime();
                forwardMessage.setRuntimeDoc(runtime.toJson());
                String forwardMessageKey = "forwardMessage_" + this.context.getChatSessionId();
                pageCache.put(forwardMessageKey, JSONObject.toJSONString((Object)forwardMessage));
                PushMsgService.pushForward(this.context, ForwardType.javaAction, actionKey, forwardMessageKey);
                result.setCallback(true);
                this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
                FlowUtils.suspend(this.context.getChatSessionId(), this.gaiFlow.getId(), runtime);
            }
            result.setData(bizResult);
            this.saveTraceLog(this.context, this.gaiFlow, this.action, message, start, bizResult);
            FlowUtils.setNodeProperties(e, message.getNodeId(), bizResult);
        } else {
            try {
                Map<String, String> bizResult = this.callAction(this.context, message.getAppId(), message.getClassName(), new Object[]{message.getActionName(), message.getParams()});
                result.setData(bizResult);
                FlowUtils.setNodeProperties(e, message.getNodeId(), bizResult);
                this.action.setName(e.getDefine().getTitle());
                this.saveTraceLog(this.context, this.gaiFlow, this.action, message, start, bizResult);
                this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
            }
            catch (Exception ex) {
                log.error("\u81ea\u5b9a\u4e49\u64cd\u4f5c\u6267\u884c\u5f02\u5e38:{}", (Object)ex.getMessage(), (Object)ex);
                ErrorCode errorCode = Errors.nodeExecuteError(this.action.getName(), ex.getMessage());
                FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
                flowErrorMessage.setErrorCode(errorCode);
                flowErrorMessage.setFlowId(this.gaiFlow.getId());
                flowErrorMessage.setChatSessionId(this.context.getChatSessionId());
                HandlerFactory.runHandler(this.context, flowErrorMessage);
                this.saveErrorTraceLog(this.context, this.gaiFlow, this.action, message, start, new Result(errorCode));
                e.stop();
            }
        }
    }

    public Map<String, String> callSysOperation(JavaActionMessage message) {
        SysOperateHandler sysOperateHandler = new SysOperateHandler();
        return sysOperateHandler.invokeAction(message.getActionName(), message.getParams());
    }

    private boolean isSysOperation(JavaActionMessage message) {
        return message.getClassName().trim().equals(SysOperateHandler.class.getName());
    }

    public Map<String, String> callAction(Context context, String appId, String className, Object[] bizParams) {
        FlowCacheData.restoreRequestContext(context.getChatSessionId());
        Object ret = DispatchServiceHelper.invokeBOSService((String)appId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{className, "invokeAction", bizParams});
        if (ret instanceof Map) {
            return (Map)ret;
        }
        log.error("{} : {} \u8c03\u7528\u8fd4\u56de\u7c7b\u578b\u4e0d\u662fMap<String,String>, \u8fd4\u56de\u503c: {} ", new Object[]{appId, className, ret});
        return Collections.emptyMap();
    }

    public JavaActionMessage buildJavaActionMessage(Context context, Flow flow, JavaPluginAction javaPluginAction, Execution e, int parallelIndex) {
        JavaActionMessage message = new JavaActionMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setPageId(context.getBizPageId());
        message.setFlowId(flow.getId());
        message.setNodeId(javaPluginAction.getId());
        Operation operation = OperationService.getOperationById(javaPluginAction.getActionId());
        if (operation == null) {
            throw new KDBizException(Errors.operationNotExistedError(String.valueOf(javaPluginAction.getActionId())), new Object[0]);
        }
        message.setAppId(operation.getAppid());
        message.setClassName(operation.getServiceName());
        message.setActionName(operation.getAction());
        message.setFrontOperation(operation.getOperationType() == OperationType.Client);
        Map<String, String> params = FlowUtils.buildInputData(context, this.action, e, parallelIndex);
        List<Var> inputVarList = operation.getInputVarList();
        if (inputVarList != null && !inputVarList.isEmpty()) {
            inputVarList.stream().filter(Var::isInput).forEach(var -> params.put(var.getName(), var.getValue()));
        }
        message.setParams(params);
        return message;
    }
}

