/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class LoopNextNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(LoopNextNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private LoopAction action;

    public LoopNextNodeApplication(Context context, Flow gaiFlow, LoopAction action) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        String loopIndexVar = String.format("%s_%s", "loopIndex", this.action.getId());
        int loopIndex = (Integer)e.get(loopIndexVar);
        List<Var> outputVars = this.action.getOutputVars();
        List<VarMapper> outParamMap = this.action.getOutParamMap();
        if (outputVars != null && !outputVars.isEmpty()) {
            Map inVarNameOutParamMap = outParamMap != null ? outParamMap.stream().collect(Collectors.toMap(VarMapper::getInVarName, Function.identity(), (key1, key2) -> key2)) : Collections.emptyMap();
            int finalLoopIndex = loopIndex;
            outputVars.forEach(var -> {
                if (var.isInput()) {
                    if (StringUtils.isNotEmpty((String)var.getValue())) {
                        FlowUtils.setNodeProperty(e, this.action.getId(), var.getName(), var.getValue());
                    }
                } else {
                    VarMapper varMapper = (VarMapper)inVarNameOutParamMap.get(var.getName());
                    if (varMapper != null) {
                        int outNodeId = varMapper.getOutNodeId();
                        String inPropertyName = FlowUtils.getPropertyName(this.action.getId(), varMapper.getInVarName());
                        String outPropertyName = FlowUtils.getPropertyName(outNodeId, varMapper.getOutVarName());
                        if (outNodeId == this.action.getId()) {
                            Object targetValue = FlowUtils.getVarValue(this.context, outPropertyName, e, var.getVarFieldType());
                            FlowUtils.setNodeProperty(e, this.action.getId(), var.getName(), targetValue);
                        } else {
                            int currentNodeLoopIndex = this.getNodeLoopIndex(this.context, e, outNodeId);
                            if (currentNodeLoopIndex == finalLoopIndex) {
                                ArrayList<Object> valueList = (ArrayList<Object>)FlowUtils.getVarValue(this.context, inPropertyName, e, var.getListVarFieldType());
                                if (valueList == null) {
                                    valueList = new ArrayList<Object>();
                                }
                                Object targetValue = FlowUtils.getVarValue(this.context, outPropertyName, e, var.getItemVarFieldType());
                                valueList.add(targetValue);
                                FlowUtils.setNodeProperty(e, this.action.getId(), varMapper.getInVarName(), JSONObject.toJSONString(valueList));
                            }
                        }
                    }
                }
            });
        }
        String loopBreakVar = String.format("%s_%s", "loopBreak", this.action.getId());
        boolean loopBreak = (Boolean)e.get(loopBreakVar);
        if (loopIndex + 1 > 200) {
            e.set(loopBreakVar, (Object)true);
            log.info("loopBreak!The maximum number of loop has been reached: {} ", (Object)200);
            this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
            throw new KDBizException(Errors.loopIndexOverMaxLimit(this.action.getName(), 200), new Object[0]);
        }
        if (!loopBreak) {
            e.set(loopIndexVar, (Object)(++loopIndex));
        }
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }
}

