/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.handler.StopStreamHandler;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MessageNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(MessageNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private MessageAction action;
    private int parallelIndex;

    public MessageNodeApplication(Context context, Flow gaiFlow, MessageAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        MsgNodeMessage message = this.buildNodeMessage(this.context, this.gaiFlow, this.action, e, this.parallelIndex);
        if (StopStreamHandler.isStopped(this.context.getChatSessionId(), message.getFlowId())) {
            log.warn("flow {} is stopped.", (Object)message.getFlowId());
            this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
            return;
        }
        List<MsgNodeMessage.MessageElement> messageElementList = message.getElementList();
        String userContent = MessageNodeApplication.messageToHistory(messageElementList);
        SLIDEENV assistantDevice = this.context.getSlideenv();
        HashMap<String, Boolean> tagMap = new HashMap<String, Boolean>();
        tagMap.put("replaceLast", message.isReplaceLastMessage());
        tagMap.put("concatLast", false);
        Message chatMessage = MessageService.insertMessage(this.context.getChatSessionId(), userContent, "", JSON.toJSONString(tagMap), this.context.getCurrentSkill(), ChatMessageTypeEnum.PROCESS, this.context.messageIsEnable());
        this.judgeIfSaveMessage(this.action, chatMessage);
        PushMsgService.pushMultiMsg(this.context, message.isReplaceLastMessage(), messageElementList, StrUtils.longAsString(chatMessage.getMessageId()), this.action);
        this.action.setName(e.getDefine().getTitle());
        this.saveTraceLog(this.context, this.gaiFlow, this.action, message, start, null);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }

    private void judgeIfSaveMessage(MessageAction action, Message chatMessage) {
        if (!action.isSaveMessage()) {
            DynamicObject messageDo = BusinessDataServiceHelper.loadSingle((Object)chatMessage.getMessageId(), (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId());
            messageDo.set("enable", (Object)EnableEnum.NO.getKeyStr());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{messageDo});
        }
    }

    public static String messageToHistory(List<MsgNodeMessage.MessageElement> messageElementList) {
        StringBuilder inputBuilder = new StringBuilder();
        for (MsgNodeMessage.MessageElement item : messageElementList) {
            if (item.getType().equals(MessageType.Text.getValue())) {
                inputBuilder.append(item.getValue()).append(" \r\n");
                continue;
            }
            if (item.getType().equals(MessageType.HyperLink.getValue())) {
                inputBuilder.append("[gaiurl]<urlhref>").append(item.getValue()).append("</urlhref>[/gaiurl]");
                continue;
            }
            if (item.getType().equals(MessageType.Iframe.getValue())) {
                inputBuilder.append("[gaiiframe]").append(item.getValue()).append("[/gaiiframe]");
                continue;
            }
            if (!item.getType().equals(MessageType.Picture.getValue())) continue;
            inputBuilder.append("[gaiimgurl]").append(item.getValue()).append("[/gaiimgurl]");
        }
        return inputBuilder.toString();
    }

    public MsgNodeMessage buildNodeMessage(Context context, Flow flow, MessageAction messageAction, Execution e, int parallelIndex) {
        MsgNodeMessage message = new MsgNodeMessage();
        message.setFlowId(flow.getId());
        message.setElementList(FlowUtils.toMessages(context, messageAction.getVarList(), messageAction.getInParamMap(), messageAction, e, parallelIndex));
        message.setReplaceLastMessage(messageAction.isReplaceLastMessage());
        return message;
    }
}

