/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowMemoryData;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.flow.VirtualAction;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.flow.script.GaiScript;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.misc.LockFactory;
import kd.ai.gai.flow.script.Script;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ParallelBlockEndNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(ParallelBlockEndNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private ParallelAction action;
    private int parallelIndex;

    public ParallelBlockEndNodeApplication(Context context, Flow gaiFlow, ParallelAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        HashMap<String, Object> scriptCtx = new HashMap<String, Object>(10);
        scriptCtx.putAll(Constant.ENGINE.scriptCtx);
        Script p = GaiScript.compile("println('parallelBlockEnd, nodeName:" + this.action.getName() + " parallelArrayIndex:" + this.parallelIndex + "');", scriptCtx);
        p.eval(scriptCtx);
        String lockKey = "ParallelBlockEndNodeApplication_getOutputVarLockKey";
        try (LockFactory.Lock lock = ((LockFactory)LockFactory.INSTANCE.get()).getLock(lockKey);){
            this.assemblyOutputListWithLock(e, lock, lockKey, start);
        }
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assemblyOutputListWithLock(Execution e, LockFactory.Lock lock, String lockKey, long start) {
        if (lock.tryLock(600000)) {
            try {
                HashMap<String, String> bizResult = new HashMap<String, String>();
                bizResult.put("parallelIndex", String.valueOf(this.parallelIndex));
                List<Var> outputVars = this.action.getOutputVars();
                List<VarMapper> outParamMap = this.action.getOutParamMap();
                if (outputVars != null && !outputVars.isEmpty()) {
                    Map inVarNameOutParamMap = outParamMap != null ? outParamMap.stream().collect(Collectors.toMap(VarMapper::getInVarName, Function.identity(), (key1, key2) -> key2)) : Collections.emptyMap();
                    outputVars.forEach(var -> {
                        VarMapper varMapper = (VarMapper)inVarNameOutParamMap.get(var.getName());
                        if (varMapper != null) {
                            ArrayList<String> outputList = null;
                            int outNodeId = varMapper.getOutNodeId();
                            String outPropertyName = FlowUtils.getPropertyName(outNodeId, varMapper.getOutVarName());
                            String outputValue = FlowUtils.getVarValue(this.context, outPropertyName, e);
                            String propertyName = FlowUtils.getPropertyName(this.action.getId(), var.getName());
                            String outputListStr = FlowMemoryData.getCache(this.context.getChatSessionId(), propertyName);
                            if (StringUtils.isNotEmpty((String)outputListStr)) {
                                outputList = JSONObject.parseArray((String)outputListStr, String.class);
                            } else {
                                String parallelLimitVar = String.format("%s_%s_%s", "parallelBlockInput", "parallelLimit", this.action.getId());
                                int parallelLimit = (Integer)e.get(parallelLimitVar);
                                outputList = new ArrayList<String>(Collections.nCopies(parallelLimit, ""));
                            }
                            outputList.set(this.parallelIndex, outputValue);
                            FlowMemoryData.putCache(this.context.getChatSessionId(), propertyName, JSONObject.toJSONString((Object)outputList));
                            bizResult.put(var.getName(), JSONObject.toJSONString((Object)outputList));
                        }
                    });
                }
                VirtualAction virtualAction = new VirtualAction(this.action.getId(), e.getDefine().getTitle());
                this.saveTraceLog(this.context, this.gaiFlow, virtualAction, null, start, bizResult);
            }
            finally {
                lock.unLock();
            }
        } else {
            throw CommonError.LOCK_TIMEOUT.create(new String[]{String.valueOf(600000), lockKey});
        }
    }
}

