/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VirtualAction;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.flow.script.GaiScript;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.DataArea;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.script.Script;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class ParallelBlockStartNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(ParallelBlockStartNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private ParallelAction action;
    private int parallelIndex;

    public ParallelBlockStartNodeApplication(Context context, Flow gaiFlow, ParallelAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        String parentMemoryPropertiesVarName;
        String parentMemoryProperties;
        long start = System.currentTimeMillis();
        String parallelLimitVar = String.format("%s_%s_%s", "parallelBlockInput", "parallelLimit", this.action.getId());
        int parallelLimit = (Integer)e.get(parallelLimitVar);
        if (this.parallelIndex > parallelLimit - 1) {
            log.info("\u5e76\u884c\u8282\u70b9\uff1a{}({})\u5165\u53c2\u6570\u7ec4\u8d85\u8fc7\u5e76\u884c\u8fd0\u884c\u6570\u91cf\u8bbe\u7f6e\uff0c parallelIndex\uff1a{} / {}", new Object[]{this.action.getName(), this.action.getId(), this.parallelIndex, parallelLimit});
            e.terminate();
            return;
        }
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        HashMap<String, Object> scriptCtx = new HashMap<String, Object>(10);
        scriptCtx.putAll(Constant.ENGINE.scriptCtx);
        Script p = GaiScript.compile("println('parallelBlockStart, nodeName:" + this.action.getName() + " parallelArrayIndex:" + this.parallelIndex + "');", scriptCtx);
        p.eval(scriptCtx);
        HashMap<String, String> bizResult = new HashMap<String, String>();
        bizResult.put("parallelIndex", String.valueOf(this.parallelIndex));
        List<Var> varList = this.action.getVarList();
        if (varList != null && !varList.isEmpty()) {
            varList.forEach(var -> {
                List valueList = new ArrayList();
                if (var.isInput()) {
                    if (StringUtils.isNotEmpty((CharSequence)var.getValue())) {
                        valueList = JSONObject.parseArray((String)var.getValue(), Object.class);
                    }
                } else {
                    String inputVarName = String.format("%s_%s_%s", "parallelBlockInput", var.getName(), this.action.getId());
                    valueList = (List)FlowUtils.getFlowVarValue(inputVarName, e, var.getVarFieldType());
                }
                e.set(var.getName(), valueList);
                FlowUtils.setNodeProperty(e, this.action.getId(), var.getName(), valueList);
                bizResult.put(var.getName(), valueList.get(this.parallelIndex).toString());
            });
        }
        if (StringUtils.isNotEmpty((CharSequence)(parentMemoryProperties = (String)e.get(parentMemoryPropertiesVarName = String.format("%s_%s_%s", "parallelBlockInput", "parentMemoryProperties", this.action.getId()))))) {
            JSONObject data = JSONObject.parseObject((String)parentMemoryProperties);
            DataArea memory = e.getMemory();
            for (Map.Entry entry : data.entrySet()) {
                memory.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        VirtualAction virtualAction = new VirtualAction(this.action.getId(), e.getDefine().getTitle());
        this.saveTraceLog(this.context, this.gaiFlow, virtualAction, null, start, bizResult);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }
}

