/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.flow.VirtualAction;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class ParallelInitNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(ParallelInitNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private ParallelAction action;

    public ParallelInitNodeApplication(Context context, Flow gaiFlow, ParallelAction action) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        Map inParamMapMap;
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        HashMap<String, String> bizResult = new HashMap<String, String>();
        List<Var> varList = this.action.getVarList();
        List<VarMapper> inParamMap = this.action.getInParamMap();
        Map<Object, Object> map = inParamMapMap = inParamMap != null ? inParamMap.stream().collect(Collectors.toMap(VarMapper::getInVarName, Function.identity(), (key1, key2) -> key2)) : Collections.emptyMap();
        if (varList != null && !varList.isEmpty()) {
            varList.forEach(var -> {
                List valueList = new ArrayList();
                if (var.isInput()) {
                    if (StringUtils.isNotEmpty((CharSequence)var.getValue())) {
                        valueList = JSONObject.parseArray((String)var.getValue(), Object.class);
                    }
                } else {
                    VarMapper varMapper = (VarMapper)inParamMapMap.get(var.getName());
                    valueList = (List)FlowUtils.getVarValue(this.context, FlowUtils.getPropertyName(varMapper.getOutNodeId(), varMapper.getOutVarName()), e, var.getVarFieldType());
                }
                String inputVarName = String.format("%s_%s_%s", "parallelBlockInput", var.getName(), this.action.getId());
                e.set(inputVarName, valueList);
                FlowUtils.setNodeProperty(e, this.action.getId(), var.getName(), valueList);
                bizResult.put(var.getName(), JSONObject.toJSONString(valueList));
            });
        }
        String parentMemoryPropertiesVarName = String.format("%s_%s_%s", "parallelBlockInput", "parentMemoryProperties", this.action.getId());
        e.set(parentMemoryPropertiesVarName, (Object)JSONObject.toJSONString((Object)e.getMemory().getProperties()));
        VirtualAction virtualAction = new VirtualAction(this.action.getId(), e.getDefine().getTitle());
        this.saveTraceLog(this.context, this.gaiFlow, virtualAction, null, start, bizResult);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }
}

