/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowMemoryData;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VirtualAction;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.CollectionUtils;

public class ParallelMergeNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(ParallelMergeNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private ParallelAction action;

    public ParallelMergeNodeApplication(Context context, Flow gaiFlow, ParallelAction action) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        HashMap<String, String> bizResult = new HashMap<String, String>();
        List<Var> outputVars = this.action.getOutputVars();
        if (CollectionUtils.isNotEmpty(outputVars)) {
            for (Var var : outputVars) {
                String propertyName = FlowUtils.getPropertyName(this.action.getId(), var.getName());
                String outputListStr = FlowMemoryData.getAndRemoveCache(this.context.getChatSessionId(), propertyName);
                FlowUtils.setNodeProperty(e, this.action.getId(), var.getName(), outputListStr);
                bizResult.put(var.getName(), outputListStr);
            }
        }
        VirtualAction virtualAction = new VirtualAction(this.action.getId(), e.getDefine().getTitle());
        this.saveTraceLog(this.context, this.gaiFlow, virtualAction, null, start, bizResult);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }
}

