/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.domain.llm.LLMSearchInfo;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.LLMActionMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMActionCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.OutPreVar;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.flow.callback.PromptNodeCallback;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class PromptNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(PromptNodeApplication.class);
    private static final int USER_HISTORY_COUNT = 200;
    private Context context;
    private Flow gaiFlow;
    private LLMAction action;
    private int parallelIndex;

    public PromptNodeApplication(Context context, Flow gaiFlow, LLMAction action) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = -1;
    }

    public PromptNodeApplication(Context context, Flow gaiFlow, LLMAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        LLMActionMessage message = this.buildLLMActionMessage(this.context, this.gaiFlow, this.action, e, this.parallelIndex);
        LLMActionCallbackMessage callbackMessage = new LLMActionCallbackMessage();
        callbackMessage.setErrCode(Errors.OK.getCode());
        callbackMessage.setParseOutput(true);
        callbackMessage.setFlowId(message.getFlowId());
        callbackMessage.setNodeId(message.getNodeId());
        callbackMessage.setPageId(this.context.getAssistantPageId());
        callbackMessage.setChatSessionId(this.context.getChatSessionId());
        callbackMessage.setGlobalSessionId(this.context.getGlobalSessionId());
        callbackMessage.setMergeLastMessageCard(message.isMergeLastMessageCard());
        FlowRuntime runtime = e.getRuntime();
        Map runtimeDoc = runtime.toJson();
        callbackMessage.setRuntimeDoc(runtimeDoc);
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(callbackMessage);
        int promptType = this.action.getPromptType();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            llmMessage.setUserInput(message.getUserInput());
            llmMessage.setPromptId(message.getPromptId());
            llmMessage.setRepoIdList(message.getRepoIdList());
        } else {
            LLM llm;
            Prompt prompt = new Prompt();
            prompt.setId(2002989110637102080L);
            String serviceNumber = message.getLlm();
            prompt.setServiceNumber(message.getLlm());
            Map<String, Object> service = AiccService.queryLlmAiccService(serviceNumber);
            if (service == null || service.isEmpty()) {
                throw new KDBizException(Errors.NO_AICC_SERVICE, new Object[0]);
            }
            String llmNumber = (String)service.get("llm");
            if (StringUtils.isEmpty((String)llmNumber)) {
                llmNumber = serviceNumber;
            }
            if ((llm = LLM.parse(llmNumber)) == null) {
                throw new KDBizException(Errors.NO_LLM_4_AICC_SERVICE(llmNumber), new Object[0]);
            }
            prompt.setLlm(llm);
            prompt.setRemembercount(0);
            prompt.setLlmStyle(LlmStyle.PRECISION);
            prompt.setReference(Boolean.FALSE);
            prompt.setChunkIdList(null);
            String userPrompt = message.getPromptTemplateContent().getUserPrompt();
            String sysPrompt = message.getPromptTemplateContent().getSysPrompt();
            Map<String, String> paramMap = message.getParams();
            String filledUserPrompt = this.fillVariable(userPrompt, paramMap);
            String filledSysPrompt = this.fillVariable(sysPrompt, paramMap);
            prompt.setPrompt(filledSysPrompt);
            llmMessage.setUserInput(filledUserPrompt);
            prompt.setPromptType(this.action.getPromptType());
            List<Var> outputVarList = this.action.getPromptTemplateContent().getOutputVarList();
            ArrayList<PromptOutVar> promptOutVarList = new ArrayList<PromptOutVar>(outputVarList.size());
            for (Var var : outputVarList) {
                PromptOutVar promptOutVar = new PromptOutVar();
                promptOutVar.setVar(var.getName());
                promptOutVar.setName(var.getDesc());
                promptOutVar.setType(var.getType());
                if (var.getName().equalsIgnoreCase(OutPreVar.GPT_OUTPUT.getVar())) {
                    promptOutVar.setJsonAnalysis(false);
                } else {
                    promptOutVar.setJsonAnalysis(true);
                }
                promptOutVarList.add(promptOutVar);
            }
            prompt.setPromptOutVarList(promptOutVarList);
            llmMessage.setPrompt(prompt);
        }
        llmMessage.setStream(message.isStream());
        llmMessage.setParamMap(message.getParams());
        llmMessage.setSync(message.isSync());
        Result result = HandlerFactory.runHandler(this.context, llmMessage);
        result.setCallback(!message.isSync());
        if (!result.getErrorCode().equals((Object)Errors.OK)) {
            log.info("flow error result {}", (Object)JsonUtil.toJson(result));
            if (result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
                PromptNodeApplication.flowEnd(this.context, this.gaiFlow.getId(), result.getErrorCode(), result.getErrorCode().getMessage());
                return;
            }
            PromptNodeApplication.flowError(this.context, this.gaiFlow.getId(), result.getErrorCode());
            return;
        }
        long end = System.currentTimeMillis();
        Node node = this.gaiFlow.findNodeById(this.action.getId());
        TraceUtil.saveFlowNodeLog(result, this.context, this.gaiFlow, node, message, this.action, start, end, result.getData());
        if (message.isSync()) {
            PromptNodeApplication.syncCallback(result, callbackMessage);
            new PromptNodeCallback().inject(runtime.getLastExecution(), callbackMessage);
        }
    }

    public static void syncCallback(Result result, LLMParsedMessage callbackMessage) {
        Map<String, String> data = result.getData();
        callbackMessage.setLlmValue(data.get("llmValue"));
        callbackMessage.setAllMsg(data.get("llmValue"));
        callbackMessage.setTaskId(data.get("taskId"));
        if (StringUtils.isNotEmpty((String)data.get("jsonValue"))) {
            callbackMessage.setJsonValue((Map)SerializationUtils.fromJsonString((String)data.get("jsonValue"), Map.class));
        }
        if (StringUtils.isNotEmpty((String)data.get("citationInfos"))) {
            List citationInfos = SerializationUtils.fromJsonStringToList((String)data.get("citationInfos"), KnowledgeCitationData.class);
            callbackMessage.setCitationInfos(citationInfos);
        }
        if (StringUtils.isNotEmpty((String)data.get("searchInfos"))) {
            List searchInfos = SerializationUtils.fromJsonStringToList((String)data.get("searchInfos"), LLMSearchInfo.class);
            callbackMessage.setSearchInfos(searchInfos);
        }
        callbackMessage.setStream(false);
        callbackMessage.setEnd(true);
    }

    public static Result flowEnd(Context context, long flowId, ErrorCode errorCode, String msg) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        flowErrorMessage.setMsg(msg);
        log.info("flow end {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public static Result flowError(Context context, long flowId, ErrorCode errorCode) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        log.info("flow error {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public LLMActionMessage buildLLMActionMessage(Context context, Flow flow, LLMAction llmAction, Execution e, int parallelIndex) {
        LLMActionMessage message = new LLMActionMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(llmAction.getId());
        message.setStream(llmAction.isStream());
        message.setMergeLastMessageCard(llmAction.isMergeLastMessageCard());
        int promptType = llmAction.getPromptType();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            String propertyName;
            String repoIDStr;
            message.setPromptId(llmAction.getLlmPromptId());
            message.setUserInput(this.getUserInput(llmAction, e, parallelIndex));
            VarMapper repoMapper = llmAction.getRepoMapper();
            if (repoMapper != null && StringUtils.isNotEmpty((String)(repoIDStr = FlowUtils.getVarValue(context, propertyName = FlowUtils.getPropertyName(repoMapper.getOutNodeId(), repoMapper.getOutVarName()), e, parallelIndex)))) {
                String[] idArray = repoIDStr.split(",");
                ArrayList<Long> repoIdList = new ArrayList<Long>(idArray.length);
                for (String idStr : idArray) {
                    repoIdList.add(Long.parseLong(idStr.trim()));
                }
                message.setRepoIdList(repoIdList);
            }
            message.setParams(FlowUtils.buildInputData(context, llmAction, e, parallelIndex));
        } else {
            message.setLlm(llmAction.getLlm());
            message.setPromptTemplateContent(llmAction.getPromptTemplateContent());
            Map<String, String> varMap = FlowUtils.buildInputData(context, llmAction, e, parallelIndex);
            message.setParams(varMap);
        }
        if (llmAction.isBlockInnerNode() && this.gaiFlow.findNodeById(llmAction.getBlockNodeId()).isParallelBlockNode()) {
            message.setSync(true);
        }
        return message;
    }

    protected String getUserInput(LLMAction llmAction, Execution e, int parallelIndex) {
        String userInput;
        Map<String, Object> inputMap = FlowUtils.getMemoryProperties(e);
        if (llmAction.getUserInputMapper() != null) {
            VarMapper userInputMapper = llmAction.getUserInputMapper();
            String outVarName = FlowUtils.getPropertyName(userInputMapper.getOutNodeId(), userInputMapper.getOutVarName());
            userInput = FlowUtils.getVarValue(this.context, outVarName, e, parallelIndex);
        } else {
            Object obj = inputMap.get("0.system.user_input");
            String string = userInput = obj != null ? obj.toString() : "";
        }
        if (StringUtils.isEmpty((String)userInput)) {
            userInput = "";
        }
        return userInput;
    }

    public String fillVariable(String template, Map<String, String> variableMap) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)template) || variableMap == null || variableMap.isEmpty()) {
            return template;
        }
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            template = org.apache.commons.lang3.StringUtils.replace((String)template, (String)("{{" + key + "}}"), (String)value);
        }
        return template;
    }
}

