/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.RecommendAction;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.RecommendNodeMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMActionCallbackMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.helper.KmServiceHelper;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.DataArea;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RecommendNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(RecommendNodeApplication.class);
    public static final String READ_QA_REPO = RecommendAction.GenerateWay.QA.getValue();
    public static final String GENERATE_BY_LLM = RecommendAction.GenerateWay.LLM.getValue();
    public static final String SUCCESS_CODE = "0";
    public static final String XML_PREFIX = "<questions>";
    public static final String XML_SUFFIX = "</questions>";
    private static final String PROMPT_TEMPLATE = "##\u8bf7\u6839\u636e\u7528\u6237\u672c\u6b21\u7684\u63d0\u95ee: {{userInput}} ,\u4ee5\u53ca\u56de\u7b54\u7528\u6237\u63d0\u95ee\u65f6\u7528\u5230\u7684\u77e5\u8bc6: {{chunkList}} \u6765\u751f\u6210{{generateNum}}\u4e2a\u7528\u6237\u6700\u60f3\u95ee\u4e14\u6839\u636e\u77e5\u8bc6\u4f60\u53ef\u4ee5\u56de\u7b54\u7684\u95ee\u9898\n##\u8981\u6c42:\u8fd4\u56de\u7684\u95ee\u9898\u683c\u5f0f\u5982\u4e0b\u793a\u4f8b\u4e2d\u7684XML\u683c\u5f0f\n##\u8fd4\u56de\u95ee\u9898\u793a\u4f8b\n<questions>\n    <q1>\u95ee\u98981</q1>\n    <q2>\u95ee\u98982</q2>\n    <q3>\u95ee\u98983</q3>\n</questions>";
    public static final Float DEFAULT_SIMILARITY = Float.valueOf(0.3f);
    private final Context context;
    private final Flow gaiFlow;
    private final RecommendAction action;

    public RecommendNodeApplication(Context context, Flow gaiFlow, RecommendAction action) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        this.pushRecommendQuestion(e);
    }

    private void pushRecommendQuestion(Execution execution) {
        log.info("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u5f00\u59cb");
        Boolean enable = this.action.getEnable();
        if (!enable.booleanValue()) {
            log.info("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u672a\u5f00\u542f\u95ee\u9898\u63a8\u8350");
            return;
        }
        DataArea memory = execution.getMemory();
        String userInput = (String)memory.getProperty("VAR_VALUE_0.system.user_input");
        int generateNum = this.action.getGenerateNum();
        String generateWay = this.action.getGenerateWay();
        RecommendNodeMessage message = RecommendNodeMessage.buildMessageByAction(this.action);
        ArrayList questionMapList = Lists.newArrayListWithExpectedSize((int)generateNum);
        long startMs = System.currentTimeMillis();
        if (StringUtils.equals((CharSequence)generateWay, (CharSequence)READ_QA_REPO)) {
            Float similarity;
            List<Long> repoIdList = this.action.getRepoIdList();
            JSONArray resultJsonArr = this.requestKmService(userInput, repoIdList, (similarity = (similarity = this.action.getSimilarity()) == null ? DEFAULT_SIMILARITY : similarity).floatValue(), generateNum);
            if (resultJsonArr == null || resultJsonArr.isEmpty()) {
                log.info("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u8bf7\u6c42AiKM\u670d\u52a1\u672a\u83b7\u53d6\u5230\u53ef\u63a8\u8350\u7684\u95ee\u9898");
            } else {
                for (int i = 0; i < resultJsonArr.size(); ++i) {
                    JSONObject resultJsonObj = resultJsonArr.getJSONObject(i);
                    HashMap<String, Object> questionMap = new HashMap<String, Object>(16);
                    questionMap.put("id", resultJsonObj.getString("chunkId") + resultJsonObj.getString("order"));
                    questionMap.put("sort", resultJsonObj.getIntValue("order"));
                    try {
                        JSONObject chunkJsonObj = resultJsonObj.getJSONObject("chunk");
                        String question = chunkJsonObj.getString("Q");
                        questionMap.put("question", question);
                    }
                    catch (Exception e) {
                        String chunk = resultJsonObj.getString("chunk");
                        log.error("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u4eceAiKM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u7684chunk\u4e2d\u89e3\u6790\u83b7\u53d6\u95ee\u9898\u5185\u5bb9\u5f02\u5e38,\u76f4\u63a5\u4f7f\u7528chunk\u5185\u5bb9,chunk:[{}]", (Object)chunk, (Object)e);
                        questionMap.put("question", chunk);
                    }
                    questionMap.put("source", READ_QA_REPO);
                    questionMapList.add(questionMap);
                }
            }
            HashMap bizResult = Maps.newHashMapWithExpectedSize((int)1);
            bizResult.put("QA\u5e93\u68c0\u7d22\u5230\u7684\u95ee\u9898", ((Object)questionMapList).toString());
            this.saveTraceLog(this.context, this.gaiFlow, this.action, message, startMs, bizResult);
        } else if (StringUtils.equals((CharSequence)generateWay, (CharSequence)GENERATE_BY_LLM)) {
            List<String> questionList;
            String llmNumber = this.action.getLlmNumber();
            String userPrompt = this.action.getUserPrompt();
            List<JSONArray> chunkList = this.getFlowAllRepoNodeOutput(this.gaiFlow.getActions(), memory);
            try {
                questionList = this.getQuestionListByLlm(llmNumber, userPrompt, chunkList, userInput, generateNum);
            }
            catch (Exception e) {
                log.error("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u8bf7\u6c42\u5927\u6a21\u578b\u83b7\u53d6\u63a8\u8350\u95ee\u9898\u5f02\u5e38", (Throwable)e);
                return;
            }
            if (questionList == null || questionList.isEmpty()) {
                log.info("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u8bf7\u6c42\u5927\u6a21\u578b\u672a\u83b7\u53d6\u5230\u53ef\u63a8\u8350\u7684\u95ee\u9898");
                return;
            }
            for (int i = 0; i < questionList.size(); ++i) {
                HashMap<String, Object> questionMap = new HashMap<String, Object>(16);
                questionMap.put("id", RandomUtils.nextLong());
                questionMap.put("sort", i + 1);
                questionMap.put("question", questionList.get(i));
                questionMap.put("source", GENERATE_BY_LLM);
                questionMapList.add(questionMap);
            }
            HashMap bizResult = Maps.newHashMapWithExpectedSize((int)1);
            bizResult.put("\u5927\u6a21\u578b\u751f\u6210\u7684\u95ee\u9898", ((Object)questionMapList).toString());
            this.saveTraceLog(this.context, this.gaiFlow, this.action, message, startMs, bizResult);
        }
        if (CollectionUtils.isNotEmpty((Collection)questionMapList)) {
            PushMsgService.pushRecommendQuestion(this.context, questionMapList);
        }
    }

    private List<String> getQuestionListByLlm(String llmNumber, String userPrompt, List<JSONArray> chunkList, String userInput, int generateNum) {
        Prompt prompt = this.buildPrompt(llmNumber);
        LLMMessage llmMessage = this.buildLlmMessage(userPrompt, chunkList, userInput, generateNum, prompt);
        Result result = HandlerFactory.runHandler(this.context, llmMessage);
        if (result == null || result.getErrorCode() == null) {
            log.error("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u5927\u6a21\u578b\u751f\u6210\u63a8\u8350\u95ee\u9898,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            return null;
        }
        if (!StringUtils.equals((CharSequence)result.getErrorCode().getCode(), (CharSequence)SUCCESS_CODE)) {
            log.error("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u5927\u6a21\u578b\u751f\u6210\u63a8\u8350\u95ee\u9898,\u8fd4\u56de\u7ed3\u679c\u5931\u8d25,\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JSON.toJSONString((Object)result));
            throw new KDBizException("\u5927\u6a21\u578b\u751f\u6210\u63a8\u8350\u95ee\u9898\u5931\u8d25:" + result.getErrorCode().getMessage());
        }
        try {
            Map<String, String> llmResultData = result.getData();
            String llmValue = llmResultData.get("llmValue");
            return this.readXmlLlmValue(llmValue);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u5927\u6a21\u578b\u751f\u6210\u63a8\u8350\u95ee\u9898,\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JSON.toJSONString((Object)result), (Object)e);
            throw new KDBizException("\u5927\u6a21\u578b\u751f\u6210\u63a8\u8350\u95ee\u9898\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38");
        }
    }

    public List<String> readXmlLlmValue(String xmlString) {
        String formatXmlStr = XML_PREFIX + StringUtils.substringAfter((String)xmlString, (String)XML_PREFIX);
        formatXmlStr = StringUtils.substringBefore((String)formatXmlStr, (String)XML_SUFFIX) + XML_SUFFIX;
        ArrayList<String> questionList = new ArrayList<String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(formatXmlStr));
            Document doc = builder.parse(inputSource);
            NodeList questions = doc.getElementsByTagName("questions").item(0).getChildNodes();
            for (int i = 0; i < questions.getLength(); ++i) {
                Node node = questions.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String questionText = element.getTextContent().trim();
                questionList.add(questionText);
            }
        }
        catch (Exception e) {
            log.error("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u5927\u6a21\u578b\u751f\u6210\u63a8\u8350\u95ee\u9898,\u5927\u6a21\u578b\u8fd4\u56deXML\u683c\u5f0f\u7ed3\u679c\u89e3\u6790\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c:[{}],\u683c\u5f0f\u5316\u540e:[{}]", new Object[]{xmlString, formatXmlStr, e});
            throw new KDBizException("\u5927\u6a21\u578b\u8fd4\u56deXML\u683c\u5f0f\u7ed3\u679c\u89e3\u6790\u5f02\u5e38");
        }
        return questionList;
    }

    private LLMMessage buildLlmMessage(String userPrompt, List<JSONArray> chunkList, String userInput, int generateNum, Prompt prompt) {
        HashSet<String> chunkStrSet = new HashSet<String>(20);
        for (JSONArray chunkJsonArr : chunkList) {
            for (int i = 0; i < chunkJsonArr.size(); ++i) {
                JSONObject chunkJsonObj = chunkJsonArr.getJSONObject(i);
                String chunkStr = chunkJsonObj.getString("chunk");
                chunkStrSet.add(chunkStr);
            }
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        paramMap.put("userInput", userInput);
        paramMap.put("chunkList", ((Object)chunkStrSet).toString());
        paramMap.put("generateNum", String.valueOf(generateNum));
        LLMActionCallbackMessage callbackMessage = new LLMActionCallbackMessage();
        callbackMessage.setFlowId(this.gaiFlow.getId());
        callbackMessage.setNodeId(this.action.getId());
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setUserInput(userPrompt);
        llmMessage.setPrompt(prompt);
        llmMessage.setSync(true);
        llmMessage.setStream(false);
        llmMessage.setParamMap(paramMap);
        llmMessage.setCallbackMessage(callbackMessage);
        return llmMessage;
    }

    private Prompt buildPrompt(String serviceNumber) {
        LLM llm;
        Map<String, Object> service = AiccService.queryLlmAiccService(serviceNumber);
        if (service == null || service.isEmpty()) {
            throw new KDBizException(Errors.NO_AICC_SERVICE, new Object[0]);
        }
        String llmNumber = (String)service.get("llm");
        if (StringUtils.isBlank((CharSequence)llmNumber)) {
            llmNumber = serviceNumber;
        }
        if ((llm = LLM.parse(llmNumber)) == null) {
            throw new KDBizException(Errors.NO_LLM_4_AICC_SERVICE(llmNumber), new Object[0]);
        }
        Prompt prompt = new Prompt();
        prompt.setId(2002989110637102080L);
        prompt.setServiceNumber(serviceNumber);
        prompt.setLlm(llm);
        prompt.setRemembercount(0);
        prompt.setLlmStyle(LlmStyle.PRECISION);
        prompt.setPrompt(PROMPT_TEMPLATE);
        prompt.setReference(false);
        return prompt;
    }

    private List<JSONArray> getFlowAllRepoNodeOutput(List<Action> actionList, DataArea memory) {
        ArrayList<JSONArray> chunkList = new ArrayList<JSONArray>(20);
        for (Action action : actionList) {
            if (!(action instanceof RepoAction)) continue;
            int repoNodeId = action.getId();
            String chunkOutput = (String)memory.getProperty("VAR_VALUE_" + repoNodeId + ".outputList");
            if (StringUtils.isBlank((CharSequence)chunkOutput)) continue;
            JSONArray chunkJsonArr = JSON.parseArray((String)chunkOutput);
            chunkList.add(chunkJsonArr);
        }
        return chunkList;
    }

    private JSONArray requestKmService(String query, List<Long> repoIdList, float similarity, int topK) {
        try {
            return KmServiceHelper.retrieval(query, repoIdList, "Q_CONTENT_ONLY", topK, similarity, false, null);
        }
        catch (Exception e) {
            log.error("<\u4efb\u52a1\u6d41\u95ee\u9898\u63a8\u8350>\u8bf7\u6c42AiKM\u670d\u52a1\u83b7\u53d6\u63a8\u8350\u95ee\u9898\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

