/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.repo.GaiRepoSearchData;
import kd.ai.gai.core.domain.mservice.GaiRagSearchParams;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RetrievalConfig;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.message.RepoMessage;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.helper.KmServiceHelper;
import kd.ai.gai.core.rag.service.RagService;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.search.helper.StructuredRepoServiceHelper;
import kd.ai.gai.core.search.index.param.structured.QureyStructuredNodeDataParam;
import kd.ai.gai.core.search.index.param.structured.SearchStructuredDataParam;
import kd.ai.gai.core.search.index.param.structured.StructuredNodeData;
import kd.ai.gai.core.search.index.param.structured.StructuredRowData;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RepoNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(RepoNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private RepoAction action;
    private int parallelIndex;

    public RepoNodeApplication(Context context, Flow gaiFlow, RepoAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        log.info("RepoHandler process");
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        if (Context.needCheckLicense(this.context)) {
            log.info("\u77e5\u8bc6\u5e93\u8282\u70b9\u68c0\u7d22\u8bb8\u53ef\u68c0\u67e5-\u5f00\u59cb");
            GPTLicenseHelper.checkLic("ai_gai_reporag", 0L);
            log.info("\u77e5\u8bc6\u5e93\u8282\u70b9\u68c0\u7d22\u8bb8\u53ef\u68c0\u67e5-\u5b8c\u6210");
        }
        RepoMessage message = this.buildRepoMessage(this.context, this.gaiFlow, this.action, e, this.parallelIndex);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        List<String> universalIdStrList = message.getUniversalIdList();
        String rerankModelNumber = message.getRerankModelNumber();
        String repoType = message.getRepoType();
        String requestType = message.getRequestType();
        if (StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
            GaiRagSearchParams searchParams = new GaiRagSearchParams(message.getRepoIdList(), message.getTopK(), message.getSimilarity(), message.getQuery(), message.getRequestType(), message.isReRank());
            List<GaiRepoSearchData> searchDataList = RagService.retrievalComponent(this.context, searchParams);
            String searchDataJsonStr = JSON.toJSONString(searchDataList);
            dataMap.put("outputList", searchDataJsonStr);
            log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u6587\u6863\u578b\u77e5\u8bc6\u5e93\u68c0\u7d22,\u53c2\u6570:[{}],\u68c0\u7d22\u7ed3\u679c:[{}]", JSON.toJSON((Object)searchParams), (Object)searchDataJsonStr);
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"structure")) {
            SearchStructuredDataParam searchParams = new SearchStructuredDataParam(message.getStructureId(), message.getQuery(), message.getTopK(), message.getSimilarity(), message.isReRank());
            StructuredRowData searchResult = StructuredRepoServiceHelper.search(searchParams);
            log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u68c0\u7d22,\u53c2\u6570:[{}],\u68c0\u7d22\u7ed3\u679c:[{}]", JSON.toJSON((Object)searchParams), (Object)JSON.toJSONString((Object)searchResult));
            List<Map<String, Object>> dataList = searchResult.getDataList();
            if (dataList == null || dataList.isEmpty()) {
                dataMap.put("outputList", "[]");
            } else if (searchResult.getType().equals(RepoConstant.RepoType.LEVEL.getType())) {
                ArrayList<Long> dataIdList = new ArrayList<Long>(10);
                for (Map<String, Object> item : dataList) {
                    Object idO;
                    if (item == null || (idO = item.get("id")) == null) continue;
                    dataIdList.add(Long.parseLong(idO + ""));
                }
                QureyStructuredNodeDataParam param = new QureyStructuredNodeDataParam(message.getStructureId(), dataIdList);
                List<StructuredNodeData> structuredNodeData = StructuredRepoServiceHelper.queryNodeData(param);
                dataMap.put("outputList", JSON.toJSONString(structuredNodeData));
            } else {
                dataMap.put("outputList", JSON.toJSONString(dataList));
            }
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
            GaiRagSearchParams searchParams = new GaiRagSearchParams(message.getRepoIdList(), message.getTopK(), message.getSimilarity(), message.getQuery(), message.getRequestType(), message.isReRank());
            List<GaiRepoSearchData> searchDataList = RagService.retrievalComponent(this.context, searchParams);
            String searchDataJsonStr = JSON.toJSONString(searchDataList);
            dataMap.put("outputList", searchDataJsonStr);
            log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u52a8\u6001\u77e5\u8bc6\u5e93(\u6587\u6863\u578b)\u68c0\u7d22,\u53c2\u6570:[{}],\u68c0\u7d22\u7ed3\u679c:[{}]", JSON.toJSON((Object)searchParams), (Object)searchDataJsonStr);
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"meta")) {
            JSONObject paramJsonObj = new JSONObject();
            paramJsonObj.put("query", (Object)message.getQuery());
            paramJsonObj.put("entityIds", message.getMetaIdList());
            paramJsonObj.put("searchType", (Object)message.getRequestType());
            paramJsonObj.put("topK", (Object)message.getTopK());
            paramJsonObj.put("threshold", (Object)Float.valueOf(message.getSimilarity()));
            paramJsonObj.put("rerank", (Object)message.isReRank());
            Map resultMap = (Map)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"RetrievalService", (String)"retrieval", (Object[])new Object[]{paramJsonObj.toJSONString()});
            log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u5143\u6a21\u578b\u77e5\u8bc6\u5e93\u68c0\u7d22,\u53c2\u6570:[{}],\u68c0\u7d22\u7ed3\u679c:[{}]", JSON.toJSON((Object)paramJsonObj), (Object)JSON.toJSONString((Object)resultMap));
            List results = (List)resultMap.get("results");
            dataMap.put("outputList", JSON.toJSONString((Object)results));
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"universal")) {
            List<Long> universalIdList = universalIdStrList.stream().map(Long::valueOf).collect(Collectors.toList());
            JSONArray resultJsonArr = KmServiceHelper.retrieval(message.getQuery(), universalIdList, requestType, message.getTopK(), message.getSimilarity(), message.isReRank(), rerankModelNumber);
            if (CollectionUtils.isEmpty((Collection)resultJsonArr) && (StringUtils.equals((CharSequence)requestType, (CharSequence)"Q_ONLY") || StringUtils.equals((CharSequence)requestType, (CharSequence)"QA_ONLY"))) {
                log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u901a\u7528\u77e5\u8bc6\u5e93\u68c0\u7d22,\u4e8c\u6b21\u4f7f\u7528TEXT\u68c0\u7d22");
                resultJsonArr = KmServiceHelper.retrieval(message.getQuery(), universalIdList, "TEXT_QA", message.getTopK(), 0.0f, message.isReRank(), rerankModelNumber);
            }
            String resJsonStr = resultJsonArr.toJSONString();
            log.info("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u901a\u7528\u77e5\u8bc6\u5e93\u68c0\u7d22,\u53c2\u6570:[query:{},universalIdList:{},requestType:{},topK:{},similarity:{},rerank:{},rerankModelNumber:{}],\u68c0\u7d22\u7ed3\u679c:[{}]", new Object[]{message.getQuery(), universalIdList, requestType, message.getTopK(), Float.valueOf(message.getSimilarity()), message.isReRank(), rerankModelNumber, resJsonStr});
            dataMap.put("outputList", resJsonStr);
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic_universal")) {
            JSONArray universalDyRepoJsonArr = message.getUniversalDyRepoInfo();
            if (CollectionUtils.isEmpty((Collection)universalDyRepoJsonArr)) {
                log.error("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u52a8\u6001\u77e5\u8bc6\u5e93(\u901a\u7528\u578b),\u77e5\u8bc6\u5e93\u4fe1\u606f\u4e3a\u7a7a");
                throw new KDBizException(Errors.REPO_ID_CONVERT_ERROR, new Object[0]);
            }
            ArrayList repoList = Lists.newArrayListWithExpectedSize((int)universalDyRepoJsonArr.size());
            for (int i = 0; i < universalDyRepoJsonArr.size(); ++i) {
                JSONObject repoJsonObj = universalDyRepoJsonArr.getJSONObject(i);
                Long repoId = repoJsonObj.getLong("ukmId");
                HashMap repoMap = Maps.newHashMapWithExpectedSize((int)2);
                repoMap.put("k", repoId);
                JSONArray groupNumberJsonArr = repoJsonObj.getJSONArray("groupNumber");
                if (CollectionUtils.isNotEmpty((Collection)groupNumberJsonArr)) {
                    String[] groupArr = new String[groupNumberJsonArr.size()];
                    for (int j = 0; j < groupNumberJsonArr.size(); ++j) {
                        groupArr[j] = groupNumberJsonArr.getString(j);
                    }
                    repoMap.put("g", groupArr);
                }
                repoList.add(repoMap);
            }
            JSONArray resultJsonArr = KmServiceHelper.retrievalWithGroup(message.getQuery(), repoList, requestType, message.getTopK(), message.getSimilarity(), message.isReRank(), rerankModelNumber);
            if (CollectionUtils.isEmpty((Collection)resultJsonArr) && (StringUtils.equals((CharSequence)requestType, (CharSequence)"Q_ONLY") || StringUtils.equals((CharSequence)requestType, (CharSequence)"QA_ONLY"))) {
                resultJsonArr = KmServiceHelper.retrievalWithGroup(message.getQuery(), repoList, "TEXT_QA", message.getTopK(), 0.0f, message.isReRank(), rerankModelNumber);
            }
            String resJsonStr = resultJsonArr.toJSONString();
            log.info("<<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u52a8\u6001\u77e5\u8bc6\u5e93(\u901a\u7528\u578b)\u68c0\u7d22,\u53c2\u6570:[query:{},repoList:{},requestType:{},topK:{},similarity:{},rerank:{},rerankModelNumber:{}],\u68c0\u7d22\u7ed3\u679c:[{}]", new Object[]{message.getQuery(), JSON.toJSONString((Object)repoList), requestType, message.getTopK(), Float.valueOf(message.getSimilarity()), message.isReRank(), rerankModelNumber, resJsonStr});
            dataMap.put("outputList", resJsonStr);
        } else {
            throw new KDBizException(Errors.notSupportRepoType(repoType), new Object[0]);
        }
        FlowUtils.setNodeProperties(e, this.action.getId(), dataMap);
        this.action.setName(e.getDefine().getTitle());
        this.saveTraceLog(this.context, this.gaiFlow, this.action, message, start, dataMap);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }

    public RepoMessage buildRepoMessage(Context context, Flow flow, RepoAction repoAction, Execution e, int parallelIndex) {
        RepoMessage message = new RepoMessage();
        List<VarMapper> inParamMap = repoAction.getInParamMap();
        if (inParamMap != null && !inParamMap.isEmpty()) {
            VarMapper inParam = repoAction.getInParamMap().get(0);
            String query = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(inParam.getOutNodeId(), inParam.getOutVarName()), e, parallelIndex);
            message.setQuery(query);
        }
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(repoAction.getId());
        String repoType = repoAction.getRepoType();
        message.setRepoType(repoType);
        List<Long> repoList = new ArrayList<Long>();
        if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
            repoList = this.getDyRepoIdList(context, repoAction, e, parallelIndex);
        } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"select") && this.action.getRepoList() != null) {
            repoList = this.action.getRepoList();
        }
        message.setRepoIdList(repoList);
        if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic_universal")) {
            JSONArray jsonArr = this.getUniversalDyRepoIdList(context, repoAction, e, parallelIndex);
            message.setUniversalDyRepoInfo(jsonArr);
        }
        message.setStructureId(repoAction.getStructureId());
        message.setUniversalIdList(repoAction.getUniversalIdList());
        message.setMetaIdList(repoAction.getMetaIdList());
        message.setReRank(repoAction.isReRank());
        RetrievalConfig retrievalConfig = repoAction.getRetrievalConfig();
        if (retrievalConfig != null) {
            message.setSimilarity(retrievalConfig.getSimilarity());
            String mode = retrievalConfig.getMode();
            if ("TEXT_QA".equals(mode)) {
                message.setSimilarity(0.0f);
            }
            message.setRerankModelNumber(retrievalConfig.getRerankModelNumber());
            message.setTopK(retrievalConfig.getTopK());
            message.setRequestType(mode);
        }
        return message;
    }

    private List<Long> getDyRepoIdList(Context context, RepoAction action, Execution execution, int parallelIndex) {
        ArrayList<Long> repoList = new ArrayList<Long>();
        VarMapper varMapper = action.getRepoMapper();
        if (varMapper == null || varMapper.getOutVarName() == null) {
            return repoList;
        }
        String outVarName = varMapper.getOutVarName();
        try {
            String vars = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(varMapper.getOutNodeId(), outVarName), execution, parallelIndex);
            List dyRepoList = Arrays.stream(vars.split(",")).map(Long::parseLong).collect(Collectors.toList());
            repoList.addAll(dyRepoList);
        }
        catch (Exception e) {
            log.error("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u52a8\u6001\u77e5\u8bc6\u5e93(\u6587\u6863\u578b),\u83b7\u53d6\u77e5\u8bc6\u5e93ID\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(Errors.REPO_ID_CONVERT_ERROR, new Object[0]);
        }
        return repoList;
    }

    private JSONArray getUniversalDyRepoIdList(Context context, RepoAction action, Execution execution, int parallelIndex) {
        VarMapper varMapper = action.getUniversalRepoMapper();
        if (varMapper == null || varMapper.getOutVarName() == null) {
            return null;
        }
        String outVarName = varMapper.getOutVarName();
        try {
            String vars = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(varMapper.getOutNodeId(), outVarName), execution, parallelIndex);
            return JSONArray.parseArray((String)vars);
        }
        catch (Exception e) {
            log.error("<\u4efb\u52a1\u6d41-\u77e5\u8bc6\u5e93\u68c0\u7d22\u8282\u70b9>\u52a8\u6001\u77e5\u8bc6\u5e93(\u901a\u7528\u578b),\u83b7\u53d6\u77e5\u8bc6\u5e93\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(Errors.REPO_ID_CONVERT_ERROR, new Object[0]);
        }
    }
}

