/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.chat.ChatHistoryMessage;
import kd.ai.gai.core.domain.dto.Chunks4LLMItem;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.RepoReplyConfig;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.RepoReplyCallbackMessage;
import kd.ai.gai.core.engine.message.RepoReplyMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.flow.application.PromptNodeApplication;
import kd.ai.gai.core.flow.callback.RepoReplyNodeCallback;
import kd.ai.gai.core.memory.ChatMemoryService;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class RepoReplyNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(RepoReplyNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private RepoReplyAction action;
    private int parallelIndex;

    public RepoReplyNodeApplication(Context context, Flow gaiFlow, RepoReplyAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        LLM llm;
        log.info("RepoReplyHandler process");
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        RepoReplyMessage message = this.buildRepoReplyMessage(this.context, this.gaiFlow, this.action, e, this.parallelIndex);
        RepoReplyConfig repoReplyConfig = message.getRepoReplyConfig();
        String serviceNumber = repoReplyConfig.getLlm();
        RepoReplyCallbackMessage repoReplyCallbackMessage = new RepoReplyCallbackMessage();
        repoReplyCallbackMessage.setErrCode(Errors.OK.getCode());
        repoReplyCallbackMessage.setParseOutput(false);
        repoReplyCallbackMessage.setFlowId(message.getFlowId());
        repoReplyCallbackMessage.setNodeId(message.getNodeId());
        repoReplyCallbackMessage.setPageId(this.context.getAssistantPageId());
        repoReplyCallbackMessage.setChatSessionId(this.context.getChatSessionId());
        repoReplyCallbackMessage.setGlobalSessionId(this.context.getGlobalSessionId());
        repoReplyCallbackMessage.setShowMessage(repoReplyConfig.isShowMessage());
        repoReplyCallbackMessage.setStartTs(start);
        if (this.action.isBlockInnerNode() && this.gaiFlow.findNodeById(this.action.getBlockNodeId()).isParallelBlockNode()) {
            message.setSync(true);
        }
        FlowRuntime runtime = e.getRuntime();
        Map runtimeDoc = runtime.toJson();
        repoReplyCallbackMessage.setRuntimeDoc(runtimeDoc);
        repoReplyCallbackMessage.setMemoryProperties(JsonUtil.toJson(e.getMemory().getProperties()));
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(repoReplyCallbackMessage);
        Map<String, String> varMap = repoReplyConfig.getVarMap();
        Prompt prompt = new Prompt();
        prompt.setId(2002989110637102080L);
        prompt.setServiceNumber(serviceNumber);
        Map<String, Object> service = AiccService.queryLlmAiccService(serviceNumber);
        if (service == null || service.isEmpty()) {
            throw new KDBizException(Errors.NO_AICC_SERVICE, new Object[0]);
        }
        String llmNumber = (String)service.get("llm");
        if (StringUtils.isEmpty((String)llmNumber)) {
            llmNumber = serviceNumber;
        }
        if ((llm = LLM.parse(llmNumber)) == null) {
            throw new KDBizException(Errors.NO_LLM_4_AICC_SERVICE(llmNumber), new Object[0]);
        }
        BigDecimal rememberCount = repoReplyConfig.getRememberCount();
        String chatSessionId = message.getChatSessionId();
        prompt.setLlm(llm);
        prompt.setRemembercount(0);
        prompt.setLlmStyle(LlmStyle.PRECISION);
        prompt.setPrompt(repoReplyConfig.getSysPrompt());
        prompt.setReference(repoReplyConfig.isReference());
        prompt.setChunkIdList(this.chunkList2IdList(varMap));
        String userPrompt = repoReplyConfig.getUserPrompt();
        log.info("varMap : {}", varMap);
        Map<String, String> paramMap = this.chunkList2LLMList(varMap);
        log.info("paramMap : {}", paramMap);
        String filledUserPrompt = this.fillVariable(userPrompt, paramMap);
        String filledSysPrompt = this.fillVariable(prompt.getPrompt(), varMap);
        prompt.setPrompt(filledSysPrompt);
        boolean enableChatMsg = repoReplyConfig.isEnableChatMsg();
        if (enableChatMsg) {
            List<UserHistoryMessage> chatSessionHistory = ChatMemoryService.getChatSessionHistory(chatSessionId, enableChatMsg, rememberCount == null ? 1 : rememberCount.intValue());
            List<ChatHistoryMessage> chatHistoryMessages = ChatMemoryService.chatMsgCoversion(chatSessionHistory);
            if (chatSessionHistory != null && !chatSessionHistory.isEmpty()) {
                filledUserPrompt = String.format("%s\n#\u5386\u53f2\u6d88\u606f:%s", filledUserPrompt, JsonUtil.toJson(chatHistoryMessages));
            }
        }
        llmMessage.setUserInput(filledUserPrompt);
        llmMessage.setPrompt(prompt);
        llmMessage.setStream(message.isStream());
        llmMessage.setParamMap(paramMap);
        llmMessage.setSync(message.isSync());
        Result result = HandlerFactory.runHandler(this.context, llmMessage);
        result.setCallback(!message.isSync());
        if (message.isSync()) {
            PromptNodeApplication.syncCallback(result, repoReplyCallbackMessage);
            new RepoReplyNodeCallback().inject(runtime.getLastExecution(), repoReplyCallbackMessage);
        }
    }

    public RepoReplyMessage buildRepoReplyMessage(Context context, Flow flow, RepoReplyAction repoReplyAction, Execution e, int parallelIndex) {
        RepoReplyMessage message = new RepoReplyMessage();
        RepoReplyConfig repoReplyConfig = repoReplyAction.getRepoReplyConfig();
        Map<String, String> varMap = FlowUtils.buildInputData(context, repoReplyAction, e, parallelIndex);
        String userInput = this.getUserInput(e);
        repoReplyConfig.setUserInput(userInput);
        repoReplyConfig.setVarMap(varMap);
        message.setRepoReplyConfig(repoReplyConfig);
        message.setChatSessionId(context.getChatSessionId());
        message.setFlowId(flow.getId());
        message.setNodeId(repoReplyAction.getId());
        return message;
    }

    public Map<String, String> chunkList2LLMList(Map<String, String> chunkMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (chunkMap == null || chunkMap.isEmpty()) {
            return resultMap;
        }
        ArrayList cachedItemList = new ArrayList();
        chunkMap.forEach((key, value) -> {
            ArrayList<Chunks4LLMItem> varItemList = new ArrayList<Chunks4LLMItem>();
            boolean validJSONArray = StrUtils.isValidJSONArray(value);
            log.info("chunkList2LLMList.validJSONArray? {}", (Object)validJSONArray);
            if (validJSONArray) {
                JSONArray chunkJa = JSON.parseArray((String)value);
                if (chunkJa != null && !chunkJa.isEmpty()) {
                    for (int i = 0; i < chunkJa.size(); ++i) {
                        Object o = chunkJa.get(i);
                        if (!(o instanceof JSONObject)) continue;
                        JSONObject item = (JSONObject)o;
                        if (item.containsKey((Object)"needCached") && item.getBoolean("needCached").booleanValue()) {
                            cachedItemList.add(item);
                        }
                        if (!item.containsKey((Object)"chunkId") || !item.containsKey((Object)"chunk")) continue;
                        Chunks4LLMItem chunks4LLMItem = new Chunks4LLMItem(item.getLong("chunkId"), item.getString("chunk"));
                        varItemList.add(chunks4LLMItem);
                    }
                }
                if (!varItemList.isEmpty()) {
                    resultMap.put((String)key, JSON.toJSONString(varItemList));
                } else {
                    resultMap.put((String)key, (String)value);
                }
            } else {
                resultMap.put((String)key, (String)value);
            }
        });
        resultMap.put("cachedItems-" + this.context.getChatSessionId(), cachedItemList.isEmpty() ? "" : JSON.toJSONString(cachedItemList));
        return resultMap;
    }

    public List<Long> chunkList2IdList(Map<String, String> chunkMap) {
        ArrayList<Long> resultArr = new ArrayList<Long>();
        if (chunkMap == null || chunkMap.isEmpty()) {
            return resultArr;
        }
        chunkMap.forEach((key, value) -> {
            JSONArray chunkJa;
            if (StrUtils.isValidJSONArray(value) && (chunkJa = JSON.parseArray((String)value)) != null && !chunkJa.isEmpty()) {
                for (int i = 0; i < chunkJa.size(); ++i) {
                    JSONObject item;
                    Object o = chunkJa.get(i);
                    if (!(o instanceof JSONObject) || !(item = (JSONObject)o).containsKey((Object)"chunkId")) continue;
                    resultArr.add(item.getLong("chunkId"));
                }
            }
        });
        return resultArr;
    }

    public String fillVariable(String template, Map<String, String> variableMap) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)template) || variableMap == null || variableMap.isEmpty()) {
            return template;
        }
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            template = org.apache.commons.lang3.StringUtils.replace((String)template, (String)("{{" + key + "}}"), (String)value);
        }
        return template;
    }
}

