/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.SetVarMapper;
import kd.ai.gai.core.engine.flow.SetVariableAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SetVariableNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(SetVariableNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private SetVariableAction action;

    public SetVariableNodeApplication(Context context, Flow gaiFlow, SetVariableAction action) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        String loopIndexVar = String.format("%s_%s", "loopIndex", this.action.getBlockNodeId());
        int loopIndex = (Integer)e.get(loopIndexVar);
        List<SetVarMapper> setParamMap = this.action.getSetParamMap();
        if (setParamMap != null && !setParamMap.isEmpty()) {
            setParamMap.forEach(setParam -> {
                LoopAction loopAction = (LoopAction)this.gaiFlow.findActionById(setParam.getInNodeId());
                List<Var> loopVarList = loopAction.getLoopVarList();
                Map loopVarMap = Optional.ofNullable(loopVarList).map(map -> map.stream().collect(Collectors.toMap(Var::getName, Function.identity(), (key1, key2) -> key2))).orElseGet(HashMap::new);
                Var inVar = (Var)loopVarMap.get(setParam.getInVarName());
                String outPropertyName = FlowUtils.getPropertyName(setParam.getOutNodeId(), setParam.getOutVarName());
                Object targetValue = FlowUtils.getVarValue(this.context, outPropertyName, e, inVar.getVarFieldType());
                FlowUtils.setNodeProperty(e, setParam.getInNodeId(), setParam.getInVarName(), targetValue);
            });
        }
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }
}

