/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.StartLoopAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VirtualAction;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class StartLoopNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(StartLoopNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private StartLoopAction action;

    public StartLoopNodeApplication(Context context, Flow gaiFlow, StartLoopAction action) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        log.info("NOP : actionId:{} actionName:{}", (Object)this.action.getId(), (Object)this.action.getName());
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        int blockNodeId = this.action.getBlockNodeId();
        String loopIndexVar = String.format("%s_%s", "loopIndex", blockNodeId);
        int loopIndex = (Integer)e.get(loopIndexVar);
        LoopAction loopAction = (LoopAction)this.gaiFlow.findActionById(blockNodeId);
        HashMap<String, String> bizResult = new HashMap<String, String>();
        bizResult.put("loopIndex", String.valueOf(loopIndex));
        List<Var> varList = loopAction.getVarList();
        if (varList != null && !varList.isEmpty()) {
            varList.forEach(var -> {
                FlowUtils.setNodeProperty(e, blockNodeId, String.format("%s.%s", var.getName(), "{{index}}"), loopIndex);
                String varValue = FlowUtils.getVarValue(this.context, FlowUtils.getPropertyName(this.action.getBlockNodeId(), var.getName()), e);
                bizResult.put(var.getName(), varValue);
            });
        }
        VirtualAction virtualAction = new VirtualAction(this.action.getId(), String.format("%s(index-%s)", e.getDefine().getTitle(), loopIndex));
        this.saveTraceLog(this.context, this.gaiFlow, virtualAction, null, start, bizResult);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }
}

