/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class StartNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(StartNodeApplication.class);
    private Context context;
    private Flow gaiFlow;

    public StartNodeApplication(Context context, Flow gaiFlow) {
        this.context = context;
        this.gaiFlow = gaiFlow;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long startTs = System.currentTimeMillis();
        Start startAction = this.gaiFlow.getStart();
        StartFlowMessage startFlowMessage = (StartFlowMessage)JSONObject.parseObject((String)((String)e.get("startFlowMessage")), StartFlowMessage.class);
        Map<String, String> inParams = this.initInParams(startFlowMessage, startAction);
        FlowUtils.setNodeProperties(e, this.gaiFlow.getStart().getId(), inParams);
        PushMsgService.pushWaiting(this.context, this.gaiFlow.getId(), null);
        this.saveTraceLog(this.context, this.gaiFlow, startAction, startFlowMessage, startTs, inParams);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.gaiFlow.getStart().getId(), e);
    }

    @NotNull
    private Map<String, String> initInParams(StartFlowMessage startFlowMessage, Start startAction) {
        LinkedHashMap<String, String> inParams = new LinkedHashMap<String, String>();
        List<Var> inputVars = startAction.getInputVars();
        if (inputVars != null && !inputVars.isEmpty()) {
            for (Var var : inputVars) {
                if (var.isInput()) {
                    inParams.put(var.getName(), var.getValue());
                    continue;
                }
                inParams.put(var.getName(), "");
                if (StringUtils.equalsIgnoreCase((CharSequence)var.getName(), (CharSequence)"system.chat_sessionid")) {
                    inParams.put("system.chat_sessionid", this.context.getChatSessionId());
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)var.getName(), (CharSequence)"system.chat_environment")) continue;
                inParams.put("system.chat_environment", this.context.getClientType());
            }
        }
        inParams.putAll(startFlowMessage.getInParams());
        return inParams;
    }
}

