/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.application;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.agent.tool.ToolService;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.ToolMessage;
import kd.ai.gai.core.flow.application.BaseNodeApplication;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ToolNodeApplication
extends BaseNodeApplication
implements Application,
DebuggerAction {
    private static final Log log = LogFactory.getLog(ToolNodeApplication.class);
    private Context context;
    private Flow gaiFlow;
    private ToolAction action;
    private int parallelIndex;

    public ToolNodeApplication(Context context, Flow gaiFlow, ToolAction action, int parallelIndex) {
        this.context = context;
        this.gaiFlow = gaiFlow;
        this.action = action;
        this.parallelIndex = parallelIndex;
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    public void compile(VariableScope variableScope) {
    }

    public void invoke(Execution e) {
        long start = System.currentTimeMillis();
        this.initExecEnv(this.context, this.action, this.gaiFlow, e);
        ToolMessage message = this.buildToolMessage(this.context, this.gaiFlow, this.action, e, this.parallelIndex);
        Map<String, Object> toolRequestParams = this.buildToolRequestParams(message);
        BaseResult toolResult = ToolService.toolService(toolRequestParams);
        if (toolResult == null) {
            log.info("flow error result: tool request return NULL");
            throw new KDException(Errors.TOOL_NO_RETURN, new Object[0]);
        }
        if (toolResult.getErrCode().equals(BaseResult.FAILED)) {
            log.info("flow error result {}", (Object)JsonUtil.toJson(toolResult));
            throw new KDException(Errors.TOOL_REQUEST_FAILED, new Object[0]);
        }
        Map<String, String> resultMap = this.buildResultMap(this.action, toolResult);
        FlowUtils.setNodeProperties(e, message.getNodeId(), resultMap);
        this.saveTraceLog(this.context, this.gaiFlow, this.action, message, start, resultMap);
        this.cacheDebugVarValue(this.context, this.gaiFlow, this.action.getId(), e);
    }

    public ToolMessage buildToolMessage(Context context, Flow flow, ToolAction toolAction, Execution e, int parallelIndex) {
        ToolMessage message = new ToolMessage();
        message.setChatSessionId(context.getChatSessionId());
        message.setPageId(context.getBizPageId());
        message.setFlowId(flow.getId());
        message.setNodeId(toolAction.getId());
        message.setToolId(toolAction.getToolId());
        message.setToolType(toolAction.getToolType());
        Map<String, String> params = FlowUtils.buildInputData(context, this.action, e, parallelIndex);
        this.buildCustomInputParams(params, toolAction);
        message.setInputParams(params);
        return message;
    }

    private void buildCustomInputParams(Map<String, String> params, ToolAction toolAction) {
        List<Var> inputVarList = toolAction.getInputVarList();
        if (inputVarList != null) {
            for (Var var : inputVarList) {
                if (!var.isInput()) continue;
                params.put(var.getName(), var.getValue());
            }
        }
    }

    private Map<String, String> buildResultMap(ToolAction toolAction, BaseResult toolResult) {
        List<Var> outputVarList = toolAction.getOutputVarList();
        HashSet<String> outputSet = new HashSet<String>(outputVarList.size());
        for (Var var : outputVarList) {
            outputSet.add(var.getName());
        }
        JSONObject jsonObject = toolResult.getDataAsJSONObject();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (!outputSet.contains(entry.getKey())) continue;
            resultMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return resultMap;
    }

    private Map<String, Object> buildToolRequestParams(ToolMessage message) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("toolId", message.getToolId());
        requestParams.put("type", message.getToolType());
        requestParams.put("chatSessionId", message.getChatSessionId());
        requestParams.put("params", message.getInputParams());
        return requestParams;
    }
}

