/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.ai.gai.core.cache.SessionCache;
import kd.ai.gai.core.domain.vo.DebugInfo;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.biz.IFlowNodeLog;
import kd.ai.gai.core.flow.biz.ParamNodeExecution;
import kd.ai.gai.core.flow.build.attribute.NodeAttribute;
import kd.ai.gai.core.flow.param.dimension.ParamDirection;
import kd.ai.gai.core.trace.entity.FlowNodeLog;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.exception.KDException;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import org.apache.commons.lang3.StringUtils;

public abstract class DebugNodeExecution<T extends Action>
extends ParamNodeExecution<T>
implements DebuggerAction {
    public DebugNodeExecution(Context context, Flow gaiFlow, T action) {
        super(context, gaiFlow, action);
    }

    protected boolean isDebug(Execution e) {
        Object isDebugObj = this.getParamManager().getParamValue(e, 0, "debug_is_debug", ParamDirection.INPUT);
        return isDebugObj != null && Boolean.parseBoolean((String)isDebugObj);
    }

    protected void cacheDebugVarValue(Execution e) {
        if (this.isDebug(e)) {
            String debugResultCacheKey = String.format("%s_%s_%s", "debugProcessResult", RequestContext.get().getCurrUserId(), this.gaiFlow.getDefId());
            Map<String, Object> properties = FlowUtils.getMemoryProperties(e);
            properties.put(FlowUtils.getPropertyName(0, "system.chat_sessionid"), this.context.getChatSessionId());
            DebugInfo debugInfo = (DebugInfo)JSONObject.parseObject((String)FlowUtils.getNodePropertyStr(e, 0, "debug_info"), DebugInfo.class);
            if (StringUtils.isNotEmpty((CharSequence)debugInfo.getDebugNodeId()) && Integer.parseInt(debugInfo.getDebugNodeId()) == this.action.getId()) {
                FlowRuntime runtime = e.getRuntime();
                Map runtimeDoc = runtime.toJson();
                debugInfo.setRuntimeDoc(runtimeDoc);
                debugInfo.setFlowId(this.gaiFlow.getId());
                debugInfo.setSuspend(true);
                FlowUtils.suspend(this.context.getChatSessionId(), this.gaiFlow.getId(), runtime);
            } else {
                debugInfo.setSuspend(false);
            }
            debugInfo.setExecNodeId(this.action.getId());
            properties.put(FlowUtils.getPropertyName(0, "debug_info"), JSONObject.toJSONString((Object)debugInfo));
            SessionCache.get().put(debugResultCacheKey, JSONObject.toJSONString(properties));
        }
    }

    public void onAttachBreakpoint() {
    }

    public void onDetachBreakpoint() {
    }

    protected void saveTraceLog(Execution e, Result result) {
        IFlowNodeLog log = this.getLog(e);
        log.logInputParams(this.getInputParamMap(e));
        log.logOutputParams(this.getOutputParamMap(e));
        log.logEnd(result);
        ((FlowNodeLog)log).getChildLogs().forEach((key, value) -> TraceUtil.saveFlowLog(value));
        TraceUtil.saveFlowLog((FlowNodeLog)log);
    }

    protected void saveErrorTraceLog(Execution e, Throwable error) {
        ErrorCode errorCode;
        if (error != null) {
            if (error instanceof kd.bos.exception.KDException) {
                errorCode = ((kd.bos.exception.KDException)error).getErrorCode();
            } else if (error instanceof KDException) {
                KDException gaiKDException = (KDException)error;
                errorCode = new ErrorCode(gaiKDException.getErrorCode().getCode(), gaiKDException.getMessage());
            } else {
                errorCode = Errors.nodeExecuteError(this.action.getName(), error.getMessage());
            }
        } else {
            errorCode = Errors.OK;
        }
        this.saveTraceLog(e, new Result(errorCode));
    }

    protected void saveNodeTraceLog(Execution e, Event event) {
        Throwable ex;
        Object bRequireTraceLog = e.getDefine().getAttribute(NodeAttribute.REQUIRES_TRACE_LOG.name());
        if (bRequireTraceLog == null || !((Boolean)bRequireTraceLog).booleanValue()) {
            return;
        }
        if (event == Event.ON_COMPLETED) {
            this.saveTraceLog(e, new Result(Errors.OK));
        } else if (event == Event.ON_SUSPENED && (ex = e.getRuntime().getError()) != null) {
            this.saveErrorTraceLog(e, ex);
        }
    }

    protected IFlowNodeLog createLog(Execution e) {
        FlowNodeLog parentLog = (FlowNodeLog)this.getParentLog(e);
        String parentId = parentLog == null ? null : parentLog.getId();
        FlowNodeLog flowNodeLog = FlowNodeLog.create(parentId, this.context, this.gaiFlow, this.action);
        e.setProperty("NODE_LOG", (Object)flowNodeLog);
        this.setParentLog(e, flowNodeLog);
        return flowNodeLog;
    }

    protected IFlowNodeLog getLog(Execution e) {
        if (e == null) {
            return null;
        }
        Execution rootE = this.getNodeRootExecution(e);
        Object nodeLog = rootE.getProperty("NODE_LOG");
        if (nodeLog == null) {
            return this.createLog(rootE);
        }
        return (IFlowNodeLog)nodeLog;
    }

    protected IFlowNodeLog getParentLog(Execution e) {
        Execution parentExecution = e.getParent();
        if (parentExecution == null) {
            return null;
        }
        Object nodeLog = parentExecution.getProperty("CURRENT_PARENT_LOG");
        if (nodeLog == null) {
            return this.getParentLog(parentExecution);
        }
        return (IFlowNodeLog)nodeLog;
    }

    protected void setParentLog(Execution e, IFlowNodeLog log) {
        if (e == null) {
            return;
        }
        Execution rootE = this.getNodeRootExecution(e);
        rootE.setProperty("CURRENT_PARENT_LOG", (Object)log);
    }

    private Execution getNodeRootExecution(Execution e) {
        for (Execution rootE = e; rootE != null; rootE = rootE.getParent()) {
            Object bRequireTraceLog = rootE.getDefine().getAttribute(NodeAttribute.REQUIRES_TRACE_LOG.name());
            if (bRequireTraceLog == null || !((Boolean)bRequireTraceLog).booleanValue()) continue;
            return rootE;
        }
        return e;
    }
}

