/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.biz.application.AbstractNodeApplication;
import kd.ai.gai.core.flow.biz.application.AskUserNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.BatchProcessNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.BillOperateNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.BillQueryNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.BillSaveNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.BreakLoopNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.CodeNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.EndNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.JavaActionNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.LoopNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.MessageNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.PromptNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.QueryEntityNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.RecommendNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.RepoNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.RepoReplyNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.SetVariableNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.StartNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.ToolNodeApplicationImpl;
import kd.ai.gai.core.flow.biz.application.VisionNodeApplicationImpl;

public class NodeApplicationFactory {
    private static final Map<ProcessNodeType, Class<? extends AbstractNodeApplication<? extends Action>>> mapApplication = new HashMap<ProcessNodeType, Class<? extends AbstractNodeApplication<? extends Action>>>();

    public static AbstractNodeApplication<? extends Action> getNodeApplication(Context context, Flow gaiFlow, Action action) {
        Class<?> actionClass = action.getClass();
        Class appclazz = mapApplication.getOrDefault((Object)action.getNodeType(), null);
        if (appclazz == null) {
            System.out.println("No nodeApplication registered for action type: " + actionClass);
            return null;
        }
        try {
            return (AbstractNodeApplication)appclazz.getConstructor(Context.class, Flow.class, actionClass).newInstance(context, gaiFlow, action);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to create nodeApplication of [%s]", actionClass.getSimpleName()), e);
        }
    }

    static {
        mapApplication.put(ProcessNodeType.Start, StartNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.End, EndNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.AskUser, AskUserNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.Code, CodeNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.CusOption, JavaActionNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.Llm, PromptNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.Message, MessageNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.RecommendQuestion, RecommendNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.Repo, RepoNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.RepoReply, RepoReplyNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.SetVariable, SetVariableNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.Tool, ToolNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.BreakLoop, BreakLoopNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.Loop, LoopNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.Parallel, BatchProcessNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.Vision, VisionNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.BILLQUERY, BillQueryNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.QueryEntity, QueryEntityNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.BillOperate, BillOperateNodeApplicationImpl.class);
        mapApplication.put(ProcessNodeType.BILLSave, BillSaveNodeApplicationImpl.class);
    }
}

