/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.biz.callback.AskUserNodeCallbackImpl;
import kd.ai.gai.core.flow.biz.callback.PromptNodeCallbackImpl;
import kd.ai.gai.core.flow.biz.callback.QueryEntityNodeCallbackImpl;
import kd.ai.gai.core.flow.biz.callback.RepoReplyNodeCallbackImpl;
import kd.ai.gai.flow.flow.core.plugin.Callback;

public class NodeCallBackFactory {
    private static final Map<ProcessNodeType, Class<? extends Callback>> mapCallBack = new HashMap<ProcessNodeType, Class<? extends Callback>>(3);

    public static Callback getCallBack(Context context, Flow gaiFlow, Action action) {
        Class<?> actionClass = action.getClass();
        Class callbackClazz = mapCallBack.getOrDefault((Object)action.getNodeType(), null);
        if (callbackClazz == null) {
            return null;
        }
        try {
            return (Callback)callbackClazz.getConstructor(Context.class, Flow.class, actionClass).newInstance(context, gaiFlow, action);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to create NodeCallBack of [%s]", actionClass.getSimpleName()), e);
        }
    }

    static {
        mapCallBack.put(ProcessNodeType.AskUser, AskUserNodeCallbackImpl.class);
        mapCallBack.put(ProcessNodeType.Llm, PromptNodeCallbackImpl.class);
        mapCallBack.put(ProcessNodeType.RepoReply, RepoReplyNodeCallbackImpl.class);
        mapCallBack.put(ProcessNodeType.QueryEntity, QueryEntityNodeCallbackImpl.class);
    }
}

