/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.flow.biz.application;

import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.flow.biz.DebugNodeExecution;
import kd.ai.gai.core.flow.build.attribute.NodeAttribute;
import kd.ai.gai.core.flow.listener.EventParser;
import kd.ai.gai.exception.KDException;
import kd.ai.gai.flow.flow.core.DataArea;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.VariableScope;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.flow.core.plugin.Listener;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractNodeApplication<T extends Action>
extends DebugNodeExecution<T>
implements Application,
Listener {
    private static final Log logger = LogFactory.getLog(AbstractNodeApplication.class);
    public static final String PROPERTY_NODE_ID_AT = "NODE_ID_AT_";
    private static final String PROPERTY_NODE_INDEX = "NODE_INDEX";

    protected AbstractNodeApplication(Context context, Flow gaiFlow, T action) {
        super(context, gaiFlow, action);
    }

    protected abstract void onApplicationInvoke(Execution var1);

    protected void onListenerEvent(Execution e, Event event) {
    }

    protected void flowCancelledJudge(Context context, Execution e) {
        String flowCancelled = FlowCacheData.getCache(context.getChatSessionId(), "flowCancelled");
        if (StringUtils.isNotEmpty((CharSequence)flowCancelled) && Boolean.parseBoolean(flowCancelled)) {
            e.getRuntime().terminate();
        }
    }

    public void compile(VariableScope variableScope) {
    }

    public void execute(Execution e) {
        Event event = EventParser.parse(e.current().getLabel());
        try {
            this.initTraceLog(e, event);
            this.saveNodeAt(e, event);
            this.flowCancelledJudge(this.context, e);
            this.onListenerEvent(e, event);
            this.saveNodeTraceLog(e, event);
        }
        catch (KDException | kd.bos.exception.KDException ex) {
            logger.error(ex);
            this.saveErrorTraceLog(e, ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            this.saveErrorTraceLog(e, ex);
            throw new KDBizException((Throwable)ex, Errors.nodeExecuteError(this.action.getName(), ex.getMessage()), new Object[0]);
        }
        finally {
            if (event == Event.ON_COMPLETED || event == Event.ON_TERMINATED || event == Event.ON_TRANSFERRED) {
                this.clearProperties(e);
            }
            if (event == Event.ON_SUSPENED && e.getRuntime().getError() != null) {
                this.clearProperties(e);
            }
        }
    }

    private void initTraceLog(Execution e, Event event) {
        Object bRequireTraceLog = e.getDefine().getAttribute(NodeAttribute.REQUIRES_TRACE_LOG.name());
        if (bRequireTraceLog == null || !((Boolean)bRequireTraceLog).booleanValue()) {
            return;
        }
        if (event == Event.ON_CREATED) {
            this.createLog(e);
        }
    }

    private void saveNodeAt(Execution e, Event event) {
        if (event == Event.ON_READY) {
            Object currentNodeId;
            DataArea rootMemory = e.getRuntime().getRootMemory();
            Object nodeIndex = rootMemory.getProperty(PROPERTY_NODE_INDEX);
            if (nodeIndex == null) {
                nodeIndex = 1;
            }
            if ((currentNodeId = e.getDefine().getAttribute(NodeAttribute.NODE_ID.name())) != null) {
                rootMemory.setProperty(PROPERTY_NODE_ID_AT + currentNodeId, nodeIndex);
                rootMemory.setProperty(PROPERTY_NODE_INDEX, (Object)((Integer)nodeIndex + 1));
            }
        }
    }

    public void invoke(Execution e) {
        try {
            this.flowCancelledJudge(this.context, e);
            this.onApplicationInvoke(e);
            this.cacheDebugVarValue(e);
        }
        catch (KDException | kd.bos.exception.KDException ex) {
            logger.error(ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException((Throwable)ex, Errors.nodeExecuteError(this.action.getName(), ex.getMessage()), new Object[0]);
        }
    }

    private void clearProperties(Execution e) {
        Map mapProperties = e.getProperties();
        for (Map.Entry entry : mapProperties.entrySet()) {
            e.clearProperty((String)entry.getKey());
        }
    }
}

